/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.permit.util;

import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.permit.service.ISysUsersService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserUtil {
    @Autowired
    private ISysUsersService iSysUsersService;

    public List<JSTreeModel> getUserByRole(String roleId) {
        List<JSTreeModel> list = this.iSysUsersService.getUserTreeByRole(roleId);
        List<JSTreeModel> retList = this.computUserByRole(list);
        this.listOrder(retList);
        return retList;
    }

    public List<JSTreeModel> getLazyUserByRole(Long roleId, Long nodeId) {
        Long newNodeId = nodeId;
        ArrayList<JSTreeModel> jsTreeModels = new ArrayList<JSTreeModel>();
        if (newNodeId.equals(Constants.ROOT_NODE_PARENT)) {
            newNodeId = Constants.ROOT_NODE_ID;
            JSTreeModel root = new JSTreeModel();
            root.setId(Constants.ROOT_NODE_ID);
            root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
            root.setText("\u5173\u8054\u7528\u6237");
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setType("isRoot");
            jsTreeModels.add(root);
        }
        List<JSTreeModel> list = this.iSysUsersService.getLazyUserTreeByRole(roleId);
        ArrayList<JSTreeModel> retList = new ArrayList<JSTreeModel>(this.computUserByRole(list));
        for (JSTreeModel jsTreeModel : retList) {
            if (!jsTreeModel.getParent().equals(newNodeId)) continue;
            jsTreeModels.add(jsTreeModel);
        }
        this.listOrder(jsTreeModels);
        for (JSTreeModel model : jsTreeModels) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return jsTreeModels;
    }

    private List<JSTreeModel> computUserByRole(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> resultList = new ArrayList<JSTreeModel>();
        this.computeUserRecursion(list, resultList, 0L);
        return resultList;
    }

    private void computeUserRecursion(List<JSTreeModel> listData, List<JSTreeModel> resultList, Long pId) {
        for (int i = 0; i < listData.size(); ++i) {
            JSTreeModel tmp;
            if (i > listData.size()) {
                i = 0;
            }
            if (!"USER".equals((tmp = listData.get(i)).getType()) && !pId.equals(tmp.getId())) continue;
            resultList.add(tmp);
            listData.remove(tmp);
            this.computeUserRecursion(listData, resultList, tmp.getParent());
        }
    }

    private void listOrder(List<JSTreeModel> list) {
        Collections.sort(list, new Comparator<JSTreeModel>(){

            @Override
            public int compare(JSTreeModel o1, JSTreeModel o2) {
                if (UserUtil.this.formateObj(o1.getFirstOrder()).compareTo(UserUtil.this.formateObj(o2.getFirstOrder())) == 0) {
                    if (UserUtil.this.formateObj(o1.getStruLevel()).compareTo(UserUtil.this.formateObj(o2.getStruLevel())) == 0) {
                        if (UserUtil.this.formateObj(o1.getStruOrder()).compareTo(UserUtil.this.formateObj(o2.getStruOrder())) == 0) {
                            return UserUtil.this.formateObj(o1.getText()).compareTo(UserUtil.this.formateObj(o2.getText()));
                        }
                        return UserUtil.this.formateObj(o1.getStruOrder()).compareTo(UserUtil.this.formateObj(o2.getStruOrder()));
                    }
                    return UserUtil.this.formateObj(o1.getStruLevel()).compareTo(UserUtil.this.formateObj(o2.getStruLevel()));
                }
                return UserUtil.this.formateObj(o1.getFirstOrder()).compareTo(UserUtil.this.formateObj(o2.getFirstOrder()));
            }
        });
    }

    private String formateObj(Object object) {
        return object == null ? "" : object.toString();
    }
}

