/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.adapter.role;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.adapter.role.IHussarBaseRoleAdapter;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseRoleService;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseStruRoleService;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseUserRoleService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="hussar.sdk-adapter", name={"resource"}, havingValue="iam")
public class IamSdkHussarBaseRoleAdapter
implements IHussarBaseRoleAdapter {
    @Resource
    private HussarBaseRoleService hussarBaseRoleService;
    @Resource
    private HussarBaseStruRoleService hussarBaseStruRoleService;
    @Resource
    private HussarBaseUserRoleService hussarBaseUserRoleService;

    @Override
    public List<JSTreeModel> getLazyRoleTree(Long nodeId) {
        List lazyRoleTree = this.hussarBaseRoleService.getLazyRoleTree(nodeId);
        return JSON.parseArray((String)JSON.toJSONString((Object)lazyRoleTree), JSTreeModel.class);
    }

    @Override
    public List<SysRoles> listByIds(Collection<? extends Serializable> idList) {
        return this.hussarBaseRoleService.listByIds(idList);
    }

    @Override
    public List<Long> getRolesByStruId(Long struId) {
        return this.hussarBaseStruRoleService.roleIdList(struId);
    }

    @Override
    public List<Long> getRolesByUserId(Long userId) {
        return this.hussarBaseUserRoleService.getRolesByUserId(userId);
    }

    @Override
    public List<SysUserRole> getByUserId(Long userId) {
        return this.hussarBaseUserRoleService.getByUserId(userId);
    }

    @Override
    public List<Long> getRoleIdByRoleName(List<String> roleNames) {
        return this.hussarBaseRoleService.getRoleIdByRoleName(roleNames);
    }

    @Override
    public List<Long> getRoleIdByGroupId(List<String> groupNames) {
        return this.hussarBaseRoleService.getRoleIdByGroupId(groupNames);
    }
}

