/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.adapter.role;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.adapter.role.ISysRolesExternalAdapter;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.vo.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.authorization.permit.vo.WorkTempRoleSearchVo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseRoleService;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseUserRoleService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="hussar.sdk-adapter", name={"resource"}, havingValue="iam")
public class IamSdkSysRolesExternalAdapter
implements ISysRolesExternalAdapter {
    @Resource
    private HussarBaseRoleService hussarBaseRoleService;
    @Resource
    private HussarBaseUserRoleService hussarBaseUserRoleService;

    @Override
    public ApiResponse<Long> addAppDevRole(String appName, Long appId) {
        return ApiResponse.success((Object)this.hussarBaseRoleService.addAppDevRole(appName));
    }

    @Override
    public ApiResponse<Boolean> addOrDelAppDevRoleUser(RoleUserDto roleUserDto) {
        return ApiResponse.success((Object)this.hussarBaseUserRoleService.addOrDelAppDevRoleUser(roleUserDto));
    }

    @Override
    public List<RoleVo> getRoleInfoByIds(List<Long> roleIds) {
        return this.hussarBaseRoleService.getRoleInfoByIds(roleIds);
    }

    @Override
    public List<JSTreeModel> loadRoleGruopTree(Long appId) {
        List models = this.hussarBaseRoleService.loadRoleGruopTree(appId);
        return JSON.parseArray((String)JSON.toJSONString((Object)models), JSTreeModel.class);
    }

    @Override
    public List<SysRoles> searchRoleToGroup(Long id, String roleName) {
        return this.hussarBaseRoleService.searchRoleToGroup(id, roleName);
    }

    @Override
    public List<ReadOnlyRoleTreeVo> getRoleTree(Long appId) {
        List roleTree = this.hussarBaseRoleService.getRoleTree();
        return JSON.parseArray((String)JSON.toJSONString((Object)roleTree), ReadOnlyRoleTreeVo.class);
    }

    @Override
    public Boolean delRole(Long id) {
        this.hussarBaseRoleService.deleteDevelopRole(id);
        return Boolean.TRUE;
    }

    @Override
    public List<WorkTempRoleSearchVo> roleSearch(String name, Long appId) {
        List searchVos = this.hussarBaseRoleService.roleSearch(name);
        return JSON.parseArray((String)JSON.toJSONString((Object)searchVos), WorkTempRoleSearchVo.class);
    }

    @Override
    public RoleInfoVO getRoleViewMap(Long id) {
        return this.hussarBaseRoleService.getRoleViewMap(id);
    }

    @Override
    public Boolean updateRole(SysRoles sysRoles) {
        return this.hussarBaseRoleService.updateRole(sysRoles);
    }

    @Override
    public List<SysRoles> getRolesByIds(List<Long> roleIds) {
        return this.hussarBaseRoleService.getRolesByIds(roleIds);
    }

    @Override
    public List<SysRoles> getAllRoles() {
        return this.hussarBaseRoleService.getAllRoles();
    }

    @Override
    public Boolean saveRoleBatch(List<SysRoles> roleList) {
        return this.hussarBaseRoleService.saveRoleBatch(roleList);
    }

    @Override
    public List<SysRoleGroup> selectRoleGroupByIds(List<Long> roleGroupIds) {
        return this.hussarBaseRoleService.selectRoleGroupByIds(roleGroupIds);
    }

    @Override
    public List<SysRoleGroup> getAllRoleGroup() {
        return this.hussarBaseRoleService.getAllRoleGroup();
    }

    @Override
    public Boolean saveRoleGroupBatch(List<SysRoleGroup> roleGroupList) {
        return this.hussarBaseRoleService.saveRoleGroupBatch(roleGroupList);
    }
}

