/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.adapter.function;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.authorization.adapter.function.IHussarBaseFunctionAdapter;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseFunctionResourceService;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseFunctionService;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseResourceService;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseRoleFunctionService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="hussar.sdk-adapter", name={"resource"}, havingValue="iam")
public class IamSdkHussarBaseFunctionAdapter
implements IHussarBaseFunctionAdapter {
    @Resource
    private HussarBaseFunctionService hussarBaseFunctionService;
    @Resource
    private HussarBaseFunctionResourceService hussarBaseFunctionResourceService;
    @Resource
    private HussarBaseRoleFunctionService hussarBaseRoleFunctionService;
    @Resource
    private HussarBaseResourceService hussarBaseResourceService;

    @Override
    public SysFunctions getById(Long id) {
        return this.hussarBaseFunctionService.getById(id);
    }

    @Override
    public Boolean updateById(SysFunctions sysFunctions) {
        return this.hussarBaseFunctionService.updateById(sysFunctions);
    }

    @Override
    public Integer getMaxOrderByParentId(Long moduleId) {
        return this.hussarBaseFunctionService.getMaxOrderByParentId(moduleId);
    }

    @Override
    public Boolean save(SysFunctions sysFunctions) {
        return this.hussarBaseFunctionService.save(sysFunctions);
    }

    @Override
    public Boolean saveModule(SysFunctionModules sysFunctionModules) {
        return this.hussarBaseFunctionService.saveModule(sysFunctionModules);
    }

    @Override
    public List<SysFunctions> listByIds(Collection<? extends Serializable> idList) {
        return this.hussarBaseFunctionService.listByIds(idList);
    }

    @Override
    public List<SysFunctionResources> listByFuncIdAndResId(Long functionId, Long resourceId) {
        return this.hussarBaseFunctionResourceService.list(functionId, resourceId);
    }

    @Override
    public Integer getMaxOrderByParentIdAndAppId(Long moduleId, Long appId) {
        return this.hussarBaseFunctionService.getMaxOrderByParentIdAndAppId(moduleId);
    }

    @Override
    public List<JSTreeModel> getFunModuleMergeTreeForOrg(String functionFlag, Long appId) {
        List iamJSTreeModels = this.hussarBaseFunctionService.getFunModuleMergeTreeForOrg(functionFlag);
        return JSON.parseArray((String)JSON.toJSONString((Object)iamJSTreeModels), JSTreeModel.class);
    }

    @Override
    public SysModuleFunctionsVo getFunctionDetail(Long functionId) {
        return this.hussarBaseFunctionService.getFunctionDetail(functionId);
    }

    @Override
    public List<SysFunctionModules> moduleList(String moduleName, Long parentModuleId, Long appId) {
        return this.hussarBaseFunctionService.moduleList(moduleName, parentModuleId);
    }

    @Override
    public List<SysFunctionResources> listByResIds(List<Long> resIds) {
        return this.hussarBaseFunctionResourceService.listByResIds(resIds);
    }

    @Override
    public List<SysRoleFunctions> listByRoleIds(List<Long> roleIds) {
        return this.hussarBaseRoleFunctionService.listByRoleIds(roleIds);
    }

    @Override
    public Boolean saveBatchFuncRes(List<SysFunctionResources> sysFunctionResources) {
        return this.hussarBaseFunctionResourceService.saveBatch(sysFunctionResources);
    }

    @Override
    public Boolean saveBatchRoleFunc(List<SysRoleFunctions> sysRoleFunctions) {
        return this.hussarBaseRoleFunctionService.saveBatch(sysRoleFunctions);
    }

    @Override
    public List<SysRoleFunctions> listByFuncId(Long functionId) {
        return this.hussarBaseRoleFunctionService.list(functionId);
    }

    @Override
    public List<JSTreeModel> getShortCutMenuTree(List<JSTreeModel> shortCutMenuTree) {
        List functionIds = shortCutMenuTree.stream().map(JSTreeModel::getOrganId).distinct().collect(Collectors.toList());
        List sysFunctions = this.hussarBaseFunctionService.listByIds(functionIds);
        List defaultResIds = sysFunctions.stream().map(SysFunctions::getDefaultResourceId).collect(Collectors.toList());
        List sysResources = this.hussarBaseResourceService.listByIds(defaultResIds);
        Map<Long, SysResources> resMap = sysResources.stream().collect(Collectors.toMap(SysResources::getId, r -> r));
        HashMap<Long, SysResources> funcMap = new HashMap<Long, SysResources>();
        for (SysFunctions function : sysFunctions) {
            Long resId = function.getDefaultResourceId();
            if (!HussarUtils.isNotEmpty((Object)resId) || !HussarUtils.isNotEmpty((Object)resMap.get(resId))) continue;
            funcMap.put(function.getId(), resMap.get(resId));
        }
        for (JSTreeModel model : shortCutMenuTree) {
            SysResources resource = (SysResources)funcMap.get(model.getOrganId());
            if (HussarUtils.isNotEmpty((Object)resource) && HussarUtils.isNotEmpty((Object)resource.getPath())) {
                model.setPath(resource.getPath());
                continue;
            }
            model.setPath("noURL");
        }
        return shortCutMenuTree;
    }

    @Override
    public Boolean saveFuncRes(SysFunctionResources sysFunctionResources) {
        return this.hussarBaseFunctionResourceService.save(sysFunctionResources);
    }

    @Override
    public Map<Long, String> getFullModuleNameMapByName(String moduleName, Long appId) {
        return this.hussarBaseFunctionService.getFullModuleNameMapByName(moduleName);
    }

    @Override
    public String getFullModuleNameById(Long moduleId, Long appId) {
        return this.hussarBaseFunctionService.getFullModuleNameById(moduleId);
    }

    @Override
    public List<SysFunctions> getFunsByAllDefaultRes(Long appId) {
        return this.hussarBaseFunctionService.getFunsByAllDefaultRes();
    }

    @Override
    public Boolean updateModule(SysFunctionModules sysFunctionModules) {
        return this.hussarBaseFunctionService.updateModule(sysFunctionModules);
    }

    @Override
    public SysFunctionModules getModuleByModuleId(Long moduleId) {
        return this.hussarBaseFunctionService.getModuleByModuleId(moduleId);
    }
}

