/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.adapter.resource;

import com.jxdinfo.hussar.authorization.adapter.resource.IHussarBaseResourceAdapter;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.vo.ElementResourceVo;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseFunctionResourceService;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseResourceService;
import com.jxdinfo.hussar.iam.base.sdk.http.service.permission.HussarBaseRoleResourceService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="hussar.sdk-adapter", name={"resource"}, havingValue="iam")
public class IamSdkHussarBaseResourceAdapter
implements IHussarBaseResourceAdapter {
    @Resource
    private HussarBaseResourceService hussarBaseResourceService;
    @Resource
    private HussarBaseRoleResourceService hussarBaseRoleResourceService;
    @Resource
    private HussarBaseFunctionResourceService hussarBaseFunctionResourceService;
    @Resource
    private ISysMenuManageService sysMenuManageService;

    @Override
    public List<SysResources> list() {
        return this.hussarBaseResourceService.list();
    }

    @Override
    public Boolean updateBatchById(List<SysResources> sysResources) {
        return this.hussarBaseResourceService.updateBatchById(sysResources);
    }

    @Override
    public Boolean save(SysResources sysResources) {
        return this.hussarBaseResourceService.save(sysResources);
    }

    @Override
    public Boolean saveModule(SysResourceModules sysResourceModules) {
        return this.hussarBaseResourceService.saveModule(sysResourceModules);
    }

    @Override
    public List<SysResources> listByIds(Collection<? extends Serializable> idList) {
        return this.hussarBaseResourceService.listByIds(idList);
    }

    @Override
    public List<String> queryPermissionsByRoleIds(List<Long> roleIds) {
        return this.hussarBaseResourceService.queryPermissionsByRoleIds(roleIds);
    }

    @Override
    public Integer getMaxOrderByParentId(Long moduleId) {
        return this.hussarBaseResourceService.getMaxOrderByParentId(moduleId);
    }

    @Override
    public List<SysResourceModules> moduleList(String moduleName, Long parentModuleId, Long appId) {
        return this.hussarBaseResourceService.moduleList(moduleName, parentModuleId);
    }

    @Override
    public Integer getMaxOrderByParentIdAndAppId(Long moduleId, Long appId) {
        return this.hussarBaseResourceService.getMaxOrderByParentIdAndAppId(moduleId);
    }

    @Override
    public List<SysRoleResource> listByResIdAndRelationSource(Long resourceId, String relationSource) {
        return this.hussarBaseRoleResourceService.list(resourceId, relationSource);
    }

    @Override
    public List<SysRoleResource> listByRoleIds(List<Long> roleIds) {
        return this.hussarBaseRoleResourceService.listByRoleIds(roleIds);
    }

    @Override
    public Boolean saveBatchRoleRes(List<SysRoleResource> sysRoleResources) {
        return this.hussarBaseRoleResourceService.saveBatch(sysRoleResources);
    }

    @Override
    public List<SysResources> getResourcesByIds(List<Long> roleIdList, String type) {
        List roleResources = this.hussarBaseRoleResourceService.listByRoleIds(roleIdList);
        List resourceIds = roleResources.stream().map(SysRoleResource::getResourceId).distinct().collect(Collectors.toList());
        List<SysResources> resourcesList = this.hussarBaseResourceService.listByIds(resourceIds);
        resourcesList = resourcesList.stream().filter(r -> HussarUtils.isNotEmpty((Object)r.getPath()) && HussarUtils.isNotEmpty((Object)r.getComponent())).collect(Collectors.toList());
        List resIds = resourcesList.stream().map(SysResources::getId).collect(Collectors.toList());
        List sysFunctionResources = this.hussarBaseFunctionResourceService.listByResIds(resIds);
        List functionIds = sysFunctionResources.stream().map(SysFunctionResources::getFunctionId).collect(Collectors.toList());
        List sysMenus = this.sysMenuManageService.getMenusByFunctionIds(functionIds);
        sysMenus = HussarUtils.isNotEmpty((Object)type) && HussarUtils.equals((Object)"1", (Object)type) ? sysMenus.stream().filter(menu -> HussarUtils.equals((Object)"1", (Object)menu.getMenuType()) || HussarUtils.equals((Object)"2", (Object)menu.getMenuType()) || HussarUtils.isEmpty((Object)menu.getMenuType())).collect(Collectors.toList()) : sysMenus.stream().filter(menu -> !HussarUtils.equals((Object)"1", (Object)menu.getMenuType()) && !HussarUtils.equals((Object)"2", (Object)menu.getMenuType()) || HussarUtils.isEmpty((Object)menu.getMenuType())).collect(Collectors.toList());
        Map<Long, List<SysFunctionResources>> funResourcesMap = sysFunctionResources.stream().collect(Collectors.groupingBy(SysFunctionResources::getFunctionId));
        for (SysMenu menu2 : sysMenus) {
            List<SysFunctionResources> functionResources = funResourcesMap.get(menu2.getFunctionId());
            if (HussarUtils.isEmpty(functionResources)) continue;
            Map<Long, SysFunctionResources> resMap = functionResources.stream().collect(Collectors.toMap(SysFunctionResources::getResourceId, f -> f));
            for (SysResources resource : resourcesList) {
                SysFunctionResources funRes = resMap.get(resource.getId());
                if (HussarUtils.isEmpty((Object)funRes)) continue;
                resource.setOpenMode(menu2.getOpenMode());
                resource.setMenuType(menu2.getMenuType());
                resource.setResourceAlias(menu2.getMenuAlias());
                if (!HussarUtils.isNotEmpty((Object)menu2.getText())) continue;
                resource.setResourceName(menu2.getText());
            }
        }
        return resourcesList;
    }

    @Override
    public List<SysResources> getPageAndElementResources(Long moduleId) {
        return this.hussarBaseResourceService.getPageAndElementResources(moduleId);
    }

    @Override
    public List<ElementResourceVo> elementResources(String pagePath, List<Long> roleIds) {
        return this.hussarBaseResourceService.elementResources(pagePath, roleIds);
    }

    @Override
    public Boolean updateById(SysResources sysResources) {
        return this.hussarBaseResourceService.updateById(sysResources);
    }

    @Override
    public SysResources getById(Serializable id) {
        return this.hussarBaseResourceService.getById(id);
    }
}

