/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authentication.enums.AuthenticationEnum;
import com.jxdinfo.hussar.authentication.service.ILocalSysAuthClientModelService;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.platform.core.support.service.dto.ClientModelDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class LocalSysAuthClientModelServiceImpl
implements ILocalSysAuthClientModelService {
    @Resource
    private SysAuthClientModelService sysAuthClientModelService;
    @Resource
    private ISysClientModelService sysClientModelService;

    public SysAuthClientModel getOne(String connName, String clientId, String clientSecret) {
        if (!"hussar-base".equals(clientId)) {
            LambdaQueryWrapper sysClientModelLambdaQueryWrapper = Wrappers.lambdaQuery();
            ((LambdaQueryWrapper)sysClientModelLambdaQueryWrapper.eq(SysClientModel::getClientId, (Object)clientId)).eq(SysClientModel::getApplicationId, (Object)1L);
            SysClientModel sysClientModel = (SysClientModel)this.sysClientModelService.getOne((Wrapper)sysClientModelLambdaQueryWrapper);
            if (HussarUtils.isEmpty((Object)sysClientModel)) {
                return null;
            }
        }
        LambdaQueryWrapper sysAuthClientModelLambdaQueryWrapper = Wrappers.lambdaQuery();
        sysAuthClientModelLambdaQueryWrapper.eq(SysAuthClientModel::getClientId, (Object)clientId);
        return (SysAuthClientModel)this.sysAuthClientModelService.getOne(connName, (Wrapper)sysAuthClientModelLambdaQueryWrapper, false);
    }

    public ClientModelDetails getByClientId(String connName, String clientId, String clientSecret) {
        boolean isHussarBase = "hussar-base".equals(clientId);
        ClientModelDetails oldClientModelDetail = isHussarBase ? (ClientModelDetails)HussarCacheUtil.get((String)"hussar_base_security_client_cache", (Object)("security_client_key:1:" + clientId)) : (ClientModelDetails)HussarCacheUtil.get((String)"security_client_cache", (Object)("security_client_key:1:" + clientId));
        if (HussarUtils.isNotEmpty((Object)oldClientModelDetail)) {
            return oldClientModelDetail;
        }
        SysAuthClientModel one = this.getOne(connName, clientId, clientSecret);
        if (HussarUtils.isEmpty((Object)one)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_FAIL_OBTAIN.getValue()));
        }
        ClientModelDetails clientModelDetails = this.sysAuthClientModelService.getClientModelDetailsByClientModel(one);
        if (isHussarBase) {
            HussarCacheUtil.put((String)"hussar_base_security_client_cache", (Object)("security_client_key:1:" + clientId), (Object)clientModelDetails);
        } else {
            HussarCacheUtil.put((String)"security_client_cache", (Object)("security_client_key:1:" + clientId), (Object)clientModelDetails);
        }
        return clientModelDetails;
    }
}

