/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.enums.AccessType;
import com.jxdinfo.hussar.authentication.enums.AuthenticationEnum;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authentication.util.LoginExceptionMailUtil;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IPageViewConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.exception.BaseDisabledAccountException;
import com.jxdinfo.hussar.common.exception.BaseDormancyException;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseLoginTimeRefuseException;
import com.jxdinfo.hussar.common.exception.BaseTemporaryAccountInvalidException;
import com.jxdinfo.hussar.common.exception.BaseUsernameOrPasswordErrorException;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.enums.AuditSeverityLevel;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class HussarDefaultLoginValidateServiceImpl
implements HussarLoginValidateService {
    @Resource
    private AbstractOTPCredentialsMatcher abstractOtpCredentialsMatcher;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private IPageViewConfigService pageViewConfigService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    private static final Long[] ADMINS = new Long[]{1450756958461300737L, 1450757481235202050L, 1450757527330615298L, 1450757604556025858L, 1450757642371981314L, 679338378499727360L};
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    public String getLoginType() {
        return "default";
    }

    @HussarDs(value="#authcDto.dsName")
    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        this.verifyCode(authcDto);
        return null;
    }

    @HussarDs(value="#authcDto.dsName")
    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
        String loginType = authcDto.getIsIndex();
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersDto);
        if (!Objects.equals(loginType, AccessType.MOBILE.getLoginType()) && this.hussarLoginConfigService.getTotpOpen().booleanValue()) {
            this.checkedTotp(authcDto, sysUsers);
        }
        this.defaultValidateUser(authcDto, sysUsers);
    }

    @HussarDs(value="#authcDto.dsName")
    private void verifyCode(AuthcDto authcDto) {
        String loginType = authcDto.getIsIndex();
        Boolean isKaptcha = Objects.equals(AccessType.INDEX.getLoginType(), loginType) ? this.pageViewConfigService.isLoginViewKaptcha(authcDto.getDsName()) : this.hussarLoginConfigService.getKaptchaOpen(authcDto.getDsName()).booleanValue();
        if (!Objects.equals(loginType, AccessType.MOBILE.getLoginType()) && isKaptcha.booleanValue()) {
            String kaptcha = StringUtils.trimToEmpty((String)authcDto.getKaptcha());
            String cacheName = "KAPTCHA_CODE";
            String kaptchasuffix = StringUtils.trimToEmpty((String)authcDto.getKaptchasuffix());
            String code = (String)HussarFixedCacheUtil.get((String)cacheName, (Object)kaptchasuffix, String.class);
            if (StringUtils.isBlank((CharSequence)code)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_VERIFY_CODE.getValue()));
            }
            HussarFixedCacheUtil.evict((String)cacheName, (Object)kaptchasuffix);
            if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
                BaseException e = new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_CAPTCHA_CODE_ERROR.getValue()));
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_CAPTCHA_CODE_ERROR.getValue()));
                UserDetails userDetails = new UserDetails();
                userDetails.setUserName(authcDto.getUsername());
                HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, authcDto.getDsName(), userDetails);
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
    }

    private void checkedTotp(AuthcDto authcDto, SysUsers sysUsers) {
        String connName = authcDto.getDsName();
        if (!this.abstractOtpCredentialsMatcher.verify(sysUsers.getTotpKey(), authcDto.getTotp(), this.hussarLoginConfigService.getTotpOffsetMin(connName))) {
            BaseException e = new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_DYNAMIC_CODE_ERROR.getValue()));
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_DYNAMIC_CODE_ERROR.getValue()));
            UserDetails userDetails = new UserDetails();
            userDetails.setUserName(authcDto.getUsername());
            HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, authcDto.getDsName(), userDetails);
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private void defaultValidateUser(AuthcDto authcDto, SysUsers sysUsers) {
        String connName = authcDto.getDsName();
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failNumberConfig = iSysBaseConfigService.getSysBaseConfig(connName, "fail_number");
        String tryLoginTime = failNumberConfig.getConfigValue();
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String userName = sysUsers.getUserName();
        String userId = String.valueOf(sysUsers.getId());
        String password = authcDto.getCipher();
        String encPwd = this.credentialsMatcher.passwordEncode(password.getBytes());
        HussarDefaultLoginValidateServiceImpl.handleAccountStatusLocked(authcDto, sysUsers, connName);
        HussarDefaultLoginValidateServiceImpl.handleUserIsLock(authcDto, sysUsers, loginLock, userId, connName);
        if (ToolUtil.isEmpty((Object)encPwd) || !encPwd.equalsIgnoreCase(sysUsers.getPassword()) || password.length() > 16) {
            loginLock.addUserCache(userId, sysUsers.getUserName(), Integer.parseInt(tryLoginTime));
            int loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userId);
            int loginChanceTime = Math.max(loginChance, 0);
            this.handleLoginFail(authcDto, sysUsers, loginChanceTime, userName, connName);
        } else {
            loginLock.removeUserCache(userId);
        }
        HussarDefaultLoginValidateServiceImpl.handleAccountStatusTemporary(authcDto, sysUsers, connName);
        if (!Arrays.asList(ADMINS).contains(sysUsers.getId())) {
            HussarDefaultLoginValidateServiceImpl.handleAccountStatusDormancy(authcDto, sysUsers, connName);
            HussarDefaultLoginValidateServiceImpl.handleLoginTimeLimitByUser(authcDto, sysUsers, connName);
            HussarDefaultLoginValidateServiceImpl.handleLoginTimeLimitByGlobal(authcDto, sysUsers, iSysBaseConfigService, connName);
        }
        this.handleLoginIpLimitByUser(authcDto, sysUsers, connName);
        HussarDefaultLoginValidateServiceImpl.handleLoginIpLimitByGlobal(authcDto, sysUsers, iSysBaseConfigService, connName);
    }

    private static void handleAccountStatusLocked(AuthcDto authcDto, SysUsers sysUsers, String connName) {
        if (sysUsers.getAccountStatus().equals(UserStatus.LOCKED.getCode())) {
            BaseException e = new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_ACCOUNT_FROZEN.getValue()));
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_ACCOUNT_FROZEN.getValue()));
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private static void handleUserIsLock(AuthcDto authcDto, SysUsers sysUsers, LoginLock loginLock, String userId, String connName) {
        if (loginLock.userIsLock(userId)) {
            BaseDisabledAccountException e = new BaseDisabledAccountException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_SECRET_FAIL_LIMIT_EXCEEDED.getValue()));
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_SECRET_FAIL_LIMIT_EXCEEDED.getValue()));
            UserDetails userDetails = new UserDetails();
            HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private void handleLoginFail(AuthcDto authcDto, SysUsers sysUsers, int loginChanceTime, String userName, String connName) {
        if (loginChanceTime == 0) {
            LoginExceptionMailUtil.sendLockMail((String)userName);
            BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_USER_IS_LOCKED.getValue()));
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setSeverityLevel(AuditSeverityLevel.SERIOUS);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_USER_IS_LOCKED.getValue()));
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_WRONG_USERNAME_OR_PASSWORD.getValue()));
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
        auditLogModel.setExceptionInfo((Throwable)e);
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
        auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_WRONG_USERNAME_OR_PASSWORD.getValue()));
        UserDetails userDetails = new UserDetails();
        HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
        userDetails.setUserId(sysUsers.getId());
        userDetails.setUserName(sysUsers.getUserName());
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        throw e;
    }

    private static void handleAccountStatusTemporary(AuthcDto authcDto, SysUsers sysUsers, String connName) {
        LocalDateTime now;
        LocalDateTime beginTime;
        if (UserStatus.TEMPORARY.getCode().equals(sysUsers.getTypeProperty()) && (beginTime = sysUsers.getStartTime()).isAfter(now = Java8DateUtils.currentLocalDateTime())) {
            BaseTemporaryAccountInvalidException e = new BaseTemporaryAccountInvalidException(sysUsers.getUserName() + TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_TEMPORARY_ACCOUNT_INVALID.getValue()));
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_TEMPORARY_ACCOUNT_INVALID.getValue()));
            UserDetails userDetails = new UserDetails();
            HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private static void handleAccountStatusDormancy(AuthcDto authcDto, SysUsers sysUsers, String connName) {
        if (UserStatus.DORMANCY.getCode().equals(sysUsers.getAccountStatus())) {
            BaseDormancyException e = new BaseDormancyException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_ACCOUNT_DORMANCY.getValue()));
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
            UserDetails userDetails = new UserDetails();
            HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private static void handleLoginTimeLimitByUser(AuthcDto authcDto, SysUsers sysUsers, String connName) {
        if ("1".equals(sysUsers.getLoginTimeLimit())) {
            Date now;
            Date dt2;
            Date dt1;
            SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
            boolean flag = false;
            Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            String startTime = Java8DateUtils.convertLocalTimeToString((LocalTime)sysUsers.getAccessLoginStartTime());
            String endTime = Java8DateUtils.convertLocalTimeToString((LocalTime)sysUsers.getAccessLoginEndTime());
            try {
                dt1 = time.parse(startTime);
                dt2 = time.parse(endTime);
                now = time.parse(time.format(date));
            }
            catch (Exception e) {
                BaseException exception = new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_DATE_FORMATTING_ERROR.getValue()));
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_DATE_FORMATTING_ERROR.getValue()));
                UserDetails userDetails = new UserDetails();
                HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw exception;
            }
            HussarDefaultLoginValidateServiceImpl.judgeTimeSlotsAllowed(authcDto, sysUsers, connName, dt1, now, dt2, flag);
        }
    }

    private static void judgeTimeSlotsAllowed(AuthcDto authcDto, SysUsers sysUsers, String connName, Date dt1, Date now, Date dt2, boolean flag) {
        if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
            flag = true;
        }
        if (!flag) {
            BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN_PROHIBITED_TIME.getValue()));
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc(sysUsers.getUserName() + TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN_PROHIBITED_TIME.getValue()));
            UserDetails userDetails = new UserDetails();
            HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private static void handleLoginTimeLimitByGlobal(AuthcDto authcDto, SysUsers sysUsers, ISysBaseConfigService iSysBaseConfigService, String connName) {
        String loginTimeLimt = iSysBaseConfigService.getSysBaseConfig(connName, "login_time_limit").getConfigValue();
        if ("0".equals(sysUsers.getLoginTimeLimit()) && "0".equals(loginTimeLimt)) {
            boolean flag = false;
            LocalTime now = Java8DateUtils.currentLocalTime();
            LocalTime startTime = Java8DateUtils.convertStringToLocalTime((String)iSysBaseConfigService.getSysBaseConfig(connName, "login_start_time").getConfigValue());
            LocalTime endTime = Java8DateUtils.convertStringToLocalTime((String)iSysBaseConfigService.getSysBaseConfig(connName, "login_end_time").getConfigValue());
            if (now.isAfter(startTime) && now.isBefore(endTime)) {
                flag = true;
            }
            if (!flag) {
                BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN_PROHIBITED_TIME.getValue()));
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc(sysUsers.getUserName() + TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN_PROHIBITED_TIME.getValue()));
                UserDetails userDetails = new UserDetails();
                HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
    }

    private void handleLoginIpLimitByUser(AuthcDto authcDto, SysUsers sysUsers, String connName) {
        if (!"1".equals(sysUsers.getLoginIpLimit())) {
            return;
        }
        boolean canLogin = false;
        String loginIp = IpUtils.getIp();
        List list = this.iSysUserIpService.selectUserIp(connName, sysUsers.getId());
        for (String ip : list) {
            if (!StringUtils.equals((CharSequence)loginIp, (CharSequence)ip)) continue;
            canLogin = true;
            break;
        }
        if (!canLogin) {
            LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
            BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN_PROHIBITS_IP.getValue()));
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc(sysUsers.getUserName() + TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN_PROHIBITS_IP.getValue()));
            UserDetails userDetails = new UserDetails();
            HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private static void handleLoginIpLimitByGlobal(AuthcDto authcDto, SysUsers sysUsers, ISysBaseConfigService iSysBaseConfigService, String connName) {
        List<String> forbidIpList;
        List<String> allowIpList;
        SysBaseConfig sysBaseConfig = iSysBaseConfigService.getSysBaseConfig(connName, "login_ip_limit");
        if (HussarUtils.isEmpty((Object)sysBaseConfig) || !"0".equals(sysUsers.getLoginIpLimit()) || !"0".equals(sysBaseConfig.getConfigValue())) {
            return;
        }
        boolean flag = false;
        String loginIp = IpUtils.getIp();
        String allowIp = iSysBaseConfigService.getSysBaseConfig(connName, "allow_login_ip").getConfigValue();
        String forbidIp = iSysBaseConfigService.getSysBaseConfig(connName, "forbid_login_ip").getConfigValue();
        if (ToolUtil.isEmpty((Object)allowIp) && ToolUtil.isEmpty((Object)forbidIp)) {
            flag = true;
        }
        if (ToolUtil.isNotEmpty((Object)allowIp) && ((allowIpList = Arrays.asList(allowIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
            flag = true;
        }
        if (ToolUtil.isNotEmpty((Object)forbidIp) && !flag && (!(forbidIpList = Arrays.asList(forbidIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
            flag = true;
        }
        if (!flag) {
            LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
            BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN_PROHIBITS_IP.getValue()));
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc(sysUsers.getUserName() + TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN_PROHIBITS_IP.getValue()));
            UserDetails userDetails = new UserDetails();
            HussarDefaultLoginValidateServiceImpl.handleTenantInfo(authcDto, connName, userDetails);
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private static void handleTenantInfo(AuthcDto authcDto, String connName, UserDetails userDetails) {
        HussarTenantDefinition hussarTenantDefinition;
        if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
            userDetails.setTenantId(hussarTenantDefinition.getTenantId());
            userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
        }
    }
}

