/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.factory;

import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class HussarLoginFactory
implements ApplicationContextAware {
    private static Logger loger = LogManager.getLogger(HussarLoginFactory.class);
    private static final Map<String, HussarLoginValidateService> MAP = new HashMap<String, HussarLoginValidateService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(HussarLoginValidateService.class);
        this.setBeansToMap(beanMap);
    }

    private void setBeansToMap(Map<String, HussarLoginValidateService> beanMap) {
        for (HussarLoginValidateService loginValidateService : beanMap.values()) {
            MAP.put(loginValidateService.getLoginType(), loginValidateService);
        }
    }

    public static HussarLoginValidateService getLoginValidateService(String loginType) {
        HussarLoginValidateService loginValidateService = MAP.get(loginType);
        loger.info("\u5f53\u524d\u767b\u5f55\u65b9\u5f0f\uff1a{}", (Object)loginType);
        return ToolUtil.isEmpty((Object)loginValidateService) ? MAP.get("default") : loginValidateService;
    }
}

