/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authentication.dao.SysAuthClientModelMapper;
import com.jxdinfo.hussar.authentication.enums.AuthenticationEnum;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.SecureAssesmentProperties;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.ClientModelDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.core.secure.SecuritySecureUtil;
import com.jxdinfo.hussar.support.security.plugin.oauth2.config.SecurityOAuth2Config;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.SysTenantSecure;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantSecureService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysAuthClientModelServiceImpl
extends HussarBaseServiceImpl<SysAuthClientModelMapper, SysAuthClientModel>
implements SysAuthClientModelService {
    @Resource
    private SysAuthClientModelMapper sysAuthClientModelMapper;
    private static final String PRIVATE_KEY = "private";
    private static final String PUBLIC_KEY = "public";
    @Autowired
    private HussarTenantProperties tenantProperties;
    @Resource
    private SecurityOAuth2Config securityOAuth2Config;
    @Resource
    private SecureAssesmentProperties secureAssesmentProperties;

    public IPage<SysAuthClientModel> getClientModelList(Page<SysAuthClientModel> page, SysAuthClientModel authClientModel) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0")).orderByDesc(HussarBaseEntity::getCreateTime);
        return this.sysAuthClientModelMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
    }

    public ApiResponse<SysAuthClientModel> saveAuthClientModel(SysAuthClientModel authClientModel) throws Exception {
        this.checkSaveOrUpdate(authClientModel);
        HashMap keyMap = SecuritySecureUtil.rsaGenerateKeyPair();
        authClientModel.setPrivateKey((String)keyMap.get(PRIVATE_KEY));
        authClientModel.setPublicKey((String)keyMap.get(PUBLIC_KEY));
        Long applicationId = authClientModel.getApplicationId();
        if (applicationId == null || applicationId == 0L) {
            applicationId = 1L;
        }
        if (this.save((BaseEntity)authClientModel)) {
            ClientModelDetails clientModelDetails = this.getClientModelDetailsByClientModel(authClientModel);
            HussarCacheUtil.put((String)"security_client_cache", (Object)("security_client_key:" + applicationId + ":" + authClientModel.getClientId()), (Object)clientModelDetails);
            return ApiResponse.success((Object)authClientModel);
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_SAVE_FAIL.getValue()));
    }

    @HussarDs(value="#connName")
    public ApiResponse<SysAuthClientModel> saveAuthClientModel(String connName, SysAuthClientModel authClientModel) throws Exception {
        long count;
        SysTenantSecure tenantSecure = null;
        if (this.tenantProperties.isEnabled() && HussarUtils.isNotEmpty((Object)(tenantSecure = (SysTenantSecure)((ISysTenantSecureService)SpringContextHolder.getBean(ISysTenantSecureService.class)).getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getClientId, (Object)authClientModel.getClientId())))) && (count = ((ISysTenantSecureService)SpringContextHolder.getBean(ISysTenantSecureService.class)).count((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getClientId, (Object)authClientModel.getClientId()))) > 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_CLIENTID_EXISTS.getValue()));
        }
        this.checkSaveOrUpdate(connName, authClientModel);
        HashMap keyMap = SecuritySecureUtil.rsaGenerateKeyPair();
        authClientModel.setPrivateKey((String)keyMap.get(PRIVATE_KEY));
        authClientModel.setPublicKey((String)keyMap.get(PUBLIC_KEY));
        Long applicationId = authClientModel.getApplicationId();
        if (applicationId == null || applicationId == 0L) {
            applicationId = 1L;
        }
        if (this.save((BaseEntity)authClientModel)) {
            ClientModelDetails clientModelDetails = this.getClientModelDetailsByClientModel(authClientModel);
            HussarCacheUtil.put((String)"security_client_cache", (Object)("security_client_key:" + applicationId + ":" + authClientModel.getClientId()), (Object)clientModelDetails);
            return ApiResponse.success((Object)authClientModel);
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_SAVE_FAIL.getValue()));
    }

    @HussarTransactional
    public ApiResponse<SysAuthClientModel> updateAuthClientModel(SysAuthClientModel authClientModel) {
        SysTenantSecure tenantSecure;
        SysAuthClientModel oldAuthClientModel = (SysAuthClientModel)this.getById(authClientModel.getId());
        String clientId = oldAuthClientModel.getClientId();
        if (this.tenantProperties.isEnabled() && HussarUtils.isNotEmpty((Object)(tenantSecure = (SysTenantSecure)((ISysTenantSecureService)SpringContextHolder.getBean(ISysTenantSecureService.class)).getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getClientId, (Object)clientId)))) && !authClientModel.getClientId().equals(clientId)) {
            long count = ((ISysTenantSecureService)SpringContextHolder.getBean(ISysTenantSecureService.class)).count((Wrapper)new LambdaQueryWrapper().eq(SysTenantSecure::getClientId, (Object)authClientModel.getClientId()));
            if (count > 0L) {
                throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_CLIENTID_EXISTS.getValue()));
            }
            tenantSecure.setClientId(authClientModel.getClientId());
            tenantSecure.setClientSecret(authClientModel.getClientSecret());
            ((ISysTenantSecureService)SpringContextHolder.getBean(ISysTenantSecureService.class)).updateById((Object)tenantSecure);
        }
        this.checkSaveOrUpdate(authClientModel);
        if (super.updateById((BaseEntity)authClientModel)) {
            Long applicationId = authClientModel.getApplicationId();
            if (applicationId == null || applicationId == 0L) {
                applicationId = 1L;
            }
            if ("hussar-base".equals(clientId)) {
                HussarCacheUtil.evict((String)"hussar_base_security_client_cache", (Object)("security_client_key:" + applicationId + ":" + clientId));
            } else {
                HussarCacheUtil.evict((String)"security_client_cache", (Object)("security_client_key:" + applicationId + ":" + clientId));
            }
            return ApiResponse.success((Object)authClientModel);
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_UPDATE_FAILED.getValue()));
    }

    public ApiResponse<SysAuthClientModel> deleteAuthClientModel(Long id) {
        SysAuthClientModel authClientModel = (SysAuthClientModel)this.getById(id);
        if (this.removeById(id)) {
            if (ToolUtil.isNotEmpty((Object)authClientModel)) {
                HussarCacheUtil.evict((String)"security_client_cache", (Object)("security_client_key:1:" + authClientModel.getClientId()));
            }
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_DELETE_SUCCESS.getValue()));
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_DELETE_FAIL.getValue()));
    }

    public ApiResponse<SysAuthClientModel> deleteAuthClientModel(Long id, Long applicationId) {
        SysAuthClientModel authClientModel = (SysAuthClientModel)this.getById(id);
        if (applicationId == null || applicationId == 0L) {
            applicationId = 1L;
        }
        if (this.removeById(id)) {
            if (ToolUtil.isNotEmpty((Object)authClientModel)) {
                HussarCacheUtil.evict((String)"security_client_cache", (Object)("security_client_key:" + applicationId + ":" + authClientModel.getClientId()));
            }
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_DELETE_SUCCESS.getValue()));
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_DELETE_FAIL.getValue()));
    }

    public ApiResponse<SysAuthClientModel> queryAuthClientModelDetail(Long id) {
        return ApiResponse.success((Object)this.getById(id));
    }

    public ApiResponse<String> getPublicKey(String clientId) {
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysAuthClientModel::getClientId, (Object)clientId);
            List list = this.sysAuthClientModelMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                return ApiResponse.success((String)((SysAuthClientModel)list.get(0)).getPublicKey());
            }
        }
        throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_CLIENTID_EMPTY.getValue()));
    }

    private void checkSaveOrUpdate(SysAuthClientModel authClientModel) {
        if (ToolUtil.isNotEmpty((Object)authClientModel.getAccessTokenValidTime())) {
            Long accessTokenValidTime = authClientModel.getAccessTokenValidTime();
            long clientCreateNewTokenThreshold = this.securityOAuth2Config.getClientCreateNewTokenThreshold();
            if (this.secureAssesmentProperties.isOpen() && (accessTokenValidTime <= clientCreateNewTokenThreshold || accessTokenValidTime > 1800L)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_TOKEN_EXPIRED_TIME_LIMIT.getValue()).replace("{}", String.valueOf(clientCreateNewTokenThreshold)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)authClientModel.getClientId())) {
            List ifRepeat;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysAuthClientModel::getClientId, (Object)authClientModel.getClientId());
            if (authClientModel.getId() != null) {
                queryWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.ne(SysAuthClientModel::getId, (Object)authClientModel.getId());
                });
            }
            if ((ifRepeat = this.list((Wrapper)queryWrapper)).size() > 0) {
                throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_CLIENTID_EXISTS.getValue()));
            }
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_CLIENTID_CANNOT_EMPTY.getValue()));
        }
    }

    @HussarDs(value="#connName")
    public void checkSaveOrUpdate(String connName, SysAuthClientModel authClientModel) {
        if (ToolUtil.isNotEmpty((Object)authClientModel.getAccessTokenValidTime())) {
            Long accessTokenValidTime = authClientModel.getAccessTokenValidTime();
            long clientCreateNewTokenThreshold = this.securityOAuth2Config.getClientCreateNewTokenThreshold();
            if (this.secureAssesmentProperties.isOpen() && (accessTokenValidTime <= clientCreateNewTokenThreshold || accessTokenValidTime > 1800L)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_TOKEN_EXPIRED_TIME_LIMIT.getValue()).replace("{}", String.valueOf(clientCreateNewTokenThreshold)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)authClientModel.getClientId())) {
            List ifRepeat;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysAuthClientModel::getClientId, (Object)authClientModel.getClientId());
            if (authClientModel.getId() != null) {
                queryWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.ne(SysAuthClientModel::getId, (Object)authClientModel.getId());
                });
            }
            if ((ifRepeat = this.list(connName, (Wrapper)queryWrapper)).size() > 0) {
                throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_CLIENTID_EXISTS.getValue()));
            }
        } else {
            throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_CLIENTID_CANNOT_EMPTY.getValue()));
        }
    }

    public ClientModelDetails getClientModelDetailsByClientModel(SysAuthClientModel authClientModel) {
        ClientModelDetails clientModelDetails = new ClientModelDetails();
        clientModelDetails.setClientId(authClientModel.getClientId());
        clientModelDetails.setClientSecret(authClientModel.getClientSecret());
        if (StringUtils.isNotBlank((CharSequence)authClientModel.getContractScope())) {
            clientModelDetails.setContractScope(authClientModel.getContractScope().split(","));
        }
        clientModelDetails.setAllowUrl(authClientModel.getAllowUrl());
        clientModelDetails.setAccessTokenValidTime(authClientModel.getAccessTokenValidTime());
        clientModelDetails.setRefreshTokenValidTime(authClientModel.getRefreshTokenValidTime());
        clientModelDetails.setPublicKey(authClientModel.getPublicKey());
        clientModelDetails.setPrivateKey(authClientModel.getPrivateKey());
        clientModelDetails.setGrantTypes(authClientModel.getAuthorizedGrantType().split(","));
        return clientModelDetails;
    }
}

