/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.controller;

import com.google.code.kaptcha.Producer;
import com.jxdinfo.hussar.authentication.enums.AuthenticationEnum;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.FileUtil;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.utils.TranslateUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/kaptcha"})
@Api(tags={"\u9a8c\u8bc1\u7801\u751f\u6210"})
public class KaptchaController {
    private static Logger logger = LoggerFactory.getLogger(KaptchaController.class);
    @Resource
    private HussarConfig hussarConfig;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Autowired
    Producer producer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={""})
    @ApiOperation(value="\u751f\u6210\u9a8c\u8bc1\u7801", notes="\u751f\u6210\u9a8c\u8bc1\u7801")
    @Inner
    @AuditLog(moduleName="\u751f\u6210\u9a8c\u8bc1\u7801", eventDesc="\u751f\u6210\u9a8c\u8bc1\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void index(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        response.setDateHeader("Expires", 0L);
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("image/jpeg");
        String capText = this.producer.createText();
        String kaptchasuffix = request.getParameter("kaptchasuffix");
        if (StringUtils.isBlank((CharSequence)kaptchasuffix)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_ERR_CAPTCHA_REFRESH.getValue()));
        }
        Long seconds = (long)this.hussarBaseProperties.getKaptchaExpire().intValue() * 60L;
        HussarFixedCacheUtil.put((String)"KAPTCHA_CODE", (Object)kaptchasuffix, (Object)capText, (long)seconds);
        session.setAttribute("KAPTCHA_SESSION_KEY", (Object)capText);
        BufferedImage bi = this.producer.createImage(capText);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        try {
            ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)out);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        try {
            try {
                if (out != null) {
                    out.flush();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
    }

    @GetMapping(value={"/{pictureId}"})
    @ApiOperation(value="\u8fd4\u56de\u56fe\u7247", notes="\u8fd4\u56de\u56fe\u7247")
    @AuditLog(moduleName="\u751f\u6210\u9a8c\u8bc1\u7801", eventDesc="\u8fd4\u56de\u56fe\u7247", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void renderPicture(@ApiParam(value="\u56fe\u7247id") @PathVariable(value="pictureId") String pictureId, HttpServletResponse response) {
        String path = this.hussarConfig.getFileUploadPath() + pictureId + ".jpg";
        try {
            byte[] bytes = FileUtil.toByteArray((String)path);
            response.getOutputStream().write(bytes);
        }
        catch (IOException e) {
            try {
                response.sendRedirect("/static/img/default.png");
            }
            catch (IOException ex) {
                logger.error(e.getMessage());
            }
        }
    }
}

