/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.service.AuthcService;
import com.jxdinfo.hussar.authentication.service.IHussatAuthTenantService;
import com.jxdinfo.hussar.authentication.vo.LoginInfoVo;
import com.jxdinfo.hussar.authentication.vo.LoginTypeVo;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.unify.authentication.client.properties.UnifyAuthenticationClientProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AuthcServiceImpl
implements AuthcService {
    private static Logger logger = LoggerFactory.getLogger(AuthcServiceImpl.class);
    private static Long GRADE_SYSTEMADMIN_ROLE = 1450715195867925063L;
    private static Long GRADE_SECAUDITADMIN_ROLE = 145078193586892596L;
    private static Long GRADE_SECURITYADMIN_ROLE = 1450785935166925011L;
    private static Long SECAUDITADMIN_ROLE = 1450785135866925061L;
    private static Long SYSTEMADMIN_ROLE = 1450785135866925067L;
    private static Long SECURITYADMIN_ROLE = 1450785135866925068L;
    private static final List<Long> rolesAdminList = new ArrayList<Long>();
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private IHussarPwdConfigService pwdConfigService;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Resource
    private IHussatAuthTenantService hussatAuthTenantService;

    @HussarDs(value="#connName")
    private ApiResponse<LoginInfoVo> changeTempDs(String connName, AuthcDto authcDto) {
        authcDto.setDsName(connName);
        return ApiResponse.success((Object)new LoginInfoVo());
    }

    public void logout() {
        SecurityUtil.logout();
    }

    public ApiResponse<Map<String, String>> check() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.pwdConfigService.isAllowChangePwd() && this.pwdConfigService.isForceChangePwd()) {
            SysUsers sysUser = this.iSysUsersService.getById(shiroUser.getId());
            if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
                map.put("allowChange", "YES");
                map.put("firstLogin", "NO");
                map.put("changePwd", "NO");
                return ApiResponse.success(map);
            }
            map.put("allowChange", "YES");
            if (this.iSysUsersService.isFirstLogin(shiroUser.getId())) {
                map.put("firstLogin", "YES");
            } else {
                map.put("firstLogin", "NO");
            }
            if (this.iSysUsersService.isPwdOverdue(shiroUser.getId())) {
                map.put("changePwd", "YES");
            } else {
                map.put("changePwd", "NO");
            }
        } else if (this.pwdConfigService.isAllowChangePwd() && !this.pwdConfigService.isForceChangePwd()) {
            map.put("allowChange", "YES");
            map.put("firstLogin", "NO");
            map.put("changePwd", "NO");
        } else if (!this.pwdConfigService.isAllowChangePwd()) {
            map.put("allowChange", "NO");
            map.put("firstLogin", "NO");
            map.put("changePwd", "NO");
        }
        return ApiResponse.success(map);
    }

    public ApiResponse<Map<String, Object>> getShow() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        List sysBaseConfigs = this.sysBaseConfigService.getTotpCaptchaConfigList();
        if (ToolUtil.isNotEmpty((Object)sysBaseConfigs)) {
            Map configMap = sysBaseConfigs.stream().collect(Collectors.toMap(SysBaseConfig::getConfigKey, Function.identity()));
            SysBaseConfig topTOpen = (SysBaseConfig)configMap.get("totp_open");
            SysBaseConfig kaptchaOpen = (SysBaseConfig)configMap.get("kaptcha_open");
            SysBaseConfig loginViewKaptcha = (SysBaseConfig)configMap.get("login_view_kaptcha");
            map.put("totp", topTOpen == null ? false : "0".equals(topTOpen.getConfigValue()));
            map.put("kaptcha", kaptchaOpen == null ? false : "0".equals(kaptchaOpen.getConfigValue()));
            map.put("indexKaptcha", loginViewKaptcha == null ? false : "0".equals(loginViewKaptcha.getConfigValue()));
        }
        return ApiResponse.success(map);
    }

    public ApiResponse<SecurityUser> queryLoginUserInfo(AuthcDto authcDto) {
        boolean status;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysBaseConfig protectStatus = this.baseConfigService.getSysBaseConfig("protection_status");
        boolean bl = status = protectStatus != null && "3".equals(protectStatus.getConfigValue());
        if (!status && securityUser != null) {
            securityUser.setSecurityLevel(Integer.valueOf(0));
            securityUser.addExtendUserMap("securityLevel", (Object)0);
        }
        securityUser.addExtendUserMap("permissions", (Object)HussarSecurityUtils.getPermissions());
        return ApiResponse.success((Object)securityUser);
    }

    public ApiResponse<LoginTypeVo> getLoginType() {
        UnifyAuthenticationClientProperties unifyProperties;
        try {
            unifyProperties = (UnifyAuthenticationClientProperties)SpringContextHolder.getBean(UnifyAuthenticationClientProperties.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            unifyProperties = null;
        }
        boolean type = ToolUtil.isNotEmpty((Object)unifyProperties) && unifyProperties.isEnable();
        LoginTypeVo loginType = new LoginTypeVo();
        if (type) {
            loginType.setLoginType("ssoLogin");
        } else {
            loginType.setLoginType("default");
        }
        return ApiResponse.success((Object)loginType);
    }

    static {
        rolesAdminList.add(GRADE_SYSTEMADMIN_ROLE);
        rolesAdminList.add(GRADE_SECAUDITADMIN_ROLE);
        rolesAdminList.add(GRADE_SECURITYADMIN_ROLE);
        rolesAdminList.add(SECAUDITADMIN_ROLE);
        rolesAdminList.add(SYSTEMADMIN_ROLE);
        rolesAdminList.add(SECURITYADMIN_ROLE);
    }
}

