/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.controller;

import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import com.jxdinfo.hussar.unify.authentication.client.dto.RestLoginDTO;
import com.jxdinfo.hussar.unify.authentication.client.service.AbstractUnifyAuthenticationService;
import io.swagger.annotations.Api;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/frontLogin/unify/oauth2"})
@Api(tags={"\u5bf9\u79fb\u52a8\u63d0\u4f9b\u7684\u767b\u5f55\u63a5\u53e3"})
@ConditionalOnProperty(prefix="hussar.unify.authentication", name={"enable"}, havingValue="true")
public class UnifyAuthLoginController {
    @Resource
    private AbstractUnifyAuthenticationService unifyAuthenticationService;
    @Resource
    private PasswordEncryptService passwordEncryptService;

    @PostMapping(value={"/login"})
    public ApiResponse login(@RequestBody RestLoginDTO loginDTO, HttpServletRequest request) {
        String pwd = HussarUtils.isEmpty((Object)loginDTO.getPassword()) ? "" : loginDTO.getPassword();
        loginDTO.setPassword(this.passwordEncryptService.decrypt(pwd));
        return ApiResponse.success((Object)this.unifyAuthenticationService.login(loginDTO, request));
    }

    @PostMapping(value={"/logout"})
    public ApiResponse logout(HttpSession session, HttpServletRequest request) {
        this.unifyAuthenticationService.logout(request);
        session.invalidate();
        return ApiResponse.success();
    }
}

