/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.factory.HussarLoginFactory;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.authentication.service.IExtendUserDetailService;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.theme.service.IThemeService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.properties.HussarDynamicProperties;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@HussarTokenDs
@Service
public class HussarLoginBaseServiceImpl
implements HussarLoginService {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysWelcomeService sysWelcomeService;
    @Resource
    private IHussarBaseUserIdentityService userIdentityService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private IExtendUserDetailService extendUserDetailService;
    private static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Resource
    private HussarDynamicProperties hussarDynamicProperties;
    @Resource
    private ISysApplicationService sysApplicationService;

    public UserDetails login(AuthcDto authcDto) {
        SysUsers sysUsers;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ToolUtil.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
        String loginType = authcDto.getLoginType();
        String loginCode = authcDto.getLoginCode();
        boolean tenantOpen = this.hussarTenantProperties.isEnabled() && this.tenantCommonService != null;
        DefaultTenant hussarTenantDefinition = new DefaultTenant();
        if (ToolUtil.isNotEmpty((Object)request)) {
            if (HussarUtils.isEmpty((Object)loginType) || HussarUtils.isEmpty((Object)loginCode)) {
                loginType = request.getHeader("loginType");
                loginCode = request.getHeader("loginCode");
            }
            if (tenantOpen) {
                hussarTenantDefinition = this.tenantCommonService.parse();
                Optional.ofNullable(hussarTenantDefinition).ifPresent(e -> {
                    this.checkTeant((HussarTenantDefinition)e);
                    authcDto.setTenantCode(e.getTenantCode());
                    authcDto.setDsName(e.getConnName());
                    if (!this.hussarTenantProperties.getType().equals("url") && !this.hussarTenantProperties.getType().equals("domain")) {
                        authcDto.setDsName("master");
                    }
                });
            } else {
                authcDto.setTenantCode("master");
                authcDto.setDsName("master");
            }
        }
        if (ToolUtil.isEmpty((Object)loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").beforeSelectUser(request, loginCode, authcDto);
        } else {
            String username = HussarLoginFactory.getLoginValidateService(loginType).beforeSelectUser(request, loginCode, authcDto);
            if (ToolUtil.isNotEmpty((Object)username)) {
                authcDto.setUsername(username);
            }
        }
        String account = authcDto.getUsername();
        if (!this.hussarLoginConfigService.getLoginUpperOpen(authcDto.getDsName()).booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)authcDto.getUsername())) {
            account = authcDto.getUsername().toUpperCase();
        }
        if (ToolUtil.isEmpty((Object)(sysUsers = this.iSysUsersService.getUserByAccountAndStatus(authcDto.getDsName(), account, (List)Lists.newArrayList((Object[])new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode(), UserStatus.DORMANCY.getCode()}))))) {
            sysUsers = new SysUsers();
            sysUsers.setUserName(authcDto.getUsername());
            this.throwExceptionPersionally(authcDto, sysUsers, BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
        } else if (this.hussarLoginConfigService.getLoginUpperOpen(authcDto.getDsName()).booleanValue() && !authcDto.getUsername().equals(sysUsers.getUserAccount())) {
            this.throwExceptionPersionally(authcDto, sysUsers, BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
        }
        SysUsersDto sysUsersDto = new SysUsersDto();
        CopyPropertieUtils.copyProperties((Object)sysUsersDto, (Object)sysUsers);
        if (ToolUtil.isEmpty((Object)loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").validateUser(authcDto, sysUsersDto);
        } else {
            HussarLoginFactory.getLoginValidateService(loginType).validateUser(authcDto, sysUsersDto);
        }
        UserDetails userDetails = this.getLoginSecurityUser(tenantOpen, (HussarTenantDefinition)hussarTenantDefinition, sysUsers);
        if (ToolUtil.isNotEmpty((Object)userDetails)) {
            sysUsers.setLastLoginTime(Java8DateUtils.currentLocalDateTime());
            sysUsers.setLastEditor(userDetails.getUserId());
            sysUsers.setLastTime(LocalDateTime.now());
            this.iSysUsersService.updateById(authcDto.getDsName(), (Object)sysUsers);
        }
        return userDetails;
    }

    private void checkTeant(HussarTenantDefinition tenantInfo) {
        if (StringUtils.isNotBlank((CharSequence)tenantInfo.getTenantCode()) && !tenantInfo.getConnName().equals("master")) {
            Boolean timeLimit = tenantInfo.getTimeLimit();
            LocalDateTime startTime = tenantInfo.getStartTime();
            LocalDateTime endTime = tenantInfo.getEndTime();
            String tenantStatus = tenantInfo.getTenantStatus();
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("0"), (String)"\u79df\u6237\u5df2\u5220\u9664");
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("2"), (String)"\u79df\u6237\u5df2\u5931\u6548");
            AssertUtil.isFalse((tenantStatus.equalsIgnoreCase("3") || tenantStatus.equalsIgnoreCase("4") ? 1 : 0) != 0, (String)"\u79df\u6237\u4e0d\u53ef\u7528");
            AssertUtil.isFalse((timeLimit != false && endTime.isBefore(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)"\u79df\u6237\u5df2\u5931\u6548");
            AssertUtil.isFalse((timeLimit != false && startTime.isAfter(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)"\u79df\u6237\u672a\u751f\u6548");
        }
    }

    private void throwExceptionPersionally(AuthcDto authcDto, SysUsers sysUsers, String message) {
        HussarTenantDefinition hussarTenantDefinition;
        BaseException e = new BaseException(message);
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName("\u767b\u5f55");
        auditLogModel.setExceptionInfo((Throwable)e);
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
        auditLogModel.setEventDesc(message);
        UserDetails userDetails = new UserDetails();
        if (sysUsers.getId() != null) {
            userDetails.setUserId(sysUsers.getId());
        }
        if (HussarUtils.isNotBlank((CharSequence)authcDto.getDsName()) && !authcDto.getDsName().equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
            userDetails.setTenantId(hussarTenantDefinition.getTenantId());
            userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
        }
        userDetails.setUserName(sysUsers.getUserName());
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        throw e;
    }

    private UserDetails getLoginSecurityUser(boolean tenantOpen, HussarTenantDefinition tenantInfo, SysUsers sysUsers) {
        UserDetails userDetails = new UserDetails();
        userDetails.setUserId(sysUsers.getId());
        if (tenantOpen && HussarUtils.isNotEmpty((Object)tenantInfo)) {
            userDetails.addExtendUserMap(this.hussarDynamicProperties.getDatasourceKeyByHeader(), (Object)tenantInfo.getConnName());
            userDetails.setTenantId(tenantInfo.getTenantId());
            userDetails.setTenantCode(tenantInfo.getTenantCode());
            userDetails.addExtendUserMap("tenantName", (Object)tenantInfo.getTenantName());
            userDetails.addExtendUserMap("tcode", (Object)tenantInfo.getTenantCode());
            userDetails.addExtendUserMap("connName", (Object)tenantInfo.getConnName());
            userDetails.addExtendUserMap("gitUrl", (Object)tenantInfo.getGitUrl());
            userDetails.addExtendUserMap("gitToken", (Object)tenantInfo.getGitToken());
            userDetails.setTenantCode(tenantInfo.getTenantCode());
        }
        userDetails.addExtendUserMap("account", (Object)sysUsers.getUserAccount());
        userDetails.setUserName(sysUsers.getUserName());
        userDetails.addExtendUserMap("securityLevel", (Object)sysUsers.getSecurityLevel());
        userDetails.addExtendUserMap("accountStatus", (Object)sysUsers.getAccountStatus());
        userDetails.setMaxSameCount(Integer.valueOf(sysUsers.getMaxSessions()));
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getById((Serializable)Long.valueOf(1L));
        Long appId = null != sysApplication ? Long.valueOf(1L) : null;
        userDetails = this.userIdentityService.handleUserIdentity(userDetails, appId);
        List roleIds = (List)userDetails.getExtendUserMap("rolesList");
        userDetails.addExtendUserMap("theme", (Object)this.themeService.queryUserThemeWithUserId(sysUsers.getId()));
        ArrayList<Long> roleList = new ArrayList<Long>(roleIds);
        roleList.add(userDetails.getUserId());
        userDetails.addExtendUserMap("welcomeUrl", (Object)this.sysWelcomeService.getUserIndex(roleList));
        Map customExtendMap = this.extendUserDetailService.generateExtendMap(userDetails.getUserId());
        if (HussarUtils.isNotEmpty((Object)customExtendMap)) {
            for (Map.Entry entry : customExtendMap.entrySet()) {
                userDetails.addExtendUserMap((String)entry.getKey(), entry.getValue());
            }
        }
        return userDetails;
    }
}

