/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.enums.AccessType;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authentication.util.LoginExceptionMailUtil;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IPageViewConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.exception.BaseDisabledAccountException;
import com.jxdinfo.hussar.common.exception.BaseDormancyException;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.exception.BaseLoginTimeRefuseException;
import com.jxdinfo.hussar.common.exception.BaseTemporaryAccountInvalidException;
import com.jxdinfo.hussar.common.exception.BaseUsernameOrPasswordErrorException;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class HussarDefaultLoginValidateServiceImpl
implements HussarLoginValidateService {
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private IPageViewConfigService pageViewConfigService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    private static final Long[] ADMINS = new Long[]{1450756958461300737L, 1450757481235202050L, 1450757527330615298L, 1450757604556025858L, 1450757642371981314L, 679338378499727360L};
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    public String getLoginType() {
        return "default";
    }

    @HussarDs(value="#authcDto.dsName")
    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        this.verifyCode(authcDto);
        return null;
    }

    @HussarDs(value="#authcDto.dsName")
    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
        String loginType = authcDto.getIsIndex();
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersDto);
        if (!Objects.equals(loginType, AccessType.MOBILE.getLoginType()) && this.hussarLoginConfigService.getTotpOpen().booleanValue()) {
            this.checkedTotp(authcDto, sysUsers);
        }
        this.defaultValidateUser(authcDto, sysUsers);
    }

    @HussarDs(value="#authcDto.dsName")
    private void verifyCode(AuthcDto authcDto) {
        String loginType = authcDto.getIsIndex();
        Boolean isKaptcha = Objects.equals(AccessType.INDEX.getLoginType(), loginType) ? this.pageViewConfigService.isLoginViewKaptcha(authcDto.getDsName()) : this.hussarLoginConfigService.getKaptchaOpen(authcDto.getDsName()).booleanValue();
        if (!Objects.equals(loginType, AccessType.MOBILE.getLoginType()) && isKaptcha.booleanValue()) {
            String kaptcha = StringUtils.trimToEmpty((String)authcDto.getKaptcha());
            String cacheName = "KAPTCHA_CODE";
            String kaptchasuffix = StringUtils.trimToEmpty((String)authcDto.getKaptchasuffix());
            String code = (String)HussarFixedCacheUtil.get((String)cacheName, (Object)kaptchasuffix, String.class);
            if (StringUtils.isBlank((CharSequence)code)) {
                throw new BaseException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
            }
            HussarFixedCacheUtil.evict((String)cacheName, (Object)kaptchasuffix);
            if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
                HussarTenantDefinition hussarTenantDefinition;
                BaseException e = new BaseException("\u9a8c\u8bc1\u7801\u9519\u8bef");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u9a8c\u8bc1\u7801\u9519\u8bef");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserName(authcDto.getUsername());
                if (HussarUtils.isNotBlank((CharSequence)authcDto.getDsName()) && !authcDto.getDsName().equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                    userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                    userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                }
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
    }

    private void checkedTotp(AuthcDto authcDto, SysUsers sysUsers) {
        String connName = authcDto.getDsName();
        if (!this.abstractOTPCredentialsMatcher.verify(sysUsers.getTotpKey(), authcDto.getTotp(), this.hussarLoginConfigService.getTotpOffsetMin(connName))) {
            HussarTenantDefinition hussarTenantDefinition;
            BaseException e = new BaseException("\u52a8\u6001\u7801\u9519\u8bef");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u52a8\u6001\u7801\u9519\u8bef");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserName(authcDto.getUsername());
            if (HussarUtils.isNotBlank((CharSequence)authcDto.getDsName()) && !authcDto.getDsName().equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
            }
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private void defaultValidateUser(AuthcDto authcDto, SysUsers sysUsers) {
        SysBaseConfig sysBaseConfig;
        Comparable<ChronoLocalDateTime<?>> now;
        String connName = authcDto.getDsName();
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failNumberConfig = iSysBaseConfigService.getSysBaseConfig(connName, "fail_number");
        String tryLoginTime = failNumberConfig.getConfigValue();
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String userName = sysUsers.getUserName();
        String userId = String.valueOf(sysUsers.getId());
        String password = authcDto.getCipher();
        String encPwd = this.credentialsMatcher.passwordEncode(password.getBytes());
        if (sysUsers.getAccountStatus().equals(UserStatus.LOCKED.getCode())) {
            HussarTenantDefinition hussarTenantDefinition;
            BaseException e = new BaseException("\u8d26\u6237\u5df2\u51bb\u7ed3\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u8d26\u6237\u5df2\u51bb\u7ed3\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
            }
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (loginLock.userIsLock(userId)) {
            HussarTenantDefinition hussarTenantDefinition;
            BaseDisabledAccountException e = new BaseDisabledAccountException("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
            UserDetails userDetails = new UserDetails();
            if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
            }
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (ToolUtil.isEmpty((Object)encPwd) || !encPwd.equalsIgnoreCase(sysUsers.getPassword()) || password.length() > 16) {
            HussarTenantDefinition hussarTenantDefinition;
            int loginChanceTime;
            loginLock.addUserCache(userId, sysUsers.getUserName(), Integer.parseInt(tryLoginTime));
            int loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userId);
            int n = loginChanceTime = loginChance < 0 ? 0 : loginChance;
            if (loginChanceTime == 0) {
                HussarTenantDefinition hussarTenantDefinition2;
                Executor threadExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
                threadExecutor.execute(() -> LoginExceptionMailUtil.sendLockMail((String)userName));
                BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException("\u5f53\u524d\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u5f53\u524d\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition2 = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                    userDetails.setTenantId(hussarTenantDefinition2.getTenantId());
                    userDetails.setTenantCode(hussarTenantDefinition2.getTenantCode());
                }
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
            BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a\uff01");
            UserDetails userDetails = new UserDetails();
            if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
            }
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        loginLock.removeUserCache(userId);
        if (UserStatus.TEMPORARY.getCode().equals(sysUsers.getTypeProperty())) {
            LocalDateTime beginTime = sysUsers.getStartTime();
            LocalDateTime endTime = sysUsers.getExpiredTime();
            now = Java8DateUtils.currentLocalDateTime();
            if (beginTime.isAfter((ChronoLocalDateTime<?>)now)) {
                HussarTenantDefinition hussarTenantDefinition;
                BaseTemporaryAccountInvalidException e = new BaseTemporaryAccountInvalidException(sysUsers.getUserName() + BaseExceptionEnum.TEMPORARYACCOUNT_INVALID.getMessage());
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u4e34\u65f6\u8d26\u6237\u672a\u5728\u6709\u6548\u671f\uff01");
                UserDetails userDetails = new UserDetails();
                if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                    userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                    userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                }
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
        if (!Arrays.asList(ADMINS).contains(sysUsers.getId())) {
            if (UserStatus.DORMANCY.getCode().equals(sysUsers.getAccountStatus())) {
                HussarTenantDefinition hussarTenantDefinition;
                BaseDormancyException e = new BaseDormancyException(sysUsers.getUserName() + BaseExceptionEnum.ACCOUNT_DORMANCY.getMessage());
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u8d26\u6237\u5df2\u4f11\u7720\uff01");
                UserDetails userDetails = new UserDetails();
                if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                    userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                    userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                }
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
            if ("1".equals(sysUsers.getLoginTimeLimit())) {
                Date now2 = null;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
                boolean flag = false;
                Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                String startTime = Java8DateUtils.convertLocalTimeToString((LocalTime)sysUsers.getAccessLoginStartTime());
                String endTime = Java8DateUtils.convertLocalTimeToString((LocalTime)sysUsers.getAccessLoginEndTime());
                Date dt1 = null;
                Date dt2 = null;
                try {
                    dt1 = time.parse(startTime);
                    dt2 = time.parse(endTime);
                    now2 = time.parse(time.format(date));
                }
                catch (Exception e) {
                    HussarTenantDefinition hussarTenantDefinition;
                    BaseException exception = new BaseException("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    UserDetails userDetails = new UserDetails();
                    if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                        userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                        userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                    }
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw exception;
                }
                if (dt1.getTime() <= now2.getTime() && now2.getTime() <= dt2.getTime()) {
                    flag = true;
                }
                if (!flag) {
                    HussarTenantDefinition hussarTenantDefinition;
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                        userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                        userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                    }
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
            String loginTimeLimt = iSysBaseConfigService.getSysBaseConfig(connName, "login_time_limit").getConfigValue();
            if ("0".equals(sysUsers.getLoginTimeLimit()) && "0".equals(loginTimeLimt)) {
                boolean flag = false;
                now = Java8DateUtils.currentLocalTime();
                LocalTime startTime = Java8DateUtils.convertStringToLocalTime((String)iSysBaseConfigService.getSysBaseConfig(connName, "login_start_time").getConfigValue());
                LocalTime endTime = Java8DateUtils.convertStringToLocalTime((String)iSysBaseConfigService.getSysBaseConfig(connName, "login_end_time").getConfigValue());
                if (((LocalTime)now).isAfter(startTime) && endTime.isAfter((LocalTime)now)) {
                    flag = true;
                }
                if (!flag) {
                    HussarTenantDefinition hussarTenantDefinition;
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                        userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                        userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                    }
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
        }
        if ("1".equals(sysUsers.getLoginIpLimit())) {
            boolean canLogin = false;
            String loginIp = IpUtils.getIp();
            List list = this.iSysUserIpService.selectUserIp(connName, sysUsers.getId());
            for (String ip : list) {
                if (!StringUtils.equals((CharSequence)loginIp, (CharSequence)ip)) continue;
                canLogin = true;
                break;
            }
            if (!canLogin) {
                HussarTenantDefinition hussarTenantDefinition;
                LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                UserDetails userDetails = new UserDetails();
                if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                    userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                    userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                }
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
        if (ToolUtil.isNotEmpty((Object)(sysBaseConfig = iSysBaseConfigService.getSysBaseConfig(connName, "login_ip_limit")))) {
            String loginIpLimit = sysBaseConfig.getConfigValue();
            if ("0".equals(sysUsers.getLoginIpLimit()) && "0".equals(loginIpLimit)) {
                List<String> forbidIpList;
                List<String> allowIpList;
                boolean flag = false;
                String loginIp = IpUtils.getIp();
                String allowIp = iSysBaseConfigService.getSysBaseConfig(connName, "allow_login_ip").getConfigValue();
                String forbidIp = iSysBaseConfigService.getSysBaseConfig(connName, "forbid_login_ip").getConfigValue();
                if (ToolUtil.isEmpty((Object)allowIp) && ToolUtil.isEmpty((Object)forbidIp)) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)allowIp) && ((allowIpList = Arrays.asList(allowIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)forbidIp) && !flag && (!(forbidIpList = Arrays.asList(forbidIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (!flag) {
                    HussarTenantDefinition hussarTenantDefinition;
                    LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    if (HussarUtils.isNotBlank((CharSequence)connName) && !connName.equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
                        userDetails.setTenantId(hussarTenantDefinition.getTenantId());
                        userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
                    }
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
        }
    }
}

