/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.controller;

import com.baosight.buapx.security.properties.BuapxClientProperties;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/rzgthandle"})
public class RzgtHandlerController {
    @ResponseBody
    @RequestMapping(value={"/getUrl"})
    public String getUrl(HttpServletRequest request) throws UnsupportedEncodingException {
        BuapxClientProperties buapxClientProperties = BuapxClientProperties.getBuapxClientProperties();
        String loginUrl = buapxClientProperties.getLoginUrl();
        String redirectAddress = buapxClientProperties.getRedirectAddress();
        String callbackUrl = redirectAddress + "/rzgthandle/callback?syscode=QQB&originalTargetUri=" + URLEncoder.encode(redirectAddress + "/rzgthandle/toSsoLogin", "UTF-8");
        try {
            return loginUrl + "?service=" + URLEncoder.encode(callbackUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return loginUrl + "?service=" + callbackUrl;
        }
    }

    @RequestMapping(value={"/callback"})
    public String callback(HttpServletRequest request) {
        return "redirect:http://localhost/#/ssoLogin";
    }

    @RequestMapping(value={"/toSsoLogin"})
    public String toSsoLogin(HttpServletRequest request) {
        BuapxClientProperties buapxClientProperties = BuapxClientProperties.getBuapxClientProperties();
        String redirectAddress = buapxClientProperties.getRedirectAddress();
        if (redirectAddress.contains("hussarApi")) {
            redirectAddress = redirectAddress.substring(0, redirectAddress.indexOf("hussarApi"));
        }
        return "redirect:" + redirectAddress + "#/rzgtCasLogin";
    }

    @ResponseBody
    @RequestMapping(value={"/logout"})
    public void logout(HttpServletRequest request) {
        request.getSession().invalidate();
    }
}

