/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.common.properties.JqxSsoLoginProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class JqxLoginValidateServiceImpl
implements HussarLoginValidateService {
    private static Logger logger = LoggerFactory.getLogger(JqxLoginValidateServiceImpl.class);
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
    @Resource
    private JqxSsoLoginProperties jqxSsoLoginProperties;

    public String getLoginType() {
        return "jqxSso";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        return this.getJxdUserInfo(loginCode);
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsers) {
    }

    private String getJxdUserInfo(String accessToken) {
        try {
            Request request = new Request.Builder().url(this.jqxSsoLoginProperties.getUserUrl() + "/" + accessToken).build();
            Response response = client.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new ExtendLoginException("\u91d1\u4f01\u4fe1\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25:" + response.message());
            }
            String resultStr = response.body().string();
            JSONObject jsonObject = JSONObject.parseObject((String)resultStr);
            if (HussarUtils.isEmpty((Object)jsonObject)) {
                throw new ExtendLoginException("\u91d1\u4f01\u4fe1\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            }
            return jsonObject.getString("userCode");
        }
        catch (ExtendLoginException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("\u91d1\u4f01\u4fe1\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
            throw new ExtendLoginException("\u91d1\u4f01\u4fe1\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u5f02\u5e38");
        }
    }
}

