/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.cloud.service.SysAuthUserDetailsService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.support.service.AuthSecurityUserDetailService;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class AuthSecurityUserDetailServiceImpl
implements AuthSecurityUserDetailService {
    private static Logger logger = LoggerFactory.getLogger(AuthSecurityUserDetailServiceImpl.class);
    @Autowired
    private SysAuthUserDetailsService sysAuthUserDetailsService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private ISysUsersService iSysUsersService;

    public UserDetails loadUserByUsername(LoginUser loginUser) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ToolUtil.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
        String loginType = null;
        String loginCode = null;
        if (ToolUtil.isNotEmpty((Object)request)) {
            loginType = request.getHeader("loginType");
            loginCode = request.getHeader("loginCode");
        }
        logger.info("AuthSecurityUserDetailServiceImpl-loadUserByUsername \u6536\u5230\u8bf7\u6c42\u5934=>loginType^loginCode = {}", (Object)(loginType + "^" + loginCode));
        return this.sysAuthUserDetailsService.getLoginUserByAccount(loginUser);
    }

    public UserDetails loadUserBySocial(String code) {
        return null;
    }

    public Boolean checkUserPassword(String password) {
        if (ToolUtil.isEmpty((Object)password)) {
            throw new BaseException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u8f93\u5165\u5bc6\u7801\u4fe1\u606f\u4e3a\u7a7a");
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty((Object)securityUser)) {
            throw new BaseException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)securityUser.getAccount())).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false);
        if (ToolUtil.isEmpty((Object)sysUsers)) {
            throw new BaseException("\u8d26\u53f7\u4e3a: " + securityUser.getAccount() + " \u7684\u7528\u6237\u4e0d\u5b58\u5728");
        }
        String encPwd = this.credentialsMatcher.passwordEncode(password.getBytes());
        return encPwd.equalsIgnoreCase(sysUsers.getPassword());
    }
}

