/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.sessionlimit.SessionLimit;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import com.jxdinfo.hussar.support.security.core.session.SecuritySession;
import java.io.Serializable;
import java.util.Deque;
import java.util.LinkedList;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="hussar.cache", name={"cacheType"}, havingValue="redis", matchIfMissing=false)
public class RedisSessionLimit
implements SessionLimit {
    public Deque<Serializable> getUserSession(String userId) {
        LinkedList deque = (LinkedList)DefaultCacheUtil.get((Object)("same_user_sessions:" + userId));
        if (deque == null) {
            deque = new LinkedList();
        }
        return deque;
    }

    public Deque<Serializable> getUserSession(String userId, String connName) {
        LinkedList deque = (LinkedList)DefaultCacheUtil.get((Object)("same_user_sessions:" + userId + connName));
        if (deque == null) {
            deque = new LinkedList();
        }
        return deque;
    }

    public void addUserSession(String userId, Deque<Serializable> deque) {
        DefaultCacheUtil.put((Object)("same_user_sessions:" + userId), deque);
    }

    public void addUserSession(String userId, String connName, Deque<Serializable> deque) {
        DefaultCacheUtil.put((Object)("same_user_sessions:" + userId + connName), deque);
    }

    public void removeBySession(SecuritySession session) {
        Deque deque;
        SecurityUser shiroUser = (SecurityUser)session.get("baseUserInfo");
        if (ToolUtil.isNotEmpty((Object)shiroUser) && ToolUtil.isNotEmpty((Object)(deque = (Deque)DefaultCacheUtil.get((Object)("same_user_sessions:" + shiroUser.getId()))))) {
            deque.remove(session.getId());
            DefaultCacheUtil.put((Object)("same_user_sessions:" + shiroUser.getId()), (Object)deque);
        }
    }

    public void removeBySession(SecuritySession session, String connName) {
        SecurityUser shiroUser = (SecurityUser)session.get("baseUserInfo");
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            String key = shiroUser.getId() + connName;
            Deque deque = (Deque)DefaultCacheUtil.get((Object)("same_user_sessions:" + key));
            if (ToolUtil.isNotEmpty((Object)deque)) {
                deque.remove(session.getId());
                DefaultCacheUtil.put((Object)("same_user_sessions:" + key), (Object)deque);
            }
        }
    }
}

