/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.base.cloud.service.SysAuthClientDetailsService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.support.service.dto.ClientModelDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysAuthClientDetailsServiceImpl
implements SysAuthClientDetailsService {
    @Autowired
    private SysAuthClientModelService sysAuthClientModelService;

    @HussarDs(value="#connName")
    public ClientModelDetails doLoginByClientId(String connName, SysAuthClientModel sysAuthClientModel) {
        if (HussarUtils.isEmpty((Object)sysAuthClientModel)) {
            throw new BaseException("\u83b7\u53d6clientmodel\u5931\u8d25,\u4f20\u9012\u6761\u4ef6\u4e3a\u7a7a");
        }
        String clientId = sysAuthClientModel.getClientId();
        ClientModelDetails oldClientModelDetail = (ClientModelDetails)HussarCacheUtil.get((String)"security_client_cache", (Object)("security_client_key:" + clientId));
        if (HussarUtils.isNotEmpty((Object)oldClientModelDetail)) {
            return oldClientModelDetail;
        }
        LambdaQueryWrapper sysAuthClientModelLambdaQueryWrapper = Wrappers.lambdaQuery();
        sysAuthClientModelLambdaQueryWrapper.eq(SysAuthClientModel::getClientId, (Object)sysAuthClientModel.getClientId());
        SysAuthClientModel one = (SysAuthClientModel)this.sysAuthClientModelService.getOne(connName, (Wrapper)sysAuthClientModelLambdaQueryWrapper, false);
        if (HussarUtils.isEmpty((Object)one)) {
            throw new BaseException("\u83b7\u53d6clientmodel\u5931\u8d25");
        }
        ClientModelDetails clientModelDetails = this.sysAuthClientModelService.getClientModelDetailsByClientModel(one);
        HussarCacheUtil.put((String)"security_client_cache", (Object)("security_client_key:" + clientId), (Object)clientModelDetails);
        return clientModelDetails;
    }
}

