/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.service.AuthcService;
import com.jxdinfo.hussar.authentication.vo.LoginInfoVo;
import com.jxdinfo.hussar.authentication.vo.LoginTypeVo;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.unify.authentication.client.properties.UnifyAuthenticationClientProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AuthcServiceImpl
implements AuthcService {
    private static Logger logger = LoggerFactory.getLogger(AuthcServiceImpl.class);
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private IHussarPwdConfigService pwdConfigService;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;

    @HussarDs(value="#connName")
    private ApiResponse<LoginInfoVo> changeTempDs(String connName, AuthcDto authcDto) {
        authcDto.setDsName(connName);
        return ApiResponse.success((Object)new LoginInfoVo());
    }

    public void logout() {
        SecurityUtil.logout();
    }

    public ApiResponse<Map<String, String>> check() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.pwdConfigService.isForceChangePwd()) {
            SysUsers sysUser = this.iSysUsersService.getUser(shiroUser.getId());
            if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
                map.put("firstLogin", "NO");
                map.put("changePwd", "NO");
                return ApiResponse.success(map);
            }
            if (this.iSysUsersService.isFirstLogin(shiroUser.getId())) {
                map.put("firstLogin", "YES");
            } else {
                map.put("firstLogin", "NO");
            }
            if (this.iSysUsersService.isPwdOverdue(shiroUser.getId())) {
                map.put("changePwd", "YES");
            } else {
                map.put("changePwd", "NO");
            }
        } else {
            map.put("firstLogin", "NO");
            map.put("changePwd", "NO");
        }
        return ApiResponse.success(map);
    }

    public ApiResponse<Map<String, Object>> getShow() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        List sysBaseConfigs = this.sysBaseConfigService.getTotpCaptchaConfigList();
        if (ToolUtil.isNotEmpty((Object)sysBaseConfigs)) {
            Map configMap = sysBaseConfigs.stream().collect(Collectors.toMap(SysBaseConfig::getConfigKey, Function.identity()));
            SysBaseConfig topTOpen = (SysBaseConfig)configMap.get("totp_open");
            SysBaseConfig kaptchaOpen = (SysBaseConfig)configMap.get("kaptcha_open");
            SysBaseConfig loginViewKaptcha = (SysBaseConfig)configMap.get("login_view_kaptcha");
            map.put("totp", topTOpen == null ? false : "0".equals(topTOpen.getConfigValue()));
            map.put("kaptcha", kaptchaOpen == null ? false : "0".equals(kaptchaOpen.getConfigValue()));
            map.put("indexKaptcha", loginViewKaptcha == null ? false : "0".equals(loginViewKaptcha.getConfigValue()));
        }
        return ApiResponse.success(map);
    }

    public ApiResponse<SecurityUser> queryLoginUserInfo(AuthcDto authcDto) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        securityUser.setDeptIcon(this.sysOrganTypeService.getDeptIcon(securityUser.getDeptId()));
        return ApiResponse.success((Object)securityUser);
    }

    public ApiResponse<LoginTypeVo> getLoginType() {
        UnifyAuthenticationClientProperties unifyProperties;
        try {
            unifyProperties = (UnifyAuthenticationClientProperties)SpringContextHolder.getBean(UnifyAuthenticationClientProperties.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            unifyProperties = null;
        }
        boolean type = ToolUtil.isNotEmpty((Object)unifyProperties) && unifyProperties.isEnable();
        LoginTypeVo loginType = new LoginTypeVo();
        if (type) {
            loginType.setLoginType("ssoLogin");
        } else {
            loginType.setLoginType("default");
        }
        return ApiResponse.success((Object)loginType);
    }
}

