/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.code.kaptcha.Producer;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.factory.HussarLoginFactory;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.base.cloud.dto.RoleGrantedAuthority;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IPageViewConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.base.config.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.theme.service.IThemeService;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class HussarLoginBaseServiceImpl
implements HussarLoginService {
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysBaseConfigService iSysBaseConfigService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private IPageViewConfigService pageViewConfigService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private Producer producer;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysWelcomeService sysWelcomeService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    private static final String[] MANAGE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin"};
    private static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};

    public UserDetails login(AuthcDto authcDto) {
        SysUsers sysUsers;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ToolUtil.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
        String loginType = null;
        String loginCode = null;
        if (ToolUtil.isNotEmpty((Object)request)) {
            loginType = request.getHeader("loginType");
            loginCode = request.getHeader("loginCode");
        }
        if (ToolUtil.isEmpty(loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").beforeSelectUser(request, loginCode, authcDto);
        } else {
            String username = HussarLoginFactory.getLoginValidateService(loginType).beforeSelectUser(request, loginCode, authcDto);
            if (ToolUtil.isNotEmpty((Object)username)) {
                authcDto.setUsername(username);
            }
        }
        String account = authcDto.getUsername();
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)authcDto.getUsername())) {
            account = authcDto.getUsername().toUpperCase();
        }
        if (ToolUtil.isEmpty((Object)(sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false)))) {
            sysUsers = new SysUsers();
            sysUsers.setUserName(authcDto.getUsername());
            this.throwExceptionPersionally(sysUsers, BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
        } else if (this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !authcDto.getUsername().equals(sysUsers.getUserAccount())) {
            this.throwExceptionPersionally(sysUsers, BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
        }
        SysUsersDto sysUsersDto = new SysUsersDto();
        CopyPropertieUtils.copyProperties((Object)sysUsersDto, (Object)sysUsers);
        if (ToolUtil.isEmpty((Object)loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").validateUser(authcDto, sysUsersDto);
        } else {
            HussarLoginFactory.getLoginValidateService(loginType).validateUser(authcDto, sysUsersDto);
        }
        UserDetails userDetails = this.getLoginSecurityUser(sysUsers);
        if (ToolUtil.isNotEmpty((Object)userDetails)) {
            sysUsers.setLastLoginTime(Java8DateUtils.currentLocalDateTime());
            sysUsers.setLastEditor(userDetails.getUserId());
            sysUsers.setLastTime(LocalDateTime.now());
            this.iSysUsersService.updateById((Object)sysUsers);
        }
        return userDetails;
    }

    private void throwExceptionPersionally(SysUsers sysUsers, String message) {
        BaseException e = new BaseException(message);
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName("\u767b\u5f55");
        auditLogModel.setExceptionInfo((Throwable)e);
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
        auditLogModel.setEventDesc(message);
        UserDetails userDetails = new UserDetails();
        if (sysUsers.getId() != null) {
            userDetails.setUserId(sysUsers.getId());
        }
        userDetails.setUserName(sysUsers.getUserName());
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        throw e;
    }

    private UserDetails getLoginSecurityUser(SysUsers sysUsers) {
        String connName;
        UserDetails userDetails = new UserDetails();
        if (this.hussarBaseProperties.isTenantOpen() && ToolUtil.isNotEmpty((Object)(connName = this.dynamicDataSourceService.currentDsName()))) {
            SysTenant tenant;
            userDetails.addExtendUserMap("connName", (Object)connName);
            if ("master".equals(connName)) {
                userDetails.addExtendUserMap("tenantCode", (Object)"000000");
                tenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new QueryWrapper().eq((Object)"TENANT_CODE", (Object)"000000"));
                if (ToolUtil.isNotEmpty((Object)tenant)) {
                    userDetails.addExtendUserMap("tenantId", (Object)String.valueOf(tenant.getId()));
                    userDetails.addExtendUserMap("tenantName", (Object)tenant.getTenantName());
                    userDetails.addExtendUserMap("tenantCipher", (Object)String.valueOf(tenant.getBpmTenantCipher()));
                    userDetails.addExtendUserMap("bpmTenantId", (Object)String.valueOf(tenant.getId()));
                    userDetails.addExtendUserMap("bpmTenantCipher", (Object)String.valueOf(tenant.getBpmTenantCipher()));
                }
            } else {
                tenant = this.sysTenantService.queryTenantByConnName(connName);
                if (ToolUtil.isNotEmpty((Object)tenant)) {
                    userDetails.addExtendUserMap("tenantCode", (Object)tenant.getTenantCode());
                    userDetails.addExtendUserMap("tenantId", (Object)String.valueOf(tenant.getId()));
                    userDetails.addExtendUserMap("tenantCipher", (Object)String.valueOf(tenant.getBpmTenantCipher()));
                    userDetails.addExtendUserMap("bpmTenantId", (Object)String.valueOf(tenant.getId()));
                    userDetails.addExtendUserMap("bpmTenantCipher", (Object)String.valueOf(tenant.getBpmTenantCipher()));
                }
            }
        }
        userDetails.setUserId(sysUsers.getId());
        userDetails.addExtendUserMap("account", (Object)sysUsers.getUserAccount());
        userDetails.setUserName(sysUsers.getUserName());
        userDetails.addExtendUserMap("deptId", (Object)sysUsers.getDepartmentId());
        userDetails.addExtendUserMap("employeeId", (Object)sysUsers.getEmployeeId());
        userDetails.addExtendUserMap("deptName", (Object)this.getDeptName(sysUsers.getDepartmentId()));
        userDetails.addExtendUserMap("securityLevel", (Object)sysUsers.getSecurityLevel());
        userDetails.addExtendUserMap("accountStatus", (Object)sysUsers.getAccountStatus());
        userDetails.addExtendUserMap("showTenant", (Object)this.showTenantInfo(sysUsers));
        userDetails.setMaxSameCount(Integer.valueOf(sysUsers.getMaxSessions()));
        List<Long> rolesList = this.getRolesIdByUserId(sysUsers.getId());
        userDetails.addExtendUserMap("gradeAdmin", (Object)(ToolUtil.isNotEmpty(rolesList) && rolesList.contains(SysUserAndRole.GRADEADMIN_ROLE.getValue()) ? 1 : 0));
        Long employeeId = sysUsers.getEmployeeId();
        Long departmentId = sysUsers.getDepartmentId();
        if (ToolUtil.isNotEmpty((Object)employeeId) && ToolUtil.isNotEmpty((Object)departmentId)) {
            List<Long> roleList = this.getRolesIdByStruId(sysUsers.getDepartmentId());
            if (HussarUtils.isNotEmpty(rolesList)) {
                rolesList.addAll(roleList);
            }
        }
        userDetails.addExtendUserMap("rolesList", rolesList);
        ResourceGrantedAuthority resourceGrantedAuthority = this.getPermissionByRoleIds(rolesList, sysUsers.getId());
        userDetails.addExtendUserMap("theme", (Object)this.themeService.queryUserThemeWithUserId(sysUsers.getId()));
        ArrayList<Long> roleList = new ArrayList<Long>(rolesList);
        roleList.add(userDetails.getUserId());
        userDetails.addExtendUserMap("welcomeUrl", (Object)this.sysWelcomeService.getUserIndex(roleList));
        userDetails.addExtendUserMap("permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
        return userDetails;
    }

    private String getDeptName(Long deptId) {
        SysOrganVo dept = this.iSysStruService.getOrgInfoByOrgId(deptId);
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    private List<Long> getRolesIdByUserId(Long userId) {
        return this.iSysUserRoleService.getRolesByUserId(userId);
    }

    private List<Long> getRolesIdByStruId(Long struId) {
        return this.iSysStruRoleService.getRolesByStruId(struId);
    }

    private ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList, Long userId) {
        ArrayList<String> resourcePermissions;
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        if (roleList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            List resourcesList = this.sysResourcesService.list();
            resourcePermissions = new ArrayList<String>();
            for (SysResources resources : resourcesList) {
                resourcePermissions.add(resources.getPermissions());
            }
        } else {
            resourcePermissions = this.sysResourcesService.queryPermissionsByRoleIds(roleList);
        }
        if (HussarUtils.isNotEmpty((Object)resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList(resourcePermissions);
        }
        return resourceGrantedAuthority;
    }

    private RoleGrantedAuthority getRolePermissions(List<Long> roleList, Long userId) {
        RoleGrantedAuthority roleGrantedAuthority = new RoleGrantedAuthority();
        List roles = new ArrayList();
        if (ToolUtil.isNotEmpty(roleList)) {
            roles = this.sysRolesService.listByIds(roleList);
        }
        ArrayList rolePermissions = new ArrayList();
        roles.forEach(sysRole -> {
            if (HussarUtils.isNotEmpty((Object)sysRole.getRolePermission())) {
                rolePermissions.add(sysRole.getRolePermission());
            }
        });
        if (HussarUtils.isNotEmpty(rolePermissions)) {
            roleGrantedAuthority.setGrantAuthorityList(rolePermissions);
        }
        return roleGrantedAuthority;
    }

    private boolean showTenantInfo(SysUsers sysUsers) {
        boolean flag = false;
        if (ToolUtil.isNotEmpty((Object)sysUsers)) {
            String account = sysUsers.getUserAccount();
            if (this.hussarBaseProperties.isTenantOpen() && "2".equals(this.hussarBaseProperties.getTenantUserModel()) && Arrays.asList(MANAGE_USER).contains(account)) {
                flag = true;
            }
        }
        return flag;
    }
}

