/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authentication.config.YgCloudConfig;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authentication.util.HttpUtil;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class YgCloudLoginValidateServiceImpl
implements HussarLoginValidateService {
    @Resource
    private YgCloudConfig ygCloudConfig;
    private static final String CACHE_NAME = "login:ygCloud";
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    protected IHussarPwdConfigService hussarPwdConfigService;
    @Resource
    protected AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    protected AbstractCredentialsMatcher credentialsMatcher;

    public String getLoginType() {
        return "ygCloud";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        String redirectUri = request.getHeader("redirectUri");
        String accessToken = this.getAccessToken(loginCode, redirectUri);
        String userName = this.getUserInfo(accessToken);
        return userName;
    }

    private String getUserInfo(String accessToken) {
        String userUrl = this.ygCloudConfig.getUserUrl();
        String requestParam = "access_token=" + accessToken;
        String result = "";
        String userName = "";
        try {
            result = HttpUtil.get(userUrl, requestParam);
            JSONObject jsonObject = JSON.parseObject((String)result);
            userName = jsonObject.getString("username");
            if (HussarUtils.isNotEmpty((Object)userName)) {
                LambdaQueryWrapper qw = new LambdaQueryWrapper();
                qw.eq(SysUsers::getUserName, (Object)userName);
                qw.ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode());
                qw.ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode());
                SysUsers sysUser = (SysUsers)this.iSysUsersService.getOne((Wrapper)qw);
                if (HussarUtils.isEmpty((Object)sysUser)) {
                    this.copyUser(userName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userName;
    }

    @HussarTransactional
    private void copyUser(String userName) {
        SysUsers user = new SysUsers();
        long id = IdWorker.getId((Object)user);
        user.setId(Long.valueOf(id));
        user.setUserName(userName);
        String secure = this.hussarPwdConfigService.getDefaultPassword();
        String enSecure = this.credentialsMatcher.passwordEncode(String.valueOf(secure).getBytes());
        user.setPassword(enSecure);
        user.setAccountStatus(UserStatus.OK.getCode());
        user.setSecurityLevel(Integer.valueOf(1));
        user.setMaxSessions(Integer.valueOf(1));
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setCorporationId(Long.valueOf(11L));
        user.setDepartmentId(Long.valueOf(11L));
        user.setUserOrder(Integer.valueOf(10));
        user.setUserAccount(userName);
        user.setTypeProperty("1");
        user.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        user.setLoginIpLimit("0");
        user.setLoginTimeLimit("0");
        this.iSysUsersService.save((Object)user);
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(Long.valueOf(id));
        if ("yg".equals(userName)) {
            sysUserRole.setGrantedRole(Long.valueOf(1450785135866925066L));
        } else {
            sysUserRole.setGrantedRole(Long.valueOf(1450785135866925064L));
        }
        sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
        this.iSysUserRoleService.save((Object)sysUserRole);
    }

    private String getAccessToken(String code, String redirectUri) {
        String tokenUrl = this.ygCloudConfig.getTokenUrl();
        String clientId = this.ygCloudConfig.getClientId();
        String clientSecret = this.ygCloudConfig.getClientSecret();
        String result = "";
        String accessToken = "";
        if (HussarUtils.isNotEmpty((Object)code)) {
            StringBuilder requestParam = new StringBuilder();
            requestParam.append("client_id=" + clientId);
            requestParam.append("&client_secret=" + clientSecret);
            requestParam.append("&grant_type=authorization_code");
            requestParam.append("&redirect_uri=" + redirectUri);
            requestParam.append("&code=" + code);
            try {
                result = HttpUtil.get(tokenUrl, requestParam.toString());
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                accessToken = jsonObject.getString("access_token");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return accessToken;
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }
}

