/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.enums.AuthenticationEnum;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.authorization.permit.service.SysLoginUserService;
import com.jxdinfo.hussar.base.cloud.service.SysAuthUserDetailsService;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.security.plugin.oauth2.exception.SecurityOAuth2Exception;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysAuthUserDetailsServiceImpl
implements SysAuthUserDetailsService {
    private static Logger logger = LoggerFactory.getLogger(SysAuthUserDetailsServiceImpl.class);
    @Resource
    private HussarLoginService hussarLoginService;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private SysLoginUserService sysLoginUserService;
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;

    public UserDetails getLoginUserByAccount(LoginUser loginUser) {
        AuthcDto authcDto = new AuthcDto();
        authcDto.setUsername(loginUser.getUserName());
        authcDto.setCipher(loginUser.getPassword());
        authcDto.setIsIndex(loginUser.getExtendMap("isIndex"));
        authcDto.setKaptcha(loginUser.getExtendMap("kaptcha"));
        authcDto.setTotp(loginUser.getExtendMap("totp"));
        authcDto.setKaptchasuffix(loginUser.getExtendMap("kaptchasuffix"));
        if (HussarUtils.isEmpty((Object)authcDto)) {
            return null;
        }
        UserDetails securityUser = this.hussarBaseProperties.isTenantOpen() ? this.getUserInfoByTenant(authcDto) : this.getUserInfo(authcDto);
        return securityUser;
    }

    private UserDetails getUserInfo(AuthcDto authcDto) {
        UserDetails userInfo = this.hussarLoginService.login(authcDto);
        if (HussarUtils.isNotEmpty((Object)userInfo)) {
            userInfo.addExtendUserMap("baseConnName", (Object)this.dynamicDataSourceService.currentDsName());
            return userInfo;
        }
        return null;
    }

    private UserDetails getUserInfoByTenant(AuthcDto authcDto) {
        String username = authcDto.getUsername();
        String tenantCode = this.sysLoginUserService.getTenantCodeByAccount(username);
        if (ToolUtil.isNotEmpty((Object)tenantCode)) {
            SysDataSource dataSource;
            if ("000000".equals(tenantCode)) {
                return this.getUserInfo(authcDto);
            }
            List list = this.sysTenantService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysTenant::getTenantCode, (Object)tenantCode)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (list == null || list.size() <= 0) {
                throw new SecurityOAuth2Exception(AuthenticationEnum.AUTHEN_FIND_USER_TENANT_FAIL.getValue());
            }
            SysTenant tenant = (SysTenant)list.get(0);
            if ("1".equals(tenant.getLoginTimeLimit())) {
                String beginTime = tenant.getAccessLoginStartTime();
                String endTime = tenant.getAccessLoginEndTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date begin = sdf.parse(beginTime);
                    Date end = sdf.parse(endTime);
                    Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                    if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                        throw new SecurityOAuth2Exception(AuthenticationEnum.AUTHEN_BELONG_TENANT_ACCOUNT_EXPIRED.getValue());
                    }
                }
                catch (ParseException e) {
                    logger.error(e.getMessage());
                }
            }
            if (ToolUtil.isEmpty((Object)(dataSource = this.sysDataSourceService.getByTenantCode(tenantCode))) || ToolUtil.isEmpty((Object)dataSource.getConnName())) {
                throw new SecurityOAuth2Exception(AuthenticationEnum.AUTHEN_TENANT_DATASOURCE_NOT_FOUND.getValue());
            }
            this.sysDataSourceService.addDataSourceByConnName(dataSource.getConnName());
            return this.getUserInfoByChangDs(dataSource.getConnName(), authcDto);
        }
        throw new SecurityOAuth2Exception(AuthenticationEnum.AUTHEN_FIND_USER_TENANT_FAIL.getValue());
    }

    @HussarDs(value="#connName")
    private UserDetails getUserInfoByChangDs(String connName, AuthcDto authcDto) {
        authcDto.setDsName(connName);
        return this.getUserInfo(authcDto);
    }
}

