/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authentication.dao.SysAuthClientModelMapper;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.ClientModelDetails;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.core.secure.SecuritySecureUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SysAuthClientModelServiceImpl
extends HussarServiceImpl<SysAuthClientModelMapper, SysAuthClientModel>
implements SysAuthClientModelService {
    @Resource
    private SysAuthClientModelMapper sysAuthClientModelMapper;
    private static final String PRIVATE_KEY = "private";
    private static final String PUBLIC_KEY = "public";

    public IPage<SysAuthClientModel> getClientModelList(Page<SysAuthClientModel> page, SysAuthClientModel authClientModel) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0")).orderByDesc(HussarBaseEntity::getCreateTime);
        return this.sysAuthClientModelMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
    }

    public ApiResponse<SysAuthClientModel> saveAuthClientModel(SysAuthClientModel authClientModel) throws Exception {
        this.checkSaveOrUpdate(authClientModel);
        HashMap keyMap = SecuritySecureUtil.rsaGenerateKeyPair();
        authClientModel.setPrivateKey((String)keyMap.get(PRIVATE_KEY));
        authClientModel.setPublicKey((String)keyMap.get(PUBLIC_KEY));
        if (this.save((BaseEntity)authClientModel)) {
            ClientModelDetails clientModelDetails = this.getClientModelDetailsByClientModel(authClientModel);
            HussarCacheUtil.put((String)"security_client_cache", (Object)("security_client_key:" + authClientModel.getClientId()), (Object)clientModelDetails);
            return ApiResponse.success((Object)authClientModel);
        }
        throw new BaseException(BaseExceptionEnum.SAVE_FAILED.getMessage());
    }

    public ApiResponse<SysAuthClientModel> updateAuthClientModel(SysAuthClientModel authClientModel) {
        this.checkSaveOrUpdate(authClientModel);
        SysAuthClientModel oldAuthClientModel = (SysAuthClientModel)this.getById(authClientModel.getId());
        if (this.updateById((BaseEntity)authClientModel)) {
            if (ToolUtil.isNotEmpty((Object)oldAuthClientModel)) {
                HussarCacheUtil.evict((String)"security_client_cache", (Object)("security_client_key:" + oldAuthClientModel.getClientId()));
            }
            ClientModelDetails clientModelDetails = this.getClientModelDetailsByClientModel(authClientModel);
            HussarCacheUtil.put((String)"security_client_cache", (Object)("security_client_key:" + authClientModel.getClientId()), (Object)clientModelDetails);
            return ApiResponse.success((Object)authClientModel);
        }
        throw new BaseException(BaseExceptionEnum.UPDATE_FAILED.getMessage());
    }

    public ApiResponse<SysAuthClientModel> deleteAuthClientModel(Long id) {
        SysAuthClientModel authClientModel = (SysAuthClientModel)this.getById(id);
        if (this.removeById(id)) {
            if (ToolUtil.isNotEmpty((Object)authClientModel)) {
                HussarCacheUtil.evict((String)"security_client_cache", (Object)("security_client_key:" + authClientModel.getClientId()));
            }
            return ApiResponse.success((String)BaseExceptionEnum.DELETE_SUCCESS.getMessage());
        }
        throw new BaseException(BaseExceptionEnum.DELETE_FAILED.getMessage());
    }

    public ApiResponse<SysAuthClientModel> queryAuthClientModelDetail(Long id) {
        return ApiResponse.success((Object)this.getById(id));
    }

    public ApiResponse<String> getPublicKey(String clientId) {
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysAuthClientModel::getClientId, (Object)clientId);
            List list = this.sysAuthClientModelMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                return ApiResponse.success((String)((SysAuthClientModel)list.get(0)).getPublicKey());
            }
        }
        throw new BaseException(BaseExceptionEnum.CLIENTID_EMPTY.getMessage());
    }

    private void checkSaveOrUpdate(SysAuthClientModel authClientModel) {
        Long accessTokenValidTime;
        if (ToolUtil.isNotEmpty((Object)authClientModel.getAccessTokenValidTime()) && ((accessTokenValidTime = Long.valueOf(authClientModel.getAccessTokenValidTime())) <= 0L || accessTokenValidTime > 1800L)) {
            throw new BaseException(BaseExceptionEnum.TOKEN_EXPIRED_TIME_LIMIT.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)authClientModel.getClientId())) {
            List ifRepeat;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysAuthClientModel::getClientId, (Object)authClientModel.getClientId());
            if (authClientModel.getId() != null) {
                queryWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.ne(SysAuthClientModel::getId, (Object)authClientModel.getId());
                });
            }
            if ((ifRepeat = this.list((Wrapper)queryWrapper)).size() > 0) {
                throw new BaseException(BaseExceptionEnum.CLIENTID_EXISTS.getMessage());
            }
        } else {
            throw new BaseException(BaseExceptionEnum.CLIENTID_CANNOT_EMPTY.getMessage());
        }
    }

    public ClientModelDetails getClientModelDetailsByClientModel(SysAuthClientModel authClientModel) {
        ClientModelDetails clientModelDetails = new ClientModelDetails();
        clientModelDetails.setClientId(authClientModel.getClientId());
        clientModelDetails.setClientSecret(authClientModel.getClientSecret());
        if (StringUtils.isNotBlank((CharSequence)authClientModel.getContractScope())) {
            clientModelDetails.setContractScope(authClientModel.getContractScope().split(","));
        }
        clientModelDetails.setAllowUrl(authClientModel.getAllowUrl());
        clientModelDetails.setAccessTokenValidTime(authClientModel.getAccessTokenValidTime());
        clientModelDetails.setRefreshTokenValidTime(authClientModel.getRefreshTokenValidTime());
        clientModelDetails.setPublicKey(authClientModel.getPublicKey());
        clientModelDetails.setPrivateKey(authClientModel.getPrivateKey());
        clientModelDetails.setGrantTypes(authClientModel.getAuthorizedGrantType().split(","));
        return clientModelDetails;
    }
}

