/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.dto.GetBackPasswordDto;
import com.jxdinfo.hussar.authentication.service.GetBackPasswordService;
import com.jxdinfo.hussar.authorization.permit.model.SysGetBackPassword;
import com.jxdinfo.hussar.authorization.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysGetBackPasswordService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.properties.HussarEncryptProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GetBackPasswordServiceImpl
implements GetBackPasswordService {
    private static Long EXPIRE_TIME = 600L;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysGetBackPasswordService iSysGetBackPasswordService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;
    @Resource
    private HussarEncryptProperties hussarEncryptProperties;
    @Resource
    private PasswordEncryptService passwordEncryptService;
    private static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};

    public ApiResponse<GetBackPasswordDto> queryUserQues(String userAccount) {
        return this.queryUserQues(userAccount, "-1", null);
    }

    public ApiResponse<GetBackPasswordDto> queryUserQues(String userAccount, String kaptcha, String kaptchasuffix) {
        if (HussarUtils.isBlank((CharSequence)kaptcha)) {
            throw new BaseException(BaseExceptionEnum.VERIFICATION_EMPTY.getMessage());
        }
        String code = (String)HussarCacheUtil.get((String)"KAPTCHA_CODE", (Object)kaptchasuffix, String.class);
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BaseException(BaseExceptionEnum.VERIFICATION_EXPIRED.getMessage());
        }
        if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
            throw new BaseException(BaseExceptionEnum.CAPTCHA_CODE_ERROR.getMessage());
        }
        HussarCacheUtil.evict((String)"KAPTCHA_CODE", (Object)kaptchasuffix);
        if (ToolUtil.isEmpty((Object)userAccount)) {
            throw new BaseException(BaseExceptionEnum.ACCOUNT_EMPTY.getMessage());
        }
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)userAccount)) {
            userAccount = userAccount.toUpperCase();
        }
        if (!this.iSysUsersService.isExistAccount(userAccount)) {
            throw new BaseException(BaseExceptionEnum.NOT_SET_SECURITY.getMessage());
        }
        SysUsers user = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).ne(SysUsers::getAccountStatus, (Object)"2"), false);
        SysGetBackPassword sysGetBackPassword = (SysGetBackPassword)this.iSysGetBackPasswordService.getById((Serializable)user.getId());
        if (ToolUtil.isEmpty((Object)sysGetBackPassword)) {
            throw new BaseException(BaseExceptionEnum.NOT_SET_SECURITY.getMessage());
        }
        GetBackPasswordDto getBackPasswordVo = new GetBackPasswordDto();
        getBackPasswordVo.setQuestion(sysGetBackPassword.getpQues());
        getBackPasswordVo.setUserAccount(userAccount);
        return ApiResponse.success((Object)getBackPasswordVo);
    }

    public ApiResponse queryValidateKey(GetBackPasswordDto getBackPasswordDto) {
        String pKey;
        String pQues;
        String userAccount = getBackPasswordDto.getUserAccount();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userAccount, pQues = getBackPasswordDto.getQuestion(), pKey = getBackPasswordDto.getAnswer()})) {
            throw new BaseException(BaseExceptionEnum.PARAMETER_EMPTY.getMessage());
        }
        HussarCacheUtil.evict((String)"answer_info", (Object)userAccount);
        SysUsers user = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).ne(SysUsers::getAccountStatus, (Object)"2"), false);
        SysGetBackPassword sysGetBackPassword = (SysGetBackPassword)this.iSysGetBackPasswordService.getById((Serializable)user.getId());
        if (ToolUtil.isNotEmpty((Object)sysGetBackPassword)) {
            if (pQues.equals(sysGetBackPassword.getpQues()) && pKey.equals(sysGetBackPassword.getpKey())) {
                HussarCacheUtil.put((String)"answer_info", (Object)userAccount, (Object)ResultCode.SUCCESS.getCode(), (long)EXPIRE_TIME);
                return ApiResponse.success((String)BaseExceptionEnum.VERIFICATION_PASSED.getMessage());
            }
            throw new BaseException(BaseExceptionEnum.ANSWER_INCORRECT.getMessage());
        }
        throw new BaseException(BaseExceptionEnum.NOT_SET_SECURITY.getMessage());
    }

    public ApiResponse saveNewPwd(GetBackPasswordDto getBackPasswordDto) {
        String cPwd;
        String newPwd;
        String userAccount = getBackPasswordDto.getUserAccount();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userAccount, newPwd = getBackPasswordDto.getNewPwd(), cPwd = getBackPasswordDto.getCheckPwd()})) {
            throw new BaseException(BaseExceptionEnum.PARAMETER_EMPTY.getMessage());
        }
        Object checkAnswer = HussarCacheUtil.get((String)"answer_info", (Object)userAccount);
        if (checkAnswer == null) {
            return ApiResponse.fail((String)BaseExceptionEnum.SECURITY_NOT_VERIFIED.getMessage());
        }
        if (this.hussarEncryptProperties.isEnablePwEncryption()) {
            newPwd = this.passwordEncryptService.decrypt(newPwd);
            cPwd = this.passwordEncryptService.decrypt(cPwd);
        }
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)userAccount)) {
            userAccount = userAccount.toUpperCase();
        }
        SysUsers user = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).ne(SysUsers::getAccountStatus, (Object)"2"), false);
        Long userId = user.getId();
        String regular = this.hussarPwdConfigService.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.hussarPwdConfigService.getUnmatchedHintMark();
        String unmatchedHint = this.hussarPwdConfigService.getUnmatchedHint();
        String pwdRule = this.hussarPwdConfigService.getPwdRule();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!newPwd.matches(regular)) {
            result.put("success", false);
            result.put("error", "unmatchedHintMark");
            result.put("pwdRule", pwdRule);
            result.put("hintMark", hint);
            result.put("msg", unmatchedHint);
            return ApiResponse.success(result);
        }
        if (newPwd.toLowerCase().contains(userAccount.toLowerCase())) {
            result.put("success", false);
            result.put("error", "updateFailPwdNotUser");
            return ApiResponse.success(result);
        }
        if (!newPwd.equals(cPwd)) {
            result.put("success", false);
            result.put("error", "pwdNotSame");
            return ApiResponse.success(result);
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        List list = this.iSysUsersService.getPwdHist(userId);
        for (SysPasswordHist sysPasswordHist : list) {
            if (!nPwd.equals(sysPasswordHist.getPassword())) continue;
            result.put("success", false);
            result.put("error", "resetFail");
            result.put("repeatTime", this.hussarPwdConfigService.getPwdRepeatTime());
            return ApiResponse.success(result);
        }
        user.setPassword(nPwd);
        this.iSysUsersService.updatePwd(user);
        result.put("success", true);
        HussarCacheUtil.evict((String)"answer_info", (Object)userAccount);
        return ApiResponse.success(result);
    }
}

