/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.util;

import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    private HttpUtil() {
    }

    private static void configTimeout(HttpClient httpClient) {
        HttpConnectionManagerParams params = httpClient.getHttpConnectionManager().getParams();
        params.setConnectionTimeout(600000);
        params.setSoTimeout(600000);
    }

    public static String post(String url, String reqParam) throws Exception {
        HttpClient httpClient = new HttpClient();
        PostMethod method = new PostMethod(url);
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        method.addRequestHeader("http.protocol.content-charset", "UTF-8");
        StringRequestEntity entity = new StringRequestEntity(reqParam);
        method.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        return respResult;
    }

    public static String jsonPost(String url, String reqParam) throws Exception {
        HttpClient httpClient = new HttpClient();
        PostMethod method = new PostMethod(url);
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        method.addRequestHeader("http.protocol.content-charset", "UTF-8");
        StringRequestEntity entity = new StringRequestEntity(reqParam, "application/json", "utf-8");
        method.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        log.info("\u8bf7\u6c42{}\u8fd4\u56de\uff1a{}", (Object)url, (Object)respResult);
        return respResult;
    }

    public static String post(String url, String reqParam, String charSet) throws Exception {
        HttpClient httpClient = new HttpClient();
        PostMethod method = new PostMethod(url);
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)charSet);
        method.addRequestHeader("http.protocol.content-charset", charSet);
        StringRequestEntity entity = new StringRequestEntity(reqParam);
        method.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        log.info("\u8bf7\u6c42{}\u8fd4\u56de\uff1a{}", (Object)url, (Object)respResult);
        return respResult;
    }

    public static String get(String url, String reqParam) throws Exception {
        GetMethod method;
        HttpClient httpClient = new HttpClient();
        if (StringUtil.isNullOrEmpty((String)reqParam)) {
            method = new GetMethod(url);
        } else {
            System.out.println("------\u8bf7\u6c42URL\uff1a" + url + "?" + reqParam);
            method = new GetMethod(url + "?" + reqParam);
        }
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        method.addRequestHeader("http.protocol.content-charset", "UTF-8");
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        log.info("\u8bf7\u6c42{}\u8fd4\u56de\uff1a{}", (Object)url, (Object)respResult);
        return respResult;
    }

    public static String get(String url, String reqParam, String charSet) throws Exception {
        GetMethod method;
        HttpClient httpClient = new HttpClient();
        if (StringUtil.isNullOrEmpty((String)reqParam)) {
            method = new GetMethod(url);
        } else {
            System.out.println("\u8bf7\u6c42URL\u5b57\u7b26\u4e32\uff1a" + url + "?" + reqParam);
            method = new GetMethod(url + "?" + reqParam);
        }
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)charSet);
        method.addRequestHeader("http.protocol.content-charset", charSet);
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        log.info("\u8bf7\u6c42{}\u8fd4\u56de\uff1a{}", (Object)url, (Object)respResult);
        return respResult;
    }

    public static String postHeader(String url, String reqParam) throws Exception {
        HttpClient httpClient = new HttpClient();
        HttpClientParams params = new HttpClientParams();
        params.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        httpClient.setParams(params);
        PostMethod method = new PostMethod(url);
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        method.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        StringRequestEntity entity = new StringRequestEntity(reqParam);
        method.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        log.info("\u8bf7\u6c42{}\u8fd4\u56de\uff1a{}", (Object)url, (Object)respResult);
        return respResult;
    }

    private static HttpPost postForm(String url, Map<String, String> params) {
        HttpPost httpost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        Set<String> keySet = params.keySet();
        for (String key : keySet) {
            nvps.add(new BasicNameValuePair(key, params.get(key)));
        }
        try {
            httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return httpost;
    }

    public static String postRequset(String url, String reqParamName, String reqParamValue, String charSet) throws Exception {
        HttpClient httpClient = new HttpClient();
        PostMethod method = new PostMethod(url);
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)charSet);
        method.addRequestHeader("http.protocol.content-charset", charSet);
        method.setParameter(reqParamName, reqParamValue);
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        log.info("\u8bf7\u6c42{}\u8fd4\u56de\uff1a{}", (Object)url, (Object)respResult);
        return respResult;
    }

    public static String jsonPostHeader(String url, String reqParam, String accessToken, String version) throws Exception {
        HttpClient httpClient = new HttpClient();
        PostMethod method = new PostMethod(url);
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        method.addRequestHeader("http.protocol.content-charset", "UTF-8");
        method.addRequestHeader("accessToken", accessToken);
        method.addRequestHeader("version", version);
        StringRequestEntity entity = new StringRequestEntity(reqParam, "application/json", "utf-8");
        method.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        log.info("\u8bf7\u6c42{}\u8fd4\u56de\uff1a{}", (Object)url, (Object)respResult);
        return respResult;
    }

    public static String jsonPostHeader(String url, String reqParam) throws Exception {
        HttpClient httpClient = new HttpClient();
        PostMethod method = new PostMethod(url);
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        method.addRequestHeader("http.protocol.content-charset", "UTF-8");
        StringRequestEntity entity = new StringRequestEntity(reqParam, "application/xml", "utf-8");
        method.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        log.info("\u8bf7\u6c42{}\u8fd4\u56de\uff1a{}", (Object)url, (Object)respResult);
        return respResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFormMap(String url, Map<String, Object> paramsMap) {
        String string;
        CloseableHttpClient closeableHttpClient = HttpClients.createDefault();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).setRedirectsEnabled(true).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        for (String key : paramsMap.keySet()) {
            list.add(new BasicNameValuePair(key, String.valueOf(paramsMap.get(key))));
        }
        try {
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(list, "utf-8");
            httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            String result = "";
            if (null != closeableHttpResponse) {
                System.out.println(closeableHttpResponse.getStatusLine().getStatusCode());
                if (closeableHttpResponse.getStatusLine().getStatusCode() == 200) {
                    HttpEntity httpEntity = closeableHttpResponse.getEntity();
                    result = EntityUtils.toString((HttpEntity)httpEntity);
                } else {
                    result = "Error Response" + closeableHttpResponse.getStatusLine().getStatusCode();
                }
            }
            log.info("\u8bf7\u6c42{}\u8fd4\u56de\uff1a{}", (Object)url, (Object)result);
            String string2 = result;
            return string2;
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
            string = "\u534f\u8bae\u5f02\u5e38";
            return string;
        }
        catch (ParseException e) {
            e.printStackTrace();
            string = "\u89e3\u6790\u5f02\u5e38";
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            string = "\u4f20\u8f93\u5f02\u5e38";
            return string;
        }
        finally {
            try {
                if (closeableHttpClient != null) {
                    closeableHttpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String post(String url, String reqParam, Map<String, Object> headerParam) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setIntParameter("http.socket.timeout", 5000);
        httpClient.getParams().setIntParameter("http.connection.timeout", 3000);
        PostMethod method = new PostMethod(url);
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        method.addRequestHeader("http.protocol.content-charset", "UTF-8");
        for (Map.Entry<String, Object> vo : headerParam.entrySet()) {
            method.addRequestHeader(vo.getKey(), vo.getKey());
        }
        StringRequestEntity entity = new StringRequestEntity(reqParam);
        method.setRequestEntity((RequestEntity)entity);
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        return respResult;
    }

    public static String get(String url, Map<String, Object> headerParam) throws Exception {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setIntParameter("http.socket.timeout", 5000);
        httpClient.getParams().setIntParameter("http.connection.timeout", 3000);
        GetMethod method = new GetMethod(url);
        HttpUtil.configTimeout(httpClient);
        method.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        method.addRequestHeader("http.protocol.content-charset", "UTF-8");
        for (Map.Entry<String, Object> vo : headerParam.entrySet()) {
            method.addRequestHeader(vo.getKey(), vo.getKey());
        }
        httpClient.executeMethod((HttpMethod)method);
        String respResult = method.getResponseBodyAsString();
        method.releaseConnection();
        log.info("\u8bf7\u6c42{}\u8fd4\u56de\uff1a{}", (Object)url, (Object)respResult);
        return respResult;
    }

    public static void main(String[] args) throws Exception {
        String url = "http://www.ygcloud.net/sign/authz/oauth/v20/token";
        StringBuilder requestParam = new StringBuilder();
        requestParam.append("client_id=747068762850590720&client_secret=Z0ltMjAwNzIwMjIwOTQ1Mzg1NjEil0&grant_type=authorization_code&redirect_uri=http://localhost:8081/&code=b4bb0628-0a8f-462d-8867-9aa0268516b9");
        String s = HttpUtil.get(url, requestParam.toString());
        System.out.println(s);
    }
}

