/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.config.YgCloudConfig;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authentication.util.HttpUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class YgCloudLoginValidateServiceImpl
implements HussarLoginValidateService {
    @Resource
    private YgCloudConfig ygCloudConfig;
    private static final String CACHE_NAME = "login:ygCloud";

    public String getLoginType() {
        return "ygCloud";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        String accessToken = (String)HussarFixedCacheUtil.get((String)CACHE_NAME, (Object)CACHE_NAME);
        if (HussarUtils.isEmpty((Object)accessToken)) {
            accessToken = this.getAccessToken(loginCode);
        }
        String userName = this.getUserInfo(accessToken);
        return userName;
    }

    private String getUserInfo(String accessToken) {
        String userUrl = this.ygCloudConfig.getUserUrl();
        String requestParam = "access_token=" + accessToken;
        String result = "";
        String userName = "";
        try {
            result = HttpUtil.get(userUrl, requestParam);
            JSONObject jsonObject = JSON.parseObject((String)result);
            userName = jsonObject.getString("username");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userName;
    }

    private String getAccessToken(String code) {
        String tokenUrl = this.ygCloudConfig.getTokenUrl();
        String clientId = this.ygCloudConfig.getClientId();
        String clientSecret = this.ygCloudConfig.getClientSecret();
        String redirectUri = this.ygCloudConfig.getRedirectUri();
        String result = "";
        String accessToken = "";
        if (HussarUtils.isNotEmpty((Object)code)) {
            StringBuilder requestParam = new StringBuilder();
            requestParam.append("client_id=" + clientId);
            requestParam.append("&client_secret=" + clientSecret);
            requestParam.append("&grant_type=authorization_code");
            requestParam.append("&redirect_uri=" + redirectUri);
            requestParam.append("&code=" + code);
            try {
                result = HttpUtil.get(tokenUrl, requestParam.toString());
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                accessToken = jsonObject.getString("access_token");
                HussarFixedCacheUtil.put((String)CACHE_NAME, (Object)CACHE_NAME, (Object)accessToken, (long)1600L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return accessToken;
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    public static void main(String[] args) throws Exception {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken";
        String reqParam = "corpid=wx4e8b63210d9c18c6&corpsecret=P-6v1SZBKj7A3Vq3qUQ1MV5t7ONEELnz48g1Fkt8vsZ0SKQ0geCKDdUoPK2sBmI3";
        String s = HttpUtil.get(url, reqParam);
        System.out.println(s);
    }
}

