/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.properties.HussarTenantProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.security.core.stp.SecurityInterface;
import com.jxdinfo.hussar.tenant.model.SysUserTenant;
import com.jxdinfo.hussar.tenant.service.SysUserTenantService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SecurityInterfaceBaseImpl
implements SecurityInterface {
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private SysUserTenantService sysUserTenantService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Autowired
    private HussarTenantProperties hussarTenantProperties;

    public List<String> getPermissionList(Object loginId, String loginType) {
        if (this.hussarTenantProperties.isTenantOpen()) {
            return this.getResourcePermissionByTenant(Long.valueOf(String.valueOf(loginId)));
        }
        return this.getResourcePermission();
    }

    public List<String> getRoleList(Object loginId, String loginType) {
        if (this.hussarTenantProperties.isTenantOpen()) {
            return this.getRolePermissionByTenant(Long.valueOf(String.valueOf(loginId)));
        }
        return this.getRolePermission(Long.valueOf(String.valueOf(loginId)));
    }

    private List<Long> getRoleIdList(Long userId) {
        SysUsers sysUsers = this.sysUsersService.getUser(userId);
        if (HussarUtils.isEmpty((Object)sysUsers)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        List userRoleList = this.sysUserRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId));
        userRoleList.forEach(userRole -> roleIdList.add(userRole.getGrantedRole()));
        if (ToolUtil.isNotEmpty((Object)sysUsers.getEmployeeId()) && ToolUtil.isNotEmpty((Object)sysUsers.getDepartmentId())) {
            List roleList = this.sysStruRoleService.getRolesByStruId(sysUsers.getDepartmentId());
            roleIdList.addAll(roleList);
        }
        return roleIdList;
    }

    private List<String> getResourcePermission() {
        Object obj;
        ArrayList<String> permissions = new ArrayList<String>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty((Object)securityUser) && (obj = securityUser.getExtendUserMap().get("permissions")) instanceof ArrayList) {
            for (Object o : (List)obj) {
                permissions.add((String)o);
            }
        }
        return permissions;
    }

    private List<String> getRolePermission(Long userId) {
        List<Long> roleIdList = this.getRoleIdList(userId);
        ArrayList<String> rolePermissionList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(roleIdList)) {
            List rolesList = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIdList));
            rolesList.forEach(role -> rolePermissionList.add(role.getRolePermission()));
        }
        return rolePermissionList;
    }

    private List<String> getResourcePermissionByTenant(Long userId) {
        return this.getResourcePermissionByDs(this.getTenantCode(userId), userId);
    }

    private List<String> getRolePermissionByTenant(Long userId) {
        return this.getRolePermissionByDs(this.getTenantCode(userId), userId);
    }

    private String getTenantCode(Long userId) {
        String tenantCode = "";
        List userTenantList = this.sysUserTenantService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserTenant::getUserId, (Object)userId)).orderByAsc(SysUserTenant::getTenantId));
        if (ToolUtil.isNotEmpty((Object)userTenantList)) {
            tenantCode = ((SysUserTenant)userTenantList.get(0)).getTenantId();
        }
        return tenantCode;
    }

    @HussarDs(value="#connName")
    private List<String> getResourcePermissionByDs(String connName, Long userId) {
        return this.getResourcePermission();
    }

    @HussarDs(value="#connName")
    private List<String> getRolePermissionByDs(String connName, Long userId) {
        return this.getRolePermission(userId);
    }
}

