/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.config.HussarTenantDataSourceProperties;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.factory.HussarLoginFactory;
import com.jxdinfo.hussar.authentication.service.ChangeDataSourceSelection;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.base.cloud.dto.RoleGrantedAuthority;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.properties.HussarTenantProperties;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.general.theme.service.IThemeService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.tenant.dto.SysTenantDto;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class HussarLoginBaseServiceImpl
implements HussarLoginService {
    @Resource
    private HussarTenantDataSourceProperties hussarTenantDataSourceProperties;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysWelcomeService sysWelcomeService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Resource
    private ChangeDataSourceSelection changeDataSourceSelection;
    @Resource
    private SysDataSourceService sysDataSourceService;
    private static final String[] MANAGE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin"};
    private static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};

    public UserDetails login(AuthcDto authcDto) {
        SysUsers sysUsers;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = HussarUtils.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
        String loginType = null;
        String loginCode = null;
        if (HussarUtils.isNotEmpty((Object)request)) {
            loginType = request.getHeader("loginType");
            loginCode = request.getHeader("loginCode");
        }
        if (HussarUtils.isEmpty(loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").beforeSelectUser(request, loginCode, authcDto);
        } else {
            String username = HussarLoginFactory.getLoginValidateService(loginType).beforeSelectUser(request, loginCode, authcDto);
            if (HussarUtils.isNotEmpty((Object)username)) {
                authcDto.setUsername(username);
            }
        }
        String account = authcDto.getUsername();
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)authcDto.getUsername())) {
            account = authcDto.getUsername().toUpperCase();
        }
        if (HussarUtils.isEmpty((Object)(sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false)))) {
            sysUsers = new SysUsers();
            sysUsers.setUserName(authcDto.getUsername());
            this.throwExceptionPersionally(sysUsers, BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
        } else if (this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !authcDto.getUsername().equals(sysUsers.getUserAccount())) {
            this.throwExceptionPersionally(sysUsers, BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
        }
        SysUsersDto sysUsersDto = new SysUsersDto();
        CopyPropertieUtils.copyProperties((Object)sysUsersDto, (Object)sysUsers);
        if (HussarUtils.isEmpty((Object)loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").validateUser(authcDto, sysUsersDto);
        } else {
            HussarLoginFactory.getLoginValidateService(loginType).validateUser(authcDto, sysUsersDto);
        }
        UserDetails userDetails = this.getLoginSecurityUser(sysUsers);
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            sysUsers.setLastLoginTime(Java8DateUtils.currentLocalDateTime());
            sysUsers.setLastEditor(userDetails.getUserId());
            sysUsers.setLastTime(LocalDateTime.now());
            this.iSysUsersService.updateById((Object)sysUsers);
        }
        return userDetails;
    }

    private void throwExceptionPersionally(SysUsers sysUsers, String message) {
        BaseException e = new BaseException(message);
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName("\u767b\u5f55");
        auditLogModel.setExceptionInfo((Throwable)e);
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
        auditLogModel.setEventDesc(message);
        UserDetails userDetails = new UserDetails();
        if (sysUsers.getId() != null) {
            userDetails.setUserId(sysUsers.getId());
        }
        userDetails.setUserName(sysUsers.getUserName());
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        throw e;
    }

    private UserDetails getLoginSecurityUser(SysUsers sysUsers) {
        UserDetails userDetails = new UserDetails();
        if (this.hussarTenantProperties.isTenantOpen()) {
            ResourceGrantedAuthority resourceGrantedAuthority;
            List tenantList = this.sysTenantService.getEnableTenantByUserId(sysUsers.getId());
            if (HussarUtils.isEmpty((Object)tenantList)) {
                throw new BaseException("\u7528\u6237\u65e0\u53ef\u7528\u79df\u6237");
            }
            Long tenantId = 0L;
            String tenantName = "";
            boolean isNotDefaultTenant = true;
            if (tenantList.size() == 1) {
                tenantId = ((SysTenantDto)tenantList.get(0)).getId();
                tenantName = ((SysTenantDto)tenantList.get(0)).getTenantName();
            } else {
                for (int i = tenantList.size() - 1; i >= 0; --i) {
                    LocalDateTime now;
                    SysTenantDto tenant = (SysTenantDto)tenantList.get(i);
                    if (TenantConstant.ADMIN_TENANT_ID.equals(tenant.getId())) {
                        tenantList.remove(tenant);
                        continue;
                    }
                    if (!"1".equals(tenant.getTenantStatus())) {
                        tenantList.remove(tenant);
                        continue;
                    }
                    if ("1".equals(tenant.getValidTimeFlag()) && ((now = LocalDateTime.now()).isBefore(tenant.getValidStartTime()) || now.isAfter(tenant.getValidEndTime()))) {
                        tenantList.remove(tenant);
                        continue;
                    }
                    if (!"1".equals(tenant.isDefaultTenant())) continue;
                    tenantId = tenant.getId();
                    tenantName = tenant.getTenantName();
                    isNotDefaultTenant = false;
                    break;
                }
            }
            if (HussarUtils.isEmpty((Object)tenantList)) {
                throw new BaseException("\u7528\u6237\u65e0\u53ef\u7528\u79df\u6237");
            }
            if (isNotDefaultTenant) {
                tenantId = ((SysTenantDto)tenantList.get(0)).getId();
                tenantName = ((SysTenantDto)tenantList.get(0)).getTenantName();
            }
            userDetails.setTenantId(tenantId);
            userDetails.addExtendUserMap("tenantName", (Object)tenantName);
            userDetails.addExtendUserMap("tenantId", (Object)tenantId);
            String connName = this.sysTenantService.getConnName(tenantId);
            this.sysDataSourceService.addDataSourceByConnName(connName);
            userDetails.addExtendUserMap(this.hussarTenantDataSourceProperties.getDatasourceKeyByHeader(), (Object)connName);
            userDetails.addExtendUserMap("connName", (Object)connName);
            List rolesList = this.changeDataSourceSelection.getRolesIdByUserId(sysUsers.getId(), connName);
            userDetails.addExtendUserMap("gradeAdmin", (Object)(HussarUtils.isNotEmpty((Object)rolesList) && rolesList.contains(SysUserAndRole.GRADEADMIN_ROLE.getValue()) ? 1 : 0));
            userDetails.addExtendUserMap("rolesList", (Object)rolesList);
            if ("master".equals(connName)) {
                resourceGrantedAuthority = this.getPermissionByRoleIds(rolesList, sysUsers.getId());
                userDetails.addExtendUserMap("deptId", (Object)sysUsers.getDepartmentId());
                userDetails.addExtendUserMap("deptName", (Object)this.getDeptName(sysUsers.getDepartmentId()));
            } else {
                resourceGrantedAuthority = this.changeDataSourceSelection.getPermissionByRoleIds(rolesList, connName);
                Long deptId = this.changeDataSourceSelection.getTenantStaff(sysUsers.getId(), connName).getDepartmentId();
                userDetails.addExtendUserMap("deptId", (Object)deptId);
                userDetails.addExtendUserMap("deptName", (Object)this.changeDataSourceSelection.getDeptName(deptId, connName));
            }
            userDetails.addExtendUserMap("permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
            userDetails.addExtendUserMap("theme", (Object)this.themeService.queryUserThemeWithUserId(sysUsers.getId()));
        } else {
            userDetails.addExtendUserMap("deptId", (Object)sysUsers.getDepartmentId());
            userDetails.addExtendUserMap("deptName", (Object)this.getDeptName(sysUsers.getDepartmentId()));
            List<Long> rolesList = this.getRolesIdByUserId(sysUsers.getId());
            userDetails.addExtendUserMap("gradeAdmin", (Object)(HussarUtils.isNotEmpty(rolesList) && rolesList.contains(SysUserAndRole.GRADEADMIN_ROLE.getValue()) ? 1 : 0));
            Long employeeId = sysUsers.getEmployeeId();
            Long departmentId = sysUsers.getDepartmentId();
            if (HussarUtils.isNotEmpty((Object)employeeId) && HussarUtils.isNotEmpty((Object)departmentId)) {
                List<Long> roleList = this.getRolesIdByStruId(sysUsers.getDepartmentId());
                if (HussarUtils.isNotEmpty(rolesList)) {
                    rolesList.addAll(roleList);
                }
            }
            userDetails.addExtendUserMap("rolesList", rolesList);
            ResourceGrantedAuthority resourceGrantedAuthority = this.getPermissionByRoleIds(rolesList, sysUsers.getId());
            userDetails.addExtendUserMap("permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
            ArrayList<Long> roleList = new ArrayList<Long>(rolesList);
            roleList.add(userDetails.getUserId());
            userDetails.addExtendUserMap("welcomeUrl", (Object)this.sysWelcomeService.getUserIndex(roleList));
            userDetails.addExtendUserMap("theme", (Object)this.themeService.queryUserThemeWithUserId(sysUsers.getId()));
        }
        userDetails.setUserId(sysUsers.getId());
        userDetails.addExtendUserMap("account", (Object)sysUsers.getUserAccount());
        userDetails.setUserName(sysUsers.getUserName());
        userDetails.addExtendUserMap("employeeId", (Object)sysUsers.getEmployeeId());
        userDetails.addExtendUserMap("securityLevel", (Object)sysUsers.getSecurityLevel());
        userDetails.addExtendUserMap("accountStatus", (Object)sysUsers.getAccountStatus());
        userDetails.setMaxSameCount(Integer.valueOf(sysUsers.getMaxSessions()));
        return userDetails;
    }

    private String getDeptName(Long deptId) {
        SysOrganVo dept = this.iSysStruService.getOrgInfoByOrgId(deptId);
        if (HussarUtils.isNotEmpty((Object)dept) && HussarUtils.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    private List<Long> getRolesIdByUserId(Long userId) {
        return this.iSysUserRoleService.getRolesByUserId(userId);
    }

    private List<Long> getRolesIdByStruId(Long struId) {
        return this.iSysStruRoleService.getRolesByStruId(struId);
    }

    private ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList, Long userId) {
        ArrayList<String> resourcePermissions;
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        if (roleList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            List resourcesList = this.sysResourcesService.list();
            resourcePermissions = new ArrayList<String>();
            for (SysResources resources : resourcesList) {
                resourcePermissions.add(resources.getPermissions());
            }
        } else {
            resourcePermissions = this.sysResourcesService.queryPermissionsByRoleIds(roleList);
        }
        if (HussarUtils.isNotEmpty((Object)resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList(resourcePermissions);
        }
        return resourceGrantedAuthority;
    }

    private RoleGrantedAuthority getRolePermissions(List<Long> roleList, Long userId) {
        RoleGrantedAuthority roleGrantedAuthority = new RoleGrantedAuthority();
        List roles = new ArrayList();
        if (HussarUtils.isNotEmpty(roleList)) {
            roles = this.sysRolesService.listByIds(roleList);
        }
        ArrayList rolePermissions = new ArrayList();
        roles.forEach(sysRole -> {
            if (HussarUtils.isNotEmpty((Object)sysRole.getRolePermission())) {
                rolePermissions.add(sysRole.getRolePermission());
            }
        });
        if (HussarUtils.isNotEmpty(rolePermissions)) {
            roleGrantedAuthority.setGrantAuthorityList(rolePermissions);
        }
        return roleGrantedAuthority;
    }
}

