/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.enums.AccessType;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authentication.util.LoginExceptionMailUtil;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IPageViewConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseDisabledAccountException;
import com.jxdinfo.hussar.common.exception.BaseDormancyException;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.exception.BaseLoginTimeRefuseException;
import com.jxdinfo.hussar.common.exception.BaseTemporaryAccountInvalidException;
import com.jxdinfo.hussar.common.exception.BaseUsernameOrPasswordErrorException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.properties.HussarTenantProperties;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class HussarDefaultLoginValidateServiceImpl
implements HussarLoginValidateService {
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private IPageViewConfigService pageViewConfigService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    private static final Long[] ADMINS = new Long[]{1450756958461300737L, 1450757481235202050L, 1450757527330615298L, 1450757604556025858L, 1450757642371981314L};

    public String getLoginType() {
        return "default";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        this.verifyCode(authcDto);
        return null;
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
        String loginType = authcDto.getIsIndex();
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersDto);
        if (!Objects.equals(loginType, AccessType.MOBILE.getLoginType()) && this.hussarLoginConfigService.getTotpOpen().booleanValue()) {
            this.checkedTotp(authcDto, sysUsers);
        }
        this.defaultValidateUser(authcDto, sysUsers);
    }

    private void verifyCode(AuthcDto authcDto) {
        String loginType = authcDto.getIsIndex();
        Boolean isKaptcha = Objects.equals(AccessType.INDEX.getLoginType(), loginType) ? this.pageViewConfigService.isLoginViewKaptcha() : this.hussarLoginConfigService.getKaptchaOpen().booleanValue();
        if (!Objects.equals(loginType, AccessType.MOBILE.getLoginType()) && isKaptcha.booleanValue()) {
            String kaptcha = StringUtils.trimToEmpty((String)authcDto.getKaptcha());
            String kaptchasuffix = StringUtils.trimToEmpty((String)authcDto.getKaptchasuffix());
            String code = (String)HussarCacheUtil.get((String)"KAPTCHA_CODE", (Object)kaptchasuffix, String.class);
            if (StringUtils.isBlank((CharSequence)code)) {
                throw new BaseException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
            }
            HussarCacheUtil.evict((String)"KAPTCHA_CODE", (Object)kaptchasuffix);
            if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
                BaseException e = new BaseException("\u9a8c\u8bc1\u7801\u9519\u8bef");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u9a8c\u8bc1\u7801\u9519\u8bef");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserName(authcDto.getUsername());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
    }

    private void checkedTotp(AuthcDto authcDto, SysUsers sysUsers) {
        if (!this.abstractOTPCredentialsMatcher.verify(sysUsers.getTotpKey(), authcDto.getTotp(), this.hussarLoginConfigService.getTotpOffsetMin())) {
            BaseException e = new BaseException("\u52a8\u6001\u7801\u9519\u8bef");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u52a8\u6001\u7801\u9519\u8bef");
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private void defaultValidateUser(AuthcDto authcDto, SysUsers sysUsers) {
        SysBaseConfig sysBaseConfig;
        Comparable<ChronoLocalDateTime<?>> now;
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failNumberConfig = iSysBaseConfigService.getSysBaseConfig("fail_number");
        String tryLoginTime = failNumberConfig.getConfigValue();
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = this.dynamicDataSourceService.currentDsName();
        String userName = sysUsers.getUserName();
        String userId = String.valueOf(sysUsers.getId());
        String password = authcDto.getCipher();
        String encPwd = this.credentialsMatcher.passwordEncode(password.getBytes());
        if (sysUsers.getAccountStatus().equals(UserStatus.LOCKED.getCode())) {
            BaseException e = new BaseException("\u8d26\u6237\u5df2\u51bb\u7ed3\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u8d26\u6237\u5df2\u51bb\u7ed3\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (this.hussarTenantProperties.isTenantOpen()) {
            if (loginLock.userIsLock(userId, connName)) {
                BaseDisabledAccountException e = new BaseDisabledAccountException("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        } else if (loginLock.userIsLock(userId)) {
            BaseDisabledAccountException e = new BaseDisabledAccountException("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (ToolUtil.isEmpty((Object)encPwd) || !encPwd.equalsIgnoreCase(sysUsers.getPassword()) || password.length() > 16) {
            int loginChanceTime;
            int loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userId);
            loginLock.addUserCache(userId, sysUsers.getUserName(), Integer.parseInt(tryLoginTime));
            int n = loginChanceTime = loginChance < 0 ? 0 : loginChance;
            if (loginChanceTime == 0) {
                new Thread(() -> LoginExceptionMailUtil.sendLockMail((String)userName)).start();
                BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException("\u5f53\u524d\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u5f53\u524d\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
            BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (this.hussarTenantProperties.isTenantOpen()) {
            loginLock.removeUserCache(userId, connName);
        } else {
            loginLock.removeUserCache(userId);
        }
        if (UserStatus.TEMPORARY.getCode().equals(sysUsers.getTypeProperty())) {
            LocalDateTime beginTime = sysUsers.getStartTime();
            LocalDateTime endTime = sysUsers.getExpiredTime();
            now = Java8DateUtils.currentLocalDateTime();
            if (beginTime.isAfter((ChronoLocalDateTime<?>)now)) {
                BaseTemporaryAccountInvalidException e = new BaseTemporaryAccountInvalidException(sysUsers.getUserName() + BaseExceptionEnum.TEMPORARYACCOUNT_INVALID.getMessage());
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u4e34\u65f6\u8d26\u6237\u672a\u5728\u6709\u6548\u671f\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
        if (!Arrays.asList(ADMINS).contains(sysUsers.getId())) {
            if (UserStatus.DORMANCY.getCode().equals(sysUsers.getAccountStatus())) {
                BaseDormancyException e = new BaseDormancyException(sysUsers.getUserName() + BaseExceptionEnum.ACCOUNT_DORMANCY.getMessage());
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u8d26\u6237\u5df2\u4f11\u7720\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
            if ("1".equals(sysUsers.getLoginTimeLimit())) {
                Date now2 = null;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
                boolean flag = false;
                Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                String startTime = Java8DateUtils.convertLocalTimeToString((LocalTime)sysUsers.getAccessLoginStartTime());
                String endTime = Java8DateUtils.convertLocalTimeToString((LocalTime)sysUsers.getAccessLoginEndTime());
                Date dt1 = null;
                Date dt2 = null;
                try {
                    dt1 = time.parse(startTime);
                    dt2 = time.parse(endTime);
                    now2 = time.parse(time.format(date));
                }
                catch (Exception e) {
                    BaseException exception = new BaseException("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw exception;
                }
                if (dt1.getTime() <= now2.getTime() && now2.getTime() <= dt2.getTime()) {
                    flag = true;
                }
                if (!flag) {
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
            String loginTimeLimt = iSysBaseConfigService.getSysBaseConfig("login_time_limit").getConfigValue();
            if ("0".equals(sysUsers.getLoginTimeLimit()) && "0".equals(loginTimeLimt)) {
                boolean flag = false;
                now = Java8DateUtils.currentLocalTime();
                LocalTime startTime = Java8DateUtils.convertStringToLocalTime((String)iSysBaseConfigService.getSysBaseConfig("login_start_time").getConfigValue());
                LocalTime endTime = Java8DateUtils.convertStringToLocalTime((String)iSysBaseConfigService.getSysBaseConfig("login_end_time").getConfigValue());
                if (((LocalTime)now).isAfter(startTime) && endTime.isAfter((LocalTime)now)) {
                    flag = true;
                }
                if (!flag) {
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
        }
        if ("1".equals(sysUsers.getLoginIpLimit())) {
            boolean canLogin = false;
            String loginIp = IpUtils.getIp();
            List list = this.iSysUserIpService.selectUserIp(sysUsers.getId());
            for (String ip : list) {
                if (!StringUtils.equals((CharSequence)loginIp, (CharSequence)ip)) continue;
                canLogin = true;
                break;
            }
            if (!canLogin) {
                LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
        if (ToolUtil.isNotEmpty((Object)(sysBaseConfig = iSysBaseConfigService.getSysBaseConfig("login_ip_limit")))) {
            String loginIpLimit = sysBaseConfig.getConfigValue();
            if ("0".equals(sysUsers.getLoginIpLimit()) && "0".equals(loginIpLimit)) {
                List<String> forbidIpList;
                List<String> allowIpList;
                boolean flag = false;
                String loginIp = IpUtils.getIp();
                String allowIp = iSysBaseConfigService.getSysBaseConfig("allow_login_ip").getConfigValue();
                String forbidIp = iSysBaseConfigService.getSysBaseConfig("forbid_login_ip").getConfigValue();
                if (ToolUtil.isEmpty((Object)allowIp) && ToolUtil.isEmpty((Object)forbidIp)) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)allowIp) && ((allowIpList = Arrays.asList(allowIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)forbidIp) && !flag && (!(forbidIpList = Arrays.asList(forbidIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (!flag) {
                    LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
        }
    }
}

