/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.jxdinfo.hussar.authentication.config.HussarTenantDataSourceProperties;
import com.jxdinfo.hussar.authentication.service.ChangeDataSourceSelection;
import com.jxdinfo.hussar.authentication.service.HussarChangeTenantService;
import com.jxdinfo.hussar.authorization.organ.model.SysTenantStaff;
import com.jxdinfo.hussar.authorization.organ.vo.TenantVo;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.general.theme.service.IThemeService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.model.SysUserTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import com.jxdinfo.hussar.tenant.service.SysUserTenantService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HussarChangeTenantServiceImpl
implements HussarChangeTenantService {
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private SysUserTenantService sysUserTenantService;
    @Resource
    private HussarTenantDataSourceProperties hussarTenantDataSourceProperties;
    @Resource
    private ChangeDataSourceSelection changeDataSourceSelection;
    @Resource
    private IThemeService themeService;
    @Resource
    private SysDataSourceService sysDataSourceService;

    public UserDetails changeTenant(TenantVo tenantVo) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            throw new BaseException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Long tenantId = Long.parseLong(tenantVo.getTenantid());
        if (!HussarSecurityUtils.changeTenant((Long)tenantId)) {
            throw new BaseException("\u5207\u6362\u7684\u79df\u6237id\u4e3a\u7a7a");
        }
        SysTenant tenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysTenant::getId, (Object)tenantId));
        Long userId = user.getId();
        this.sysUserTenantService.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(SysUserTenant::getUserId, (Object)userId)).set(SysUserTenant::getDefaultTenant, (Object)"0"));
        this.sysUserTenantService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(SysUserTenant::getUserId, (Object)userId)).eq(SysUserTenant::getTenantId, (Object)tenantId)).set(SysUserTenant::getDefaultTenant, (Object)"1"));
        String connName = this.sysTenantService.getConnName(tenantId);
        this.sysDataSourceService.addDataSourceByConnName(connName);
        HussarSecurityUtils.putSessionExtend((String)"tenantId", (Object)tenant.getId());
        HussarSecurityUtils.putSessionExtend((String)"tenantName", (Object)tenant.getTenantName());
        HussarSecurityUtils.putSessionExtend((String)this.hussarTenantDataSourceProperties.getDatasourceKeyByHeader(), (Object)connName);
        HussarSecurityUtils.putSessionExtend((String)"connName", (Object)connName);
        SysTenantStaff sysTenantStaff = this.changeDataSourceSelection.getTenantStaff(user.getId(), connName);
        Long deptId = sysTenantStaff.getDepartmentId();
        HussarSecurityUtils.putSessionExtend((String)"deptId", (Object)deptId);
        HussarSecurityUtils.putSessionExtend((String)"deptName", (Object)this.changeDataSourceSelection.getDeptName(deptId, connName));
        List rolesList = this.changeDataSourceSelection.getRolesIdByUserId(user.getId(), connName);
        HussarSecurityUtils.putSessionExtend((String)"gradeAdmin", (Object)(HussarUtils.isNotEmpty((Object)rolesList) && rolesList.contains(SysUserAndRole.GRADEADMIN_ROLE.getValue()) ? 1 : 0));
        HussarSecurityUtils.putSessionExtend((String)"rolesList", (Object)rolesList);
        ResourceGrantedAuthority resourceGrantedAuthority = this.changeDataSourceSelection.getPermissionByRoleIds(rolesList, connName);
        HussarSecurityUtils.putSessionExtend((String)"permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
        HussarSecurityUtils.putSessionExtend((String)"theme", (Object)this.themeService.queryUserThemeWithUserId(userId));
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        HussarCacheUtil.evict((String)"login_user_info", (Object)userDetails.getAccessToken());
        return userDetails;
    }
}

