/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.service.ChangeDataSourceSelection;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysTenantStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.ISysTenantStaffService;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysTenantResources;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysTenantResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@HussarTransactional
public class ChangeDataSourceSelectionImpl
implements ChangeDataSourceSelection {
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private ISysTenantResourcesService sysTenantResourcesService;
    @Resource
    private ISysTenantStaffService sysTenantStaffService;
    @Resource
    private SysTenantService sysTenantService;

    @HussarDs(value="#connName")
    public SysTenantStaff getTenantStaff(Long userId, String connName) {
        SysTenantStaff tenantStaff = (SysTenantStaff)this.sysTenantStaffService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysTenantStaff::getUserId, (Object)userId));
        if (HussarUtils.isNotEmpty((Object)tenantStaff)) {
            return tenantStaff;
        }
        throw new BaseException("\u7528\u6237\u4e0d\u5b58\u5728");
    }

    @HussarDs(value="#connName")
    public String getDeptName(Long deptId, String connName) {
        SysOrgan dept = this.sysStruService.getOrganInfoByDeparmentId(deptId);
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    @HussarDs(value="#connName")
    public List<Long> getRolesIdByUserId(Long userId, String connName) {
        return this.sysUserRoleService.getRolesByUserId(userId);
    }

    @HussarDs(value="#connName")
    public List<Long> getRolesIdByStruId(Long struId, String connName) {
        return this.sysStruRoleService.getRolesByStruId(struId);
    }

    @HussarDs(value="#connName")
    public ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList, String connName) {
        ArrayList<String> resourcePermissions;
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        if (roleList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            List resourcesList = this.sysTenantResourcesService.list((Wrapper)new LambdaQueryWrapper().eq(SysTenantResources::getStatus, (Object)"1"));
            resourcePermissions = new ArrayList<String>();
            for (SysResources resources : resourcesList) {
                resourcePermissions.add(resources.getPermissions());
            }
        } else {
            resourcePermissions = this.sysTenantResourcesService.queryPermissionsByRoleIds(roleList);
        }
        if (HussarUtils.isNotEmpty((Object)resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList((List)resourcePermissions);
        }
        return resourceGrantedAuthority;
    }

    @HussarDs(value="master")
    public boolean isOverQuantityLimit(Long tenantId) {
        SysTenant sysTenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getId, (Object)tenantId));
        int quantityLimit = sysTenant.getQuantityLimit();
        int userNum = this.sysTenantService.getTenantUserNumber(tenantId);
        return userNum >= quantityLimit;
    }

    @HussarDs(value="#connName")
    public List<JSTreeModel> getTenantUserOrderTree(String connName, Long orgId) {
        return this.sysStruService.getTenantUserOrderTree(orgId);
    }

    @HussarDs(value="#connName")
    public void saveUserRole(String connName, SysUserRole userRole) {
        this.sysUserRoleService.save((Object)userRole);
    }
}

