/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.service.AuthcService;
import com.jxdinfo.hussar.authentication.vo.LoginInfoVo;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.service.SysLoginUserService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthcServiceImpl
implements AuthcService {
    private static Logger logger = LoggerFactory.getLogger(AuthcServiceImpl.class);
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private SysLoginUserService sysLoginUserService;
    @Resource
    private IHussarPwdConfigService pwdConfigService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;

    public ApiResponse<LoginInfoVo> tenantLoginWithCode(AuthcDto authcDto) {
        String tenantCode = authcDto.getTenantCode();
        List list = this.sysTenantService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysTenant::getTenantCode, (Object)tenantCode)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        SysDataSource dataSource = this.sysDataSourceService.getByTenantCode(tenantCode);
        if (list == null || list.size() <= 0) {
            throw new BaseException("\u79df\u6237\u7f16\u53f7\u4e0d\u5b58\u5728");
        }
        SysTenant tenant = (SysTenant)list.get(0);
        if ("1".equals(tenant.getLoginTimeLimit())) {
            String beginTime = tenant.getAccessLoginStartTime();
            String endTime = tenant.getAccessLoginEndTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(beginTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    throw new BaseException("\u79df\u6237\u672a\u5728\u6709\u6548\u671f\u5185");
                }
            }
            catch (ParseException e) {
                logger.error(e.getMessage());
            }
        }
        if (ToolUtil.isEmpty((Object)dataSource) || ToolUtil.isEmpty((Object)dataSource.getConnName())) {
            throw new BaseException("\u672a\u80fd\u83b7\u53d6\u79df\u6237\u7684\u6570\u636e\u6e90");
        }
        this.sysDataSourceService.addDataSourceByConnName(dataSource.getConnName());
        return this.changeTempDs(dataSource.getConnName(), authcDto);
    }

    @HussarDs(value="#connName")
    private ApiResponse<LoginInfoVo> changeTempDs(String connName, AuthcDto authcDto) {
        authcDto.setDsName(connName);
        return ApiResponse.success((Object)new LoginInfoVo());
    }

    public ApiResponse<LoginInfoVo> tenantLoginByAccount(AuthcDto authcDto) {
        String username = authcDto.getUsername();
        String tenantCode = this.sysLoginUserService.getTenantCodeByAccount(username);
        if (ToolUtil.isNotEmpty((Object)tenantCode)) {
            SysDataSource dataSource;
            List list = this.sysTenantService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysTenant::getTenantCode, (Object)tenantCode)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            if (list == null || list.size() <= 0) {
                throw new BaseException("\u7528\u6237\u6240\u5728\u79df\u6237\u83b7\u53d6\u5931\u8d25");
            }
            SysTenant tenant = (SysTenant)list.get(0);
            if ("1".equals(tenant.getLoginTimeLimit())) {
                String beginTime = tenant.getAccessLoginStartTime();
                String endTime = tenant.getAccessLoginEndTime();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date begin = sdf.parse(beginTime);
                    Date end = sdf.parse(endTime);
                    Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                    if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                        throw new BaseException("\u6240\u5728\u79df\u6237\u672a\u5728\u6709\u6548\u671f\u5185");
                    }
                }
                catch (ParseException e) {
                    logger.error(e.getMessage());
                }
            }
            if (ToolUtil.isEmpty((Object)(dataSource = this.sysDataSourceService.getByTenantCode(tenantCode))) || ToolUtil.isEmpty((Object)dataSource.getConnName())) {
                throw new BaseException("\u672a\u80fd\u83b7\u53d6\u79df\u6237\u7684\u6570\u636e\u6e90");
            }
            this.sysDataSourceService.addDataSourceByConnName(dataSource.getConnName());
            return this.changeTempDs(dataSource.getConnName(), authcDto);
        }
        throw new BaseException("\u7528\u6237\u6240\u5728\u79df\u6237\u83b7\u53d6\u5931\u8d25");
    }

    public void logout() {
        SecurityUtil.logout();
    }

    public ApiResponse<Map<String, String>> check() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.pwdConfigService.isForceChangePwd()) {
            SysUsers sysUser = this.iSysUsersService.getUser(shiroUser.getId());
            if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
                map.put("firstLogin", "NO");
                map.put("changePwd", "NO");
                return ApiResponse.success(map);
            }
            if (this.iSysUsersService.isFirstLogin(shiroUser.getId())) {
                map.put("firstLogin", "YES");
            } else {
                map.put("firstLogin", "NO");
            }
            if (this.iSysUsersService.isPwdOverdue(shiroUser.getId())) {
                map.put("changePwd", "YES");
            } else {
                map.put("changePwd", "NO");
            }
        } else {
            map.put("firstLogin", "NO");
            map.put("changePwd", "NO");
        }
        return ApiResponse.success(map);
    }

    public ApiResponse<Map<String, Object>> getShow() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List sysBaseConfigs = this.sysBaseConfigService.getTotpCaptchaConfigList();
        if (ToolUtil.isNotEmpty((Object)sysBaseConfigs)) {
            Map configMap = sysBaseConfigs.stream().collect(Collectors.toMap(SysBaseConfig::getConfigKey, Function.identity()));
            SysBaseConfig topTOpen = (SysBaseConfig)configMap.get("totp_open");
            SysBaseConfig kaptchaOpen = (SysBaseConfig)configMap.get("kaptcha_open");
            SysBaseConfig loginViewKaptcha = (SysBaseConfig)configMap.get("login_view_kaptcha");
            map.put("totp", topTOpen == null ? false : "0".equals(topTOpen.getConfigValue()));
            map.put("kaptcha", kaptchaOpen == null ? false : "0".equals(kaptchaOpen.getConfigValue()));
            map.put("indexKaptcha", loginViewKaptcha == null ? false : "0".equals(loginViewKaptcha.getConfigValue()));
        }
        map.put("tenant", this.hussarBaseProperties.isTenantOpen());
        map.put("tenantModel", this.hussarBaseProperties.getTenantUserModel());
        return ApiResponse.success(map);
    }

    public ApiResponse<SecurityUser> queryLoginUserInfo(AuthcDto authcDto) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        securityUser.setDeptIcon(this.sysOrganTypeService.getDeptIcon(securityUser.getDeptId()));
        return ApiResponse.success((Object)securityUser);
    }
}

