/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.factory.HussarLoginFactory;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.base.cloud.dto.RoleGrantedAuthority;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.theme.service.IThemeService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.properties.HussarDynamicProperties;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@HussarTokenDs
@Service
public class HussarLoginBaseServiceImpl
implements HussarLoginService {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysWelcomeService sysWelcomeService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    private static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Resource
    private HussarDynamicProperties hussarDynamicProperties;

    public UserDetails login(AuthcDto authcDto) {
        SysUsers sysUsers;
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ToolUtil.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
        String loginType = null;
        String loginCode = null;
        boolean tenantOpen = this.hussarTenantProperties.isEnabled() && this.tenantCommonService != null;
        DefaultTenant hussarTenantDefinition = new DefaultTenant();
        if (ToolUtil.isNotEmpty((Object)request)) {
            loginType = request.getHeader("loginType");
            try {
                loginCode = request.getHeader("loginCode");
                if (ToolUtil.isNotEmpty((Object)loginCode)) {
                    loginCode = URLDecoder.decode(request.getHeader("loginCode"), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e2) {
                e2.printStackTrace();
            }
            if (tenantOpen) {
                hussarTenantDefinition = this.tenantCommonService.parse();
                Optional.ofNullable(hussarTenantDefinition).ifPresent(e -> {
                    this.checkTeant((HussarTenantDefinition)e);
                    authcDto.setTenantCode(e.getTenantCode());
                    authcDto.setDsName(e.getConnName());
                    if (!this.hussarTenantProperties.getType().equals("url") && !this.hussarTenantProperties.getType().equals("domain")) {
                        authcDto.setDsName("master");
                    }
                });
            } else {
                authcDto.setTenantCode("master");
                authcDto.setDsName("master");
            }
        }
        if (ToolUtil.isEmpty(loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").beforeSelectUser(request, loginCode, authcDto);
        } else {
            String username = HussarLoginFactory.getLoginValidateService(loginType).beforeSelectUser(request, loginCode, authcDto);
            if (ToolUtil.isNotEmpty((Object)username)) {
                authcDto.setUsername(username);
            }
        }
        String account = authcDto.getUsername();
        if (!this.hussarLoginConfigService.getLoginUpperOpen(authcDto.getDsName()).booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)authcDto.getUsername())) {
            account = authcDto.getUsername().toUpperCase();
        }
        if (ToolUtil.isEmpty((Object)(sysUsers = (SysUsers)this.iSysUsersService.getOne(authcDto.getDsName(), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false)))) {
            sysUsers = new SysUsers();
            sysUsers.setUserName(authcDto.getUsername());
            this.throwExceptionPersionally(authcDto, sysUsers, BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
        } else if (this.hussarLoginConfigService.getLoginUpperOpen(authcDto.getDsName()).booleanValue() && !authcDto.getUsername().equals(sysUsers.getUserAccount())) {
            this.throwExceptionPersionally(authcDto, sysUsers, BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
        }
        SysUsersDto sysUsersDto = new SysUsersDto();
        CopyPropertieUtils.copyProperties((Object)sysUsersDto, (Object)sysUsers);
        if (ToolUtil.isEmpty((Object)loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").validateUser(authcDto, sysUsersDto);
        } else {
            HussarLoginFactory.getLoginValidateService(loginType).validateUser(authcDto, sysUsersDto);
        }
        UserDetails userDetails = this.getLoginSecurityUser(tenantOpen, (HussarTenantDefinition)hussarTenantDefinition, sysUsers);
        if (ToolUtil.isNotEmpty((Object)userDetails)) {
            sysUsers.setLastLoginTime(Java8DateUtils.currentLocalDateTime());
            sysUsers.setLastEditor(userDetails.getUserId());
            sysUsers.setLastTime(LocalDateTime.now());
            this.iSysUsersService.updateById(authcDto.getDsName(), (Object)sysUsers);
        }
        return userDetails;
    }

    private void checkTeant(HussarTenantDefinition tenantInfo) {
        if (StringUtils.isNotBlank((CharSequence)tenantInfo.getTenantCode()) && !tenantInfo.getConnName().equals("master")) {
            Boolean timeLimit = tenantInfo.getTimeLimit();
            LocalDateTime startTime = tenantInfo.getStartTime();
            LocalDateTime endTime = tenantInfo.getEndTime();
            String tenantStatus = tenantInfo.getTenantStatus();
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("0"), (String)"\u79df\u6237\u5df2\u5220\u9664");
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("2"), (String)"\u79df\u6237\u5df2\u5931\u6548");
            AssertUtil.isFalse((tenantStatus.equalsIgnoreCase("3") || tenantStatus.equalsIgnoreCase("4") ? 1 : 0) != 0, (String)"\u79df\u6237\u4e0d\u53ef\u7528");
            AssertUtil.isFalse((timeLimit != false && endTime.isBefore(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)"\u79df\u6237\u5df2\u5931\u6548");
            AssertUtil.isFalse((timeLimit != false && startTime.isAfter(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)"\u79df\u6237\u672a\u751f\u6548");
        }
    }

    private void throwExceptionPersionally(AuthcDto authcDto, SysUsers sysUsers, String message) {
        HussarTenantDefinition hussarTenantDefinition;
        BaseException e = new BaseException(message);
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName("\u767b\u5f55");
        auditLogModel.setExceptionInfo((Throwable)e);
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
        auditLogModel.setEventDesc(message);
        UserDetails userDetails = new UserDetails();
        if (sysUsers.getId() != null) {
            userDetails.setUserId(sysUsers.getId());
        }
        if (HussarUtils.isNotBlank((CharSequence)authcDto.getDsName()) && !authcDto.getDsName().equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
            userDetails.setTenantId(hussarTenantDefinition.getTenantId());
            userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
        }
        userDetails.setUserName(sysUsers.getUserName());
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        throw e;
    }

    private UserDetails getLoginSecurityUser(boolean tenantOpen, HussarTenantDefinition tenantInfo, SysUsers sysUsers) {
        UserDetails userDetails = new UserDetails();
        userDetails.setUserId(sysUsers.getId());
        if (tenantOpen && HussarUtils.isNotEmpty((Object)tenantInfo)) {
            userDetails.addExtendUserMap(this.hussarDynamicProperties.getDatasourceKeyByHeader(), (Object)tenantInfo.getConnName());
            userDetails.setTenantId(tenantInfo.getTenantId());
            userDetails.setTenantCode(tenantInfo.getTenantCode());
            userDetails.addExtendUserMap("tenantName", (Object)tenantInfo.getTenantName());
            userDetails.addExtendUserMap("tcode", (Object)tenantInfo.getTenantCode());
            userDetails.addExtendUserMap("connName", (Object)tenantInfo.getConnName());
            userDetails.setTenantCode(tenantInfo.getTenantCode());
        }
        userDetails.addExtendUserMap("account", (Object)sysUsers.getUserAccount());
        userDetails.setUserName(sysUsers.getUserName());
        userDetails.addExtendUserMap("deptId", (Object)sysUsers.getDepartmentId());
        userDetails.addExtendUserMap("employeeId", (Object)sysUsers.getEmployeeId());
        userDetails.addExtendUserMap("deptName", (Object)this.getDeptName(sysUsers.getDepartmentId()));
        userDetails.addExtendUserMap("securityLevel", (Object)sysUsers.getSecurityLevel());
        userDetails.addExtendUserMap("accountStatus", (Object)sysUsers.getAccountStatus());
        userDetails.setMaxSameCount(Integer.valueOf(sysUsers.getMaxSessions()));
        List<Long> rolesList = this.getRolesIdByUserId(sysUsers.getId());
        userDetails.addExtendUserMap("gradeAdmin", (Object)(ToolUtil.isNotEmpty(rolesList) && rolesList.contains(SysUserAndRole.GRADEADMIN_ROLE.getValue()) ? 1 : 0));
        Long employeeId = sysUsers.getEmployeeId();
        Long departmentId = sysUsers.getDepartmentId();
        if (ToolUtil.isNotEmpty((Object)employeeId) && ToolUtil.isNotEmpty((Object)departmentId)) {
            List<Long> roleList = this.getRolesIdByStruId(sysUsers.getDepartmentId());
            if (HussarUtils.isNotEmpty(rolesList)) {
                rolesList.addAll(roleList);
            }
        }
        userDetails.addExtendUserMap("rolesList", rolesList);
        ResourceGrantedAuthority resourceGrantedAuthority = this.getPermissionByRoleIds(rolesList, sysUsers.getId());
        userDetails.addExtendUserMap("theme", (Object)this.themeService.queryUserThemeWithUserId(sysUsers.getId()));
        ArrayList<Long> roleList = new ArrayList<Long>(rolesList);
        roleList.add(userDetails.getUserId());
        userDetails.addExtendUserMap("welcomeUrl", (Object)this.sysWelcomeService.getUserIndex(roleList));
        userDetails.addExtendUserMap("permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
        return userDetails;
    }

    private String getDeptName(Long deptId) {
        SysOrganVo dept = this.iSysStruService.getOrgInfoByOrgId(deptId);
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    private List<Long> getRolesIdByUserId(Long userId) {
        return this.iSysUserRoleService.getRolesByUserId(userId);
    }

    private List<Long> getRolesIdByStruId(Long struId) {
        return this.iSysStruRoleService.getRolesByStruId(struId);
    }

    private ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList, Long userId) {
        ArrayList<String> resourcePermissions;
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        if (roleList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            List resourcesList = this.sysResourcesService.list();
            resourcePermissions = new ArrayList<String>();
            for (SysResources resources : resourcesList) {
                resourcePermissions.add(resources.getPermissions());
            }
        } else {
            resourcePermissions = this.sysResourcesService.queryPermissionsByRoleIds(roleList);
        }
        if (HussarUtils.isNotEmpty((Object)resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList(resourcePermissions);
        }
        return resourceGrantedAuthority;
    }

    private RoleGrantedAuthority getRolePermissions(List<Long> roleList, Long userId) {
        RoleGrantedAuthority roleGrantedAuthority = new RoleGrantedAuthority();
        List roles = new ArrayList();
        if (ToolUtil.isNotEmpty(roleList)) {
            roles = this.sysRolesService.listByIds(roleList);
        }
        ArrayList rolePermissions = new ArrayList();
        roles.forEach(sysRole -> {
            if (HussarUtils.isNotEmpty((Object)sysRole.getRolePermission())) {
                rolePermissions.add(sysRole.getRolePermission());
            }
        });
        if (HussarUtils.isNotEmpty(rolePermissions)) {
            roleGrantedAuthority.setGrantAuthorityList(rolePermissions);
        }
        return roleGrantedAuthority;
    }
}

