/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.service.AuthcService;
import com.jxdinfo.hussar.authentication.vo.LoginInfoVo;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.service.SysDataSourceService;
import com.jxdinfo.hussar.encrypt.util.SM2Util;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityAuthenticationService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.dto.SecurityAuthenticationDto;
import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Constants;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AuthcServiceImpl
implements AuthcService {
    private static Logger logger = LoggerFactory.getLogger(AuthcServiceImpl.class);
    @Resource
    private SysDataSourceService sysDataSourceService;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private IHussarPwdConfigService pwdConfigService;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private HussarSecurityAuthenticationService hussarSecurityAuthenticationService;
    @Value(value="${hussar.core.encrypt.enable-pw-encryption: false}")
    boolean enablePwEncryption;

    @HussarDs(value="#connName")
    private ApiResponse<LoginInfoVo> changeTempDs(String connName, AuthcDto authcDto) {
        authcDto.setDsName(connName);
        return ApiResponse.success((Object)new LoginInfoVo());
    }

    public void logout() {
        SecurityUtil.logout();
    }

    public ApiResponse<Map<String, String>> check() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.pwdConfigService.isForceChangePwd()) {
            SysUsers sysUser = this.iSysUsersService.getUser(shiroUser.getId());
            if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
                map.put("firstLogin", "NO");
                map.put("changePwd", "NO");
                return ApiResponse.success(map);
            }
            if (this.iSysUsersService.isFirstLogin(shiroUser.getId())) {
                map.put("firstLogin", "YES");
            } else {
                map.put("firstLogin", "NO");
            }
            if (this.iSysUsersService.isPwdOverdue(shiroUser.getId())) {
                map.put("changePwd", "YES");
            } else {
                map.put("changePwd", "NO");
            }
        } else {
            map.put("firstLogin", "NO");
            map.put("changePwd", "NO");
        }
        return ApiResponse.success(map);
    }

    public ApiResponse<Map<String, Object>> getShow() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        List sysBaseConfigs = this.sysBaseConfigService.getTotpCaptchaConfigList();
        if (ToolUtil.isNotEmpty((Object)sysBaseConfigs)) {
            Map configMap = sysBaseConfigs.stream().collect(Collectors.toMap(SysBaseConfig::getConfigKey, Function.identity()));
            SysBaseConfig topTOpen = (SysBaseConfig)configMap.get("totp_open");
            SysBaseConfig kaptchaOpen = (SysBaseConfig)configMap.get("kaptcha_open");
            SysBaseConfig loginViewKaptcha = (SysBaseConfig)configMap.get("login_view_kaptcha");
            map.put("totp", topTOpen == null ? false : "0".equals(topTOpen.getConfigValue()));
            map.put("kaptcha", kaptchaOpen == null ? false : "0".equals(kaptchaOpen.getConfigValue()));
            map.put("indexKaptcha", loginViewKaptcha == null ? false : "0".equals(loginViewKaptcha.getConfigValue()));
        }
        return ApiResponse.success(map);
    }

    public ApiResponse<SecurityUser> queryLoginUserInfo(AuthcDto authcDto) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        securityUser.setDeptIcon(this.sysOrganTypeService.getDeptIcon(securityUser.getDeptId()));
        return ApiResponse.success((Object)securityUser);
    }

    public ApiResponse<UserDetails> handoffTenant(String connName, String tcode, HttpServletRequest request) {
        try {
            List users = this.sysUsersService.list(connName);
            if (users.isEmpty()) {
                return ApiResponse.fail((String)(tcode + "\u79df\u6237\u7528\u6237\u4e0d\u5b58\u5728\uff01"));
            }
            SysUsers user = (SysUsers)users.get(0);
            SecurityAuthenticationDto dto = new SecurityAuthenticationDto();
            dto.setUsername(user.getUserAccount());
            dto.setClientId("hussar-base");
            if (this.enablePwEncryption) {
                dto.setPassword(this.encrypt(user.getPassword()));
            } else {
                dto.setPassword(user.getPassword());
            }
            dto.setTenantCode(tcode);
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("loginType", "handoff");
            dto.setParamsMapExcludeParam(map);
            ApiResponse mapApiResponse = this.hussarSecurityAuthenticationService.securityPassword(dto);
            Map data = (Map)mapApiResponse.getData();
            if (HussarUtils.isEmpty((Object)data)) {
                return ApiResponse.fail((String)"\u79df\u6237\u767b\u5f55\u5f02\u5e38\uff01");
            }
            Object tokenObject = data.get(SecurityOAuth2Constants.Param.access_token);
            if (HussarUtils.isEmpty(tokenObject)) {
                return ApiResponse.fail((String)"\u79df\u6237\u767b\u5f55\u5f02\u5e38\uff01");
            }
            UserDetails loginUserDetails = HussarSecurityUtils.getLoginUserDetails((String)String.valueOf(tokenObject));
            request.setAttribute("Authorization", (Object)String.valueOf(tokenObject));
            return ApiResponse.success((Object)loginUserDetails);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private String encrypt(String encryptPwd) {
        String pwd;
        try {
            String sm2PriKey = (String)HussarFixedCacheUtil.get((String)"pw_encrypt_cache", (Object)"pw_encrypt_sm2_pub", String.class);
            pwd = SM2Util.encrypt((String)encryptPwd, (String)sm2PriKey);
        }
        catch (Exception var4) {
            throw new HussarException("\u767b\u5f55\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)pwd), (String)"\u767b\u5f55\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        return pwd;
    }
}

