/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authentication.dto.LoginUserExtendInfoDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginUserExtendInfoService;
import com.jxdinfo.hussar.authorization.organ.dto.SysStruOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HussarLoginUserExtendInfoServiceImpl
implements HussarLoginUserExtendInfoService {
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysPostService sysPostService;
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;

    public LoginUserExtendInfoDto getUserInfo(String userMdmId) {
        LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
        SysUsers sysUsers = null;
        if (HussarUtils.isNotEmpty((Object)userMdmId)) {
            sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getOutUserId, (Object)userMdmId));
        }
        if (HussarUtils.isNotEmpty(sysUsers)) {
            loginUserExtendInfo.setId(HussarUtils.isNotEmpty((Object)sysUsers.getId()) ? String.valueOf(sysUsers.getId()) : "");
            loginUserExtendInfo.setAccount(sysUsers.getUserAccount());
            loginUserExtendInfo.setAccountNew(sysUsers.getUserAccountNew());
            loginUserExtendInfo.setName(sysUsers.getUserName());
            loginUserExtendInfo.setMdmId(sysUsers.getOutUserId());
            loginUserExtendInfo.setOriginId(sysUsers.getOutOriginId());
        }
        return loginUserExtendInfo;
    }

    public LoginUserExtendInfoDto getOrganizationInfo(SysStru sysStru) {
        LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
        LambdaQueryWrapper sysOrganLambdaQueryWrapper = new LambdaQueryWrapper();
        SysOrgan sysOrgan = null;
        if (HussarUtils.isNotEmpty((Object)sysStru) && HussarUtils.isNotEmpty((Object)sysStru.getOrganId())) {
            sysOrganLambdaQueryWrapper.eq(SysOrgan::getId, (Object)sysStru.getOrganId());
            sysOrgan = (SysOrgan)this.sysOrganService.getOne((Wrapper)sysOrganLambdaQueryWrapper);
        }
        if (HussarUtils.isNotEmpty(sysOrgan)) {
            loginUserExtendInfo.setName(sysOrgan.getOrganName());
            loginUserExtendInfo.setCode(sysOrgan.getOrganCode());
        }
        if (HussarUtils.isNotEmpty((Object)sysStru)) {
            loginUserExtendInfo.setId(HussarUtils.isNotEmpty((Object)sysStru.getId()) ? String.valueOf(sysStru.getId()) : "");
            loginUserExtendInfo.setType(sysStru.getStruType());
            loginUserExtendInfo.setMdmId(sysStru.getOutStruId());
            loginUserExtendInfo.setOriginId(sysStru.getOutOriginId());
        }
        return loginUserExtendInfo;
    }

    public LoginUserExtendInfoDto getOrganizationInfoByNew(SysStruOrgan sysStru) {
        LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
        if (HussarUtils.isNotEmpty((Object)sysStru.getOrganName())) {
            loginUserExtendInfo.setName(sysStru.getOrganName());
            loginUserExtendInfo.setCode(sysStru.getOrganCode());
        }
        if (HussarUtils.isNotEmpty((Object)sysStru)) {
            loginUserExtendInfo.setId(HussarUtils.isNotEmpty((Object)sysStru.getId()) ? String.valueOf(sysStru.getId()) : "");
            loginUserExtendInfo.setType(sysStru.getStruType());
            loginUserExtendInfo.setMdmId(sysStru.getOutStruId());
            loginUserExtendInfo.setOriginId(sysStru.getOutOriginId());
        }
        return loginUserExtendInfo;
    }

    public LoginUserExtendInfoDto getOrganizationInfoNew(String organizationMdmId) {
        LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
        LambdaQueryWrapper sysStruLambdaQueryWrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper sysOrganLambdaQueryWrapper = new LambdaQueryWrapper();
        SysStru sysStru = null;
        SysOrgan sysOrgan = null;
        if (HussarUtils.isNotEmpty((Object)organizationMdmId) && !"null".equals(organizationMdmId)) {
            sysStruLambdaQueryWrapper.eq(SysStru::getOutStruId, (Object)organizationMdmId);
            SysStru temp = (SysStru)this.sysStruService.getOne((Wrapper)sysStruLambdaQueryWrapper);
            sysStru = (SysStru)this.sysStruService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)temp.getCompanyId()));
        }
        if (HussarUtils.isNotEmpty(sysStru) && HussarUtils.isNotEmpty((Object)sysStru.getOrganId())) {
            sysOrganLambdaQueryWrapper.eq(SysOrgan::getId, (Object)sysStru.getOrganId());
            sysOrgan = (SysOrgan)this.sysOrganService.getOne((Wrapper)sysOrganLambdaQueryWrapper);
        }
        if (HussarUtils.isNotEmpty(sysOrgan)) {
            loginUserExtendInfo.setName(sysOrgan.getOrganName());
            loginUserExtendInfo.setCode(sysOrgan.getOrganCode());
        }
        if (HussarUtils.isNotEmpty(sysStru)) {
            loginUserExtendInfo.setId(HussarUtils.isNotEmpty((Object)sysStru.getId()) ? String.valueOf(sysStru.getId()) : "");
            loginUserExtendInfo.setType(sysStru.getStruType());
            loginUserExtendInfo.setMdmId(sysStru.getOutStruId());
            loginUserExtendInfo.setOriginId(sysStru.getOutOriginId());
        }
        return loginUserExtendInfo;
    }

    public LoginUserExtendInfoDto getDeptInfo(String deptMdmId) {
        SysStru stru = (SysStru)this.sysStruService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOutStruId, (Object)deptMdmId));
        return this.getOrganizationInfo(stru);
    }

    public LoginUserExtendInfoDto getDeptInfo(SysStru dept) {
        return this.getOrganizationInfo(dept);
    }

    public LoginUserExtendInfoDto getDirectCompanyInfo(SysStru directCompanyMdm) {
        return this.getOrganizationInfo(directCompanyMdm);
    }

    public LoginUserExtendInfoDto getDirectCompanyInfoNew(SysStruOrgan directCompanyMdm) {
        return this.getOrganizationInfoByNew(directCompanyMdm);
    }

    public LoginUserExtendInfoDto getUnitInfo(String unitMdmId) {
        SysStru stru = (SysStru)this.sysStruService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOutStruId, (Object)unitMdmId));
        return this.getOrganizationInfo(stru);
    }

    public LoginUserExtendInfoDto getPostInfo(String postMdmId) {
        LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
        SysPost sysPost = null;
        if (HussarUtils.isNotEmpty((Object)postMdmId)) {
            sysPost = (SysPost)this.sysPostService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysPost::getOutPostId, (Object)postMdmId));
        }
        if (HussarUtils.isNotEmpty(sysPost)) {
            loginUserExtendInfo.setId(HussarUtils.isNotEmpty((Object)sysPost.getPostId()) ? String.valueOf(sysPost.getPostId()) : "");
            loginUserExtendInfo.setCode(sysPost.getPostNo());
            loginUserExtendInfo.setType(sysPost.getPostType());
            loginUserExtendInfo.setName(sysPost.getPostName());
            loginUserExtendInfo.setMdmId(sysPost.getOutPostId());
            loginUserExtendInfo.setOriginId(sysPost.getOutOriginId());
        }
        return loginUserExtendInfo;
    }

    public List<LoginUserExtendInfoDto> listUnitInfos(SysStru dept) {
        ArrayList<LoginUserExtendInfoDto> loginUserExtendInfos = new ArrayList<LoginUserExtendInfoDto>();
        String fid = null;
        ArrayList<String> resolvedFid = new ArrayList<String>();
        ArrayList<String> organTypes = new ArrayList<String>();
        List units = new ArrayList();
        organTypes.addAll(this.listOrganType("0"));
        if (HussarUtils.isNotEmpty((Object)dept)) {
            fid = dept.getStruFid();
        }
        if (HussarUtils.isNotEmpty(fid)) {
            resolvedFid.addAll(this.resolveFid(fid));
        }
        if (!resolvedFid.isEmpty()) {
            units = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, resolvedFid));
        }
        if (HussarUtils.isNotEmpty(units)) {
            units.forEach(unit -> {
                if (unit.getParentId() != 11L && organTypes.contains(unit.getStruType())) {
                    loginUserExtendInfos.add(this.getDirectCompanyInfo((SysStru)unit));
                }
            });
        }
        return loginUserExtendInfos;
    }

    public List<LoginUserExtendInfoDto> listUnitInfosNew(SysStru dept) {
        ArrayList<LoginUserExtendInfoDto> loginUserExtendInfos = new ArrayList<LoginUserExtendInfoDto>();
        String fid = null;
        ArrayList<String> resolvedFid = new ArrayList<String>();
        List units = new ArrayList();
        ArrayList<String> organTypes = new ArrayList<String>(this.listOrganType("0"));
        if (HussarUtils.isNotEmpty((Object)dept)) {
            fid = dept.getStruFid();
        }
        if (HussarUtils.isNotEmpty(fid)) {
            resolvedFid.addAll(this.resolveFid(fid));
        }
        if (!resolvedFid.isEmpty()) {
            units = this.sysStruService.selectUnits(resolvedFid);
        }
        if (HussarUtils.isNotEmpty(units)) {
            units.forEach(unit -> {
                if (unit.getParentId() != 11L && organTypes.contains(unit.getStruType())) {
                    loginUserExtendInfos.add(this.getDirectCompanyInfoNew((SysStruOrgan)unit));
                }
            });
        }
        return loginUserExtendInfos;
    }

    private List<String> resolveFid(String fid) {
        ArrayList<String> resolvedFid = new ArrayList<String>();
        String[] temp = null;
        if (HussarUtils.isNotEmpty((Object)fid)) {
            temp = fid.split("/");
        }
        if (HussarUtils.isNotEmpty(temp)) {
            for (int i = 0; i < temp.length; ++i) {
                if (!HussarUtils.isNotEmpty((Object)temp[i])) continue;
                resolvedFid.add(temp[i]);
            }
        }
        return resolvedFid;
    }

    private List<String> listOrganType(String companyType) {
        ArrayList<String> organTypes = new ArrayList<String>();
        organTypes.add("0201");
        organTypes.add("0202");
        organTypes.add("0203");
        organTypes.add("0207");
        return organTypes;
    }
}

