/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authentication.dao.SysAuthClientPermissionMapper;
import com.jxdinfo.hussar.authentication.dto.SysAuthClientPermissionDto;
import com.jxdinfo.hussar.authentication.model.SysAuthClientScope;
import com.jxdinfo.hussar.authentication.model.SysAuthScopePermission;
import com.jxdinfo.hussar.authentication.service.SysAuthClientModelService;
import com.jxdinfo.hussar.authentication.service.SysAuthClientPermissionService;
import com.jxdinfo.hussar.authentication.service.SysAuthClientScopeService;
import com.jxdinfo.hussar.authentication.service.SysAuthScopePermissionService;
import com.jxdinfo.hussar.authentication.vo.SysAuthClientOpenResTreeVo;
import com.jxdinfo.hussar.authentication.vo.SysAuthClientPermissionVo;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.ResourceTreeVo;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientPermission;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysAuthClientPermissionServiceImpl
extends HussarServiceImpl<SysAuthClientPermissionMapper, SysAuthClientPermission>
implements SysAuthClientPermissionService {
    @Autowired
    private ISysResourcesService sysResourcesService;
    @Autowired
    private SysAuthClientScopeService sysAuthClientScopeService;
    @Autowired
    private SysAuthScopePermissionService sysAuthScopePermissionService;
    @Autowired
    private SysAuthClientModelService sysAuthClientModelService;

    public ApiResponse<List<SysAuthClientOpenResTreeVo>> openResTree() {
        Long appId = 1L;
        List resourceTreeVoList = this.sysResourcesService.openResTree();
        ArrayList<SysAuthClientOpenResTreeVo> result = new ArrayList<SysAuthClientOpenResTreeVo>();
        for (ResourceTreeVo resourceTreeVo : resourceTreeVoList) {
            result.add(this.resourceTreeVoToOpenResVo(resourceTreeVo));
        }
        SysAuthClientOpenResTreeVo root = new SysAuthClientOpenResTreeVo();
        root.setId("1");
        root.setLabel("\u8d44\u6e90\u6a21\u5757\u5217\u8868");
        root.setParentId("0");
        root.setIcon("tree-com");
        result.add(root);
        return ApiResponse.success(this.filterNoChildNode(HussarTreeParser.getTreeList(result)));
    }

    private SysAuthClientOpenResTreeVo resourceTreeVoToOpenResVo(ResourceTreeVo resourceTreeVo) {
        SysAuthClientOpenResTreeVo openResTreeVo = new SysAuthClientOpenResTreeVo();
        openResTreeVo.setId(resourceTreeVo.getId());
        openResTreeVo.setLabel(resourceTreeVo.getLabel());
        openResTreeVo.setParentId(resourceTreeVo.getParentId());
        openResTreeVo.setIcon(resourceTreeVo.getIcon());
        openResTreeVo.setIsRes(resourceTreeVo.getIsRes());
        openResTreeVo.setIsModule(resourceTreeVo.getIsModule());
        return openResTreeVo;
    }

    private List<SysAuthClientOpenResTreeVo> filterNoChildNode(List<SysAuthClientOpenResTreeVo> items) {
        ArrayList<SysAuthClientOpenResTreeVo> newItems = new ArrayList<SysAuthClientOpenResTreeVo>();
        for (SysAuthClientOpenResTreeVo model : items) {
            List children = model.getChildren();
            if ("1".equals(model.getIsRes())) {
                newItems.add(model);
                continue;
            }
            if (ToolUtil.isNotEmpty((Object)children)) {
                List<SysAuthClientOpenResTreeVo> newChildren = this.filterNoChildNode(children);
                if (ToolUtil.isNotEmpty(newChildren)) {
                    model.setChildren(newChildren);
                    newItems.add(model);
                } else if (model.getId().equals("1")) {
                    model.setChildren(newChildren);
                }
            }
            if (!model.getId().equals("1") || newItems.contains(model)) continue;
            newItems.add(model);
        }
        return newItems;
    }

    public ApiResponse<Boolean> saveClientPermissionBatch(List<SysAuthClientPermissionDto> list) {
        if (ToolUtil.isEmpty(list)) {
            return ApiResponse.success((Object)true);
        }
        ArrayList<SysAuthClientPermission> addList = new ArrayList<SysAuthClientPermission>();
        ArrayList<String> clientIdList = new ArrayList();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long tenantId = ToolUtil.isNotEmpty((Object)securityUser) && ToolUtil.isNotEmpty((Object)securityUser.getTenantId()) ? securityUser.getTenantId() : Long.parseLong("0");
        for (SysAuthClientPermissionDto clientPermissionDto : list) {
            String clientId = clientPermissionDto.getClientId();
            Long resourceId = clientPermissionDto.getResourceId();
            if (ToolUtil.isEmpty((Object)clientId)) continue;
            if (ToolUtil.isNotEmpty((Object)resourceId)) {
                SysAuthClientPermission clientPermission = new SysAuthClientPermission();
                clientPermission.setClientId(clientId);
                clientPermission.setPermissionId(resourceId);
                clientPermission.setScope("permission_list");
                clientPermission.setTenantId(tenantId);
                addList.add(clientPermission);
            }
            clientIdList.add(clientId);
        }
        if (ToolUtil.isNotEmpty(clientIdList)) {
            clientIdList = clientIdList.stream().distinct().collect(Collectors.toList());
            this.remove((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysAuthClientPermission::getClientId, clientIdList));
        }
        if (ToolUtil.isNotEmpty(addList)) {
            this.saveBatch(addList);
        }
        this.dealWithClientScopeAndScopePermission(list);
        this.updateClientPermission(addList, clientIdList);
        return ApiResponse.success((Object)true);
    }

    private void dealWithClientScopeAndScopePermission(List<SysAuthClientPermissionDto> authClientPermissions) {
        this.dealWithClientScope(authClientPermissions);
        this.dealWithScopePermission(authClientPermissions);
    }

    private void dealWithClientScope(List<SysAuthClientPermissionDto> authClientPermissions) {
        List<SysAuthClientModel> sysAuthClientModels = this.listSysAuthClientModelsBy(authClientPermissions);
        this.addClientScope(sysAuthClientModels);
    }

    private void addClientScope(List<SysAuthClientModel> sysAuthClientModels) {
        ArrayList<SysAuthClientScope> addList = new ArrayList<SysAuthClientScope>();
        this.dealWithClientScopeList(sysAuthClientModels, addList);
        this.sysAuthClientScopeService.saveBatch(addList);
    }

    private void dealWithClientScopeList(List<SysAuthClientModel> sysAuthClientModels, List<SysAuthClientScope> addList) {
        if (HussarUtils.isNotEmpty(sysAuthClientModels)) {
            for (SysAuthClientModel sysAuthClientModel : sysAuthClientModels) {
                String scope = sysAuthClientModel.getContractScope();
                List<String> scopes = this.dealWithStrByComma(scope);
                for (String sc : scopes) {
                    SysAuthClientScope sysAuthClientScope = new SysAuthClientScope();
                    sysAuthClientScope.setScope(sc);
                    if (this.hasScope(sc)) continue;
                    addList.add(sysAuthClientScope);
                }
            }
        }
    }

    private List<String> dealWithStrByComma(String str) {
        if (HussarUtils.isNotEmpty((Object)str)) {
            return Arrays.asList(str.split(","));
        }
        return new ArrayList<String>();
    }

    private boolean hasScope(String sc) {
        if (HussarUtils.isNotEmpty((Object)sc)) {
            List sysAuthClientScopes = this.sysAuthClientScopeService.list((Wrapper)new LambdaQueryWrapper().eq(SysAuthClientScope::getScope, (Object)sc));
            return HussarUtils.isNotEmpty((Object)sysAuthClientScopes);
        }
        return false;
    }

    private void dealWithScopePermission(List<SysAuthClientPermissionDto> authClientPermissions) {
        List<SysAuthClientModel> sysAuthClientModels = this.listSysAuthClientModelsBy(authClientPermissions);
        ArrayList<SysAuthScopePermission> addList = new ArrayList<SysAuthScopePermission>();
        ArrayList<SysAuthScopePermission> deleteList = new ArrayList<SysAuthScopePermission>();
        this.dealWithScopePermissionList(authClientPermissions, sysAuthClientModels, addList, deleteList);
        this.deleteScopePermissionBy(deleteList);
        this.addScopePermissionBy(addList);
    }

    private void dealWithScopePermissionList(List<SysAuthClientPermissionDto> authClientPermissions, List<SysAuthClientModel> sysAuthClientModels, List<SysAuthScopePermission> addList, List<SysAuthScopePermission> deleteList) {
        if (HussarUtils.isNotEmpty(authClientPermissions)) {
            Map<String, List<SysAuthClientPermissionDto>> clientPermissionDtosMap = this.groupClientPermissionDtoByClientId(authClientPermissions);
            for (SysAuthClientModel sysAuthClientModel : sysAuthClientModels) {
                String clientId = sysAuthClientModel.getClientId();
                String scope = sysAuthClientModel.getContractScope();
                List<String> scopes = this.dealWithStrByComma(scope);
                for (String sc : scopes) {
                    List<SysAuthClientPermissionDto> clientPermissionDtos = clientPermissionDtosMap.get(clientId);
                    if (!HussarUtils.isNotEmpty(clientPermissionDtos)) continue;
                    clientPermissionDtos.forEach(clientPermissionDto -> {
                        Long addResourceId = clientPermissionDto.getResourceId();
                        Long deleteResourceId = clientPermissionDto.getDeletedResourceId();
                        if (addResourceId != null) {
                            SysAuthScopePermission sysAuthScopePermission = new SysAuthScopePermission();
                            sysAuthScopePermission.setScopeId(this.getScopeId(sc));
                            sysAuthScopePermission.setPermissionId(addResourceId);
                            addList.add(sysAuthScopePermission);
                            deleteList.add(sysAuthScopePermission);
                        } else if (deleteResourceId != null) {
                            SysAuthScopePermission sysAuthScopePermission = new SysAuthScopePermission();
                            sysAuthScopePermission.setScopeId(this.getScopeId(sc));
                            sysAuthScopePermission.setPermissionId(deleteResourceId);
                            deleteList.add(sysAuthScopePermission);
                        }
                    });
                }
            }
        }
    }

    private void deleteScopePermissionBy(List<SysAuthScopePermission> deleteList) {
        if (HussarUtils.isNotEmpty(deleteList)) {
            deleteList.forEach(deleteDto -> this.sysAuthScopePermissionService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAuthScopePermission::getScopeId, (Object)deleteDto.getScopeId())).eq(SysAuthScopePermission::getPermissionId, (Object)deleteDto.getPermissionId())));
        }
    }

    private void addScopePermissionBy(List<SysAuthScopePermission> addList) {
        if (HussarUtils.isNotEmpty(addList)) {
            this.sysAuthScopePermissionService.saveBatch(addList);
        }
    }

    private Map<String, List<SysAuthClientPermissionDto>> groupClientPermissionDtoByClientId(List<SysAuthClientPermissionDto> authClientPermissions) {
        if (HussarUtils.isNotEmpty(authClientPermissions)) {
            return authClientPermissions.stream().collect(Collectors.groupingBy(SysAuthClientPermissionDto::getClientId));
        }
        return new HashMap<String, List<SysAuthClientPermissionDto>>();
    }

    private Long getScopeId(String sc) {
        List sysAuthClientScopes;
        if (HussarUtils.isNotEmpty((Object)sc) && HussarUtils.isNotEmpty((Object)(sysAuthClientScopes = this.sysAuthClientScopeService.list((Wrapper)new LambdaQueryWrapper().eq(SysAuthClientScope::getScope, (Object)sc))))) {
            return ((SysAuthClientScope)sysAuthClientScopes.get(0)).getId();
        }
        return null;
    }

    private List<SysAuthClientModel> listSysAuthClientModelsBy(List<SysAuthClientPermissionDto> authClientPermissions) {
        ArrayList clientIds = new ArrayList();
        if (HussarUtils.isNotEmpty(authClientPermissions)) {
            authClientPermissions.forEach(authClientPermission -> clientIds.add(authClientPermission.getClientId()));
        }
        return this.sysAuthClientModelService.list((Wrapper)new LambdaQueryWrapper().in(SysAuthClientModel::getClientId, clientIds));
    }

    private void updateClientPermission(List<SysAuthClientPermission> clientPermissionList, List<String> clientIdList) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String tenantCode = ToolUtil.isNotEmpty((Object)securityUser) && ToolUtil.isNotEmpty((Object)securityUser.getTenantCode()) ? securityUser.getTenantCode() : "";
        HashMap permissionMap = new HashMap();
        Map<Long, String> resourceIdUrlMap = this.getResourceIdUrlMap(clientPermissionList);
        for (String clientId : clientIdList) {
            permissionMap.put(clientId, new ArrayList());
        }
        for (SysAuthClientPermission clientPermission : clientPermissionList) {
            List permissionList = (List)permissionMap.get(clientPermission.getClientId());
            String permission = resourceIdUrlMap.get(clientPermission.getPermissionId());
            if (!ToolUtil.isNotEmpty((Object)permission)) continue;
            permissionList.add(permission);
        }
        for (String clientId : permissionMap.keySet()) {
            HussarSecurityUtils.updateClientPermissions((String)clientId, (String)tenantCode, (List)((List)permissionMap.get(clientId)));
        }
    }

    private Map<Long, String> getResourceIdUrlMap(List<SysAuthClientPermission> clientPermissionList) {
        List permissionIdList = clientPermissionList.stream().map(SysAuthClientPermission::getPermissionId).distinct().collect(Collectors.toList());
        HashMap<Long, String> resourceIdUrlMap = new HashMap<Long, String>();
        if (ToolUtil.isNotEmpty(permissionIdList)) {
            List resourcesList = this.sysResourcesService.listByIds(permissionIdList);
            for (SysResources resource : resourcesList) {
                if (!ToolUtil.isNotEmpty((Object)resource.getUrlNames())) continue;
                resourceIdUrlMap.put(resource.getId(), resource.getUrlNames());
            }
        }
        return resourceIdUrlMap;
    }

    public ApiResponse<List<SysAuthClientPermissionVo>> listClientPermissions(String clientId) {
        if (ToolUtil.isEmpty((Object)clientId)) {
            return ApiResponse.success(new ArrayList());
        }
        ArrayList<SysAuthClientPermissionVo> clientPermissionVoList = new ArrayList<SysAuthClientPermissionVo>();
        List clientPermissionList = this.list((Wrapper)new LambdaQueryWrapper().eq(SysAuthClientPermission::getClientId, (Object)clientId));
        ArrayList resourceIdList = new ArrayList();
        clientPermissionList.forEach(cp -> resourceIdList.add(cp.getPermissionId()));
        if (ToolUtil.isNotEmpty(resourceIdList)) {
            List resourcesList = this.sysResourcesService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysResources::getId, resourceIdList));
            for (SysResources sysResources : resourcesList) {
                clientPermissionVoList.add(this.resourceToPermissionVo(sysResources));
            }
        }
        return ApiResponse.success(clientPermissionVoList);
    }

    private SysAuthClientPermissionVo resourceToPermissionVo(SysResources sysResources) {
        SysAuthClientPermissionVo clientPermissionVo = new SysAuthClientPermissionVo();
        clientPermissionVo.setResourceId(sysResources.getId());
        clientPermissionVo.setResourceName(sysResources.getResourceName());
        clientPermissionVo.setUrl(sysResources.getUrlNames());
        return clientPermissionVo;
    }
}

