/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authentication.dto.LoginUserExtendInfoDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginUserExtendInfoService;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HussarLoginUserExtendInfoServiceImpl
implements HussarLoginUserExtendInfoService {
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysPostService sysPostService;
    @Autowired
    private ISysOrganTypeService sysOrganTypeService;

    public LoginUserExtendInfoDto getUserInfo(String userMdmId) {
        LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
        SysUsers sysUsers = null;
        if (HussarUtils.isNotEmpty((Object)userMdmId)) {
            sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getOutUserId, (Object)userMdmId));
        }
        if (HussarUtils.isNotEmpty(sysUsers)) {
            loginUserExtendInfo.setId(HussarUtils.isNotEmpty((Object)sysUsers.getId()) ? String.valueOf(sysUsers.getId()) : "");
            loginUserExtendInfo.setAccount(sysUsers.getUserAccount());
            loginUserExtendInfo.setAccountNew(sysUsers.getUserAccountNew());
            loginUserExtendInfo.setName(sysUsers.getUserName());
            loginUserExtendInfo.setMdmId(sysUsers.getOutUserId());
            loginUserExtendInfo.setOriginId(sysUsers.getOutOriginId());
        }
        return loginUserExtendInfo;
    }

    public LoginUserExtendInfoDto getOrganizationInfo(String organizationMdmId) {
        LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
        LambdaQueryWrapper sysStruLambdaQueryWrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper sysOrganLambdaQueryWrapper = new LambdaQueryWrapper();
        SysStru sysStru = null;
        SysOrgan sysOrgan = null;
        if (HussarUtils.isNotEmpty((Object)organizationMdmId)) {
            sysStruLambdaQueryWrapper.eq(SysStru::getOutStruId, (Object)organizationMdmId);
            sysStru = (SysStru)this.sysStruService.getOne((Wrapper)sysStruLambdaQueryWrapper);
        }
        if (HussarUtils.isNotEmpty(sysStru) && HussarUtils.isNotEmpty((Object)sysStru.getOrganId())) {
            sysOrganLambdaQueryWrapper.eq(SysOrgan::getId, (Object)sysStru.getOrganId());
            sysOrgan = (SysOrgan)this.sysOrganService.getOne((Wrapper)sysOrganLambdaQueryWrapper);
        }
        if (HussarUtils.isNotEmpty(sysOrgan)) {
            loginUserExtendInfo.setName(sysOrgan.getOrganName());
            loginUserExtendInfo.setCode(sysOrgan.getOrganCode());
        }
        if (HussarUtils.isNotEmpty(sysStru)) {
            loginUserExtendInfo.setId(HussarUtils.isNotEmpty((Object)sysStru.getId()) ? String.valueOf(sysStru.getId()) : "");
            loginUserExtendInfo.setType(sysStru.getStruType());
            loginUserExtendInfo.setMdmId(sysStru.getOutStruId());
            loginUserExtendInfo.setOriginId(sysStru.getOutOriginId());
        }
        return loginUserExtendInfo;
    }

    public LoginUserExtendInfoDto getOrganizationInfoNew(String organizationMdmId) {
        LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
        LambdaQueryWrapper sysStruLambdaQueryWrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper sysOrganLambdaQueryWrapper = new LambdaQueryWrapper();
        SysStru sysStru = null;
        SysOrgan sysOrgan = null;
        if (HussarUtils.isNotEmpty((Object)organizationMdmId) && !"null".equals(organizationMdmId)) {
            sysStruLambdaQueryWrapper.eq(SysStru::getOutStruId, (Object)organizationMdmId);
            SysStru temp = (SysStru)this.sysStruService.getOne((Wrapper)sysStruLambdaQueryWrapper);
            sysStru = (SysStru)this.sysStruService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)temp.getCompanyId()));
        }
        if (HussarUtils.isNotEmpty(sysStru) && HussarUtils.isNotEmpty((Object)sysStru.getOrganId())) {
            sysOrganLambdaQueryWrapper.eq(SysOrgan::getId, (Object)sysStru.getOrganId());
            sysOrgan = (SysOrgan)this.sysOrganService.getOne((Wrapper)sysOrganLambdaQueryWrapper);
        }
        if (HussarUtils.isNotEmpty(sysOrgan)) {
            loginUserExtendInfo.setName(sysOrgan.getOrganName());
            loginUserExtendInfo.setCode(sysOrgan.getOrganCode());
        }
        if (HussarUtils.isNotEmpty(sysStru)) {
            loginUserExtendInfo.setId(HussarUtils.isNotEmpty((Object)sysStru.getId()) ? String.valueOf(sysStru.getId()) : "");
            loginUserExtendInfo.setType(sysStru.getStruType());
            loginUserExtendInfo.setMdmId(sysStru.getOutStruId());
            loginUserExtendInfo.setOriginId(sysStru.getOutOriginId());
        }
        return loginUserExtendInfo;
    }

    public LoginUserExtendInfoDto getDeptInfo(String deptMdmId) {
        return this.getOrganizationInfo(deptMdmId);
    }

    public LoginUserExtendInfoDto getDirectCompanyInfo(String directCompanyMdmId) {
        return this.getOrganizationInfo(directCompanyMdmId);
    }

    public LoginUserExtendInfoDto getUnitInfo(String unitMdmId) {
        return this.getOrganizationInfo(unitMdmId);
    }

    public LoginUserExtendInfoDto getPostInfo(String postMdmId) {
        LoginUserExtendInfoDto loginUserExtendInfo = new LoginUserExtendInfoDto();
        SysPost sysPost = null;
        if (HussarUtils.isNotEmpty((Object)postMdmId)) {
            sysPost = (SysPost)this.sysPostService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysPost::getOutPostId, (Object)postMdmId));
        }
        if (HussarUtils.isNotEmpty(sysPost)) {
            loginUserExtendInfo.setId(HussarUtils.isNotEmpty((Object)sysPost.getPostId()) ? String.valueOf(sysPost.getPostId()) : "");
            loginUserExtendInfo.setCode(sysPost.getPostNo());
            loginUserExtendInfo.setType(sysPost.getPostType());
            loginUserExtendInfo.setName(sysPost.getPostName());
            loginUserExtendInfo.setMdmId(sysPost.getOutPostId());
            loginUserExtendInfo.setOriginId(sysPost.getOutOriginId());
        }
        return loginUserExtendInfo;
    }

    public List<LoginUserExtendInfoDto> listUnitInfos(String deptMdmId) {
        ArrayList<LoginUserExtendInfoDto> loginUserExtendInfos = new ArrayList<LoginUserExtendInfoDto>();
        SysStru dept = null;
        String fid = null;
        ArrayList<String> resolvedFid = new ArrayList<String>();
        ArrayList<String> organTypes = new ArrayList<String>();
        ArrayList units = new ArrayList();
        organTypes.addAll(this.listOrganType("0"));
        if (HussarUtils.isNotEmpty((Object)deptMdmId)) {
            dept = (SysStru)this.sysStruService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOutStruId, (Object)deptMdmId));
        }
        if (HussarUtils.isNotEmpty(dept)) {
            fid = dept.getStruFid();
        }
        if (HussarUtils.isNotEmpty(fid)) {
            resolvedFid.addAll(this.resolveFid(fid));
        }
        if (!resolvedFid.isEmpty()) {
            resolvedFid.forEach(id -> units.add(this.sysStruService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, id))));
        }
        if (HussarUtils.isNotEmpty(units)) {
            units.forEach(unit -> {
                if (unit.getParentId() != 11L && organTypes.contains(unit.getStruType())) {
                    loginUserExtendInfos.add(this.getUnitInfo(unit.getOutStruId()));
                }
            });
        }
        return loginUserExtendInfos;
    }

    private List<String> resolveFid(String fid) {
        ArrayList<String> resolvedFid = new ArrayList<String>();
        String[] temp = null;
        if (HussarUtils.isNotEmpty((Object)fid)) {
            temp = fid.split("/");
        }
        if (HussarUtils.isNotEmpty(temp)) {
            for (int i = 0; i < temp.length; ++i) {
                if (!HussarUtils.isNotEmpty((Object)temp[i])) continue;
                resolvedFid.add(temp[i]);
            }
        }
        return resolvedFid;
    }

    private List<String> listOrganType(String companyType) {
        ArrayList<String> organTypes = new ArrayList<String>();
        Iterable sysOrganTypes = null;
        if (HussarUtils.isNotEmpty((Object)companyType)) {
            sysOrganTypes = this.sysOrganTypeService.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganType::getCompanyType, (Object)companyType));
        }
        if (HussarUtils.isNotEmpty(sysOrganTypes)) {
            sysOrganTypes.forEach(sysOrganType -> organTypes.add(sysOrganType.getOrganType()));
        }
        return organTypes;
    }
}

