/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.enums.ByskAuthenticationExceptionEnum;
import com.jxdinfo.hussar.authentication.properties.IasSsoLoginProperties;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authentication.util.ByskAuthenticationException;
import com.jxdinfo.hussar.authentication.util.HttpClientUtil;
import com.jxdinfo.hussar.authentication.util.ThreadLocalUtil;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ByskLoginValidateServiceImpl
implements HussarLoginValidateService {
    private static Logger logger = LogManager.getLogger(ByskLoginValidateServiceImpl.class);
    @Resource
    private IasSsoLoginProperties iasSsoLoginProperties;
    @Autowired
    private ISysPostService sysPostService;
    @Autowired
    private ISysStruService sysStruService;

    public String getLoginType() {
        return "81web";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        logger.info("loginCode:{}", (Object)loginCode);
        return this.getAccountByAccessToken(loginCode, authcDto);
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    public String getAccountByAccessToken(String loginCode, AuthcDto authcDto) {
        Map userMap = null;
        String userCode = null;
        String postName = null;
        try {
            logger.info("\u8fdb\u5165\u7efc\u7ba1\u8ba4\u8bc1\u65b9\u6cd5getAccountByAccessToken");
            logger.info("loginCode:{}", (Object)loginCode);
            logger.info("\u8bf7\u6c42\u7efc\u7ba1\u8ba4\u8bc1\u5730\u5740url:{}", (Object)this.iasSsoLoginProperties.getInfoUrl());
            String userInfo = HttpClientUtil.sendGet(this.iasSsoLoginProperties.getInfoUrl(), loginCode, "81web");
            logger.info("userInfo:{}", (Object)userInfo);
            if (String.valueOf(401).equals(userInfo)) {
                throw new ByskAuthenticationException(ByskAuthenticationExceptionEnum.TOKEN_TIME_OUT.getMessage());
            }
            logger.info("userInfo:{}", (Object)userInfo);
            JSONObject userObject = (JSONObject)JSONArray.parse((String)userInfo);
            logger.info("userObject:{}", (Object)userObject);
            userMap = (Map)userObject.getJSONObject("principal").getJSONObject("identityInfo").toJavaObject(Map.class);
            logger.info("userMap:{}", (Object)userMap);
            userCode = (String)userMap.get("userCode");
            logger.info("userCode:{}", (Object)userCode);
            postName = (String)userMap.get("postNewName");
            ThreadLocalUtil.setThreadLocalField(postName);
            String originDeptId = HussarUtils.isNotEmpty(userMap.get("projectId")) ? String.valueOf(userMap.get("projectId")) : null;
            String originPostId = HussarUtils.isNotEmpty(userMap.get("postNewId")) ? String.valueOf(userMap.get("postNewId")) : null;
            logger.info("projectId\uff1a", (Object)originDeptId);
            logger.info("postNewId\uff1a", (Object)originPostId);
            authcDto.setOriginDeptId(originDeptId);
            authcDto.setOriginPostId(originPostId);
        }
        catch (Exception e) {
            if (ByskAuthenticationExceptionEnum.TOKEN_TIME_OUT.getMessage().equals(e.getMessage())) {
                throw new ByskAuthenticationException(ByskAuthenticationExceptionEnum.TOKEN_TIME_OUT.getMessage());
            }
            throw new ExtendLoginException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        return userCode;
    }
}

