/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.factory.HussarLoginFactory;
import com.jxdinfo.hussar.authentication.service.CustomizeUserInfoService;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.authorization.post.service.UserPostMainService;
import com.jxdinfo.hussar.authorization.post.vo.SysUserPostMainVo;
import com.jxdinfo.hussar.base.cloud.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.base.cloud.dto.RoleGrantedAuthority;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.theme.service.IThemeService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.properties.HussarDynamicProperties;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@HussarTokenDs
@Service
public class HussarLoginBaseServiceImpl
implements HussarLoginService {
    private static Logger logger = LogManager.getLogger(HussarLoginBaseServiceImpl.class);
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysWelcomeService sysWelcomeService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    private static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};
    private static final String[] MANAGE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin"};
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Resource
    private HussarDynamicProperties hussarDynamicProperties;
    @Resource
    private UserPostMainService userPostMainService;
    @Resource
    private ISysPostService sysPostService;
    @Resource
    private List<CustomizeUserInfoService> customUserInfoServiceList;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Value(value="${unified-authentication.open:false}")
    Boolean open;

    public UserDetails login(AuthcDto authcDto) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ToolUtil.isNotEmpty((Object)requestAttributes) ? requestAttributes.getRequest() : null;
        String loginType = null;
        String loginCode = null;
        boolean tenantOpen = this.hussarTenantProperties.isEnabled() && this.tenantCommonService != null;
        DefaultTenant hussarTenantDefinition = new DefaultTenant();
        if (ToolUtil.isNotEmpty((Object)request)) {
            loginType = request.getHeader("loginType");
            loginCode = request.getHeader("loginCode");
            if (tenantOpen) {
                hussarTenantDefinition = this.tenantCommonService.parse();
                Optional.ofNullable(hussarTenantDefinition).ifPresent(e -> {
                    this.checkTeant((HussarTenantDefinition)e);
                    authcDto.setTenantCode(e.getTenantCode());
                    authcDto.setDsName(e.getConnName());
                    if (!this.hussarTenantProperties.getType().equals("url") && !this.hussarTenantProperties.getType().equals("domain")) {
                        authcDto.setDsName("master");
                    }
                });
            } else {
                authcDto.setTenantCode("master");
                authcDto.setDsName("master");
            }
        }
        if (this.open.booleanValue()) {
            if (HussarUtils.isEmpty((Object)loginType)) {
                loginType = authcDto.getLoginType();
            }
            if (HussarUtils.isEmpty((Object)loginCode)) {
                loginCode = authcDto.getLoginCode();
            }
        }
        logger.info("loginType:{}", (Object)loginType);
        if (ToolUtil.isEmpty((Object)loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").beforeSelectUser(request, loginCode, authcDto);
        } else {
            String username = HussarLoginFactory.getLoginValidateService(loginType).beforeSelectUser(request, loginCode, authcDto);
            if (ToolUtil.isNotEmpty((Object)username)) {
                authcDto.setUsername(username);
            }
        }
        String ssoToken = authcDto.getSsoToken();
        logger.info("\u7edf\u4e00\u8ba4\u8bc1\u7684token\u503c\u662f\uff1a " + ssoToken);
        String account = authcDto.getUsername();
        if (!this.hussarLoginConfigService.getLoginUpperOpen(authcDto.getDsName()).booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)authcDto.getUsername())) {
            account = authcDto.getUsername().toUpperCase();
        }
        String finalAccount = account;
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).and(qw -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(SysUsers::getUserAccount, (Object)finalAccount)).or()).eq(SysUsers::getUserAccountNew, (Object)finalAccount);
        })).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false);
        if (ToolUtil.isEmpty((Object)sysUsers)) {
            sysUsers = new SysUsers();
            sysUsers.setUserName(authcDto.getUsername());
            this.throwExceptionPersionally(authcDto, sysUsers, BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
        } else if (this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !authcDto.getUsername().equals(sysUsers.getUserAccount()) && !authcDto.getUsername().equals(sysUsers.getUserAccountNew())) {
            this.throwExceptionPersionally(authcDto, sysUsers, BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
        }
        SysUsersDto sysUsersDto = new SysUsersDto();
        CopyPropertieUtils.copyProperties((Object)sysUsersDto, (Object)sysUsers);
        if (ToolUtil.isEmpty((Object)loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").validateUser(authcDto, sysUsersDto);
        } else {
            HussarLoginFactory.getLoginValidateService(loginType).validateUser(authcDto, sysUsersDto);
        }
        UserDetails userDetails = this.getLoginSecurityUser(tenantOpen, (HussarTenantDefinition)hussarTenantDefinition, sysUsers, ssoToken);
        if (ToolUtil.isNotEmpty((Object)userDetails)) {
            sysUsers.setLastLoginTime(Java8DateUtils.currentLocalDateTime());
            sysUsers.setLastEditor(userDetails.getUserId());
            sysUsers.setLastTime(LocalDateTime.now());
            this.iSysUsersService.updateById(authcDto.getDsName(), (Object)sysUsers);
        }
        return userDetails;
    }

    private void checkTeant(HussarTenantDefinition tenantInfo) {
        if (StringUtils.isNotBlank((CharSequence)tenantInfo.getTenantCode()) && !tenantInfo.getConnName().equals("master")) {
            Boolean timeLimit = tenantInfo.getTimeLimit();
            LocalDateTime startTime = tenantInfo.getStartTime();
            LocalDateTime endTime = tenantInfo.getEndTime();
            String tenantStatus = tenantInfo.getTenantStatus();
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("0"), (String)"\u79df\u6237\u5df2\u5220\u9664");
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("2"), (String)"\u79df\u6237\u5df2\u5931\u6548");
            AssertUtil.isFalse((tenantStatus.equalsIgnoreCase("3") || tenantStatus.equalsIgnoreCase("4") ? 1 : 0) != 0, (String)"\u79df\u6237\u4e0d\u53ef\u7528");
            AssertUtil.isFalse((timeLimit != false && endTime.isBefore(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)"\u79df\u6237\u5df2\u5931\u6548");
            AssertUtil.isFalse((timeLimit != false && startTime.isAfter(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)"\u79df\u6237\u672a\u751f\u6548");
        }
    }

    private void throwExceptionPersionally(AuthcDto authcDto, SysUsers sysUsers, String message) {
        HussarTenantDefinition hussarTenantDefinition;
        BaseException e = new BaseException(message);
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName("\u767b\u5f55");
        auditLogModel.setExceptionInfo((Throwable)e);
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
        auditLogModel.setEventDesc(message);
        UserDetails userDetails = new UserDetails();
        if (sysUsers.getId() != null) {
            userDetails.setUserId(sysUsers.getId());
        }
        if (HussarUtils.isNotBlank((CharSequence)authcDto.getDsName()) && !authcDto.getDsName().equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
            userDetails.setTenantId(hussarTenantDefinition.getTenantId());
            userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
        }
        userDetails.setUserName(sysUsers.getUserName());
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        throw e;
    }

    public UserDetails getLoginSecurityUser(boolean tenantOpen, HussarTenantDefinition tenantInfo, SysUsers sysUsers, String ssoToken) {
        UserDetails userDetails = new UserDetails();
        userDetails.setUserId(sysUsers.getId());
        if (tenantOpen && HussarUtils.isNotEmpty((Object)tenantInfo)) {
            userDetails.addExtendUserMap(this.hussarDynamicProperties.getDatasourceKeyByHeader(), (Object)tenantInfo.getConnName());
            userDetails.setTenantId(tenantInfo.getTenantId());
            userDetails.setTenantCode(tenantInfo.getTenantCode());
            userDetails.addExtendUserMap("tenantName", (Object)tenantInfo.getTenantName());
            userDetails.addExtendUserMap("tcode", (Object)tenantInfo.getTenantCode());
            userDetails.addExtendUserMap("connName", (Object)tenantInfo.getConnName());
            userDetails.setTenantCode(tenantInfo.getTenantCode());
        }
        userDetails.addExtendUserMap("account", (Object)sysUsers.getUserAccount());
        userDetails.setUserName(sysUsers.getUserName());
        userDetails.addExtendUserMap("deptId", (Object)sysUsers.getDepartmentId());
        userDetails.addExtendUserMap("employeeId", (Object)sysUsers.getEmployeeId());
        userDetails.addExtendUserMap("deptName", (Object)this.getDeptName(sysUsers.getDepartmentId()));
        userDetails.addExtendUserMap("securityLevel", (Object)sysUsers.getSecurityLevel());
        userDetails.addExtendUserMap("accountStatus", (Object)sysUsers.getAccountStatus());
        userDetails.addExtendUserMap("organCode", (Object)"");
        if (sysUsers.getDepartmentId() != 11L) {
            SysOrgan sysOrgan = this.iSysStruService.getOrganInfoByDeparmentId(sysUsers.getDepartmentId());
            userDetails.addExtendUserMap("organCode", (Object)sysOrgan.getOrganCode());
        }
        List<Long> rolesList = this.getRolesBySecurityUser(sysUsers, userDetails);
        userDetails.addExtendUserMap("showTenant", (Object)this.showTenantInfo(sysUsers));
        userDetails.setMaxSameCount(Integer.valueOf(sysUsers.getMaxSessions()));
        userDetails.addExtendUserMap("gradeAdmin", (Object)(ToolUtil.isNotEmpty(rolesList) && rolesList.contains(SysUserAndRole.GRADEADMIN_ROLE.getValue()) ? 1 : 0));
        userDetails.addExtendUserMap("corporationId", (Object)sysUsers.getCorporationId());
        userDetails.addExtendUserMap("organType", (Object)this.iSysStruService.getOrganTypeList(sysUsers));
        userDetails.setMaxSameCount(Integer.valueOf(sysUsers.getMaxSessions()));
        Long employeeId = sysUsers.getEmployeeId();
        Long departmentId = sysUsers.getDepartmentId();
        if (ToolUtil.isNotEmpty((Object)employeeId) && ToolUtil.isNotEmpty((Object)departmentId)) {
            List<Long> roleList = this.getRolesIdByStruId(sysUsers.getDepartmentId());
            if (HussarUtils.isNotEmpty(rolesList)) {
                rolesList.addAll(roleList);
            }
        }
        userDetails.addExtendUserMap("rolesList", rolesList);
        ResourceGrantedAuthority resourceGrantedAuthority = this.getPermissionByRoleIds(rolesList, sysUsers.getId());
        userDetails.addExtendUserMap("theme", (Object)this.themeService.queryUserThemeWithUserId(sysUsers.getId()));
        ArrayList<Long> roleList = new ArrayList<Long>(rolesList);
        roleList.add(userDetails.getUserId());
        userDetails.addExtendUserMap("welcomeUrl", (Object)this.sysWelcomeService.getUserIndex(roleList));
        userDetails.addExtendUserMap("permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
        userDetails.addExtendUserMap("outOriginId", (Object)sysUsers.getOutOriginId());
        userDetails.addExtendUserMap("outUserId", (Object)sysUsers.getOutUserId());
        for (CustomizeUserInfoService customUserInfoService : this.customUserInfoServiceList) {
            customUserInfoService.fillUserInfoParams(userDetails);
        }
        userDetails.addExtendUserMap("outOriginUserId", (Object)sysUsers.getOutUserId());
        SysStru corporation = (SysStru)this.iSysStruService.getById((Serializable)((Object)String.valueOf(userDetails.getExtendUserMap().get("corporationId"))));
        SysStru dept = (SysStru)this.iSysStruService.getById((Serializable)((Object)String.valueOf(userDetails.getExtendUserMap().get("deptId"))));
        if (HussarUtils.isNotEmpty((Object)corporation)) {
            userDetails.addExtendUserMap("outOriginOrganId", (Object)corporation.getOutStruId());
            userDetails.addExtendUserMap("outOriginOrganType", (Object)corporation.getStruType());
        } else {
            userDetails.addExtendUserMap("outOriginOrganId", (Object)"");
            userDetails.addExtendUserMap("outOriginOrganType", (Object)"");
        }
        if (HussarUtils.isNotEmpty((Object)dept)) {
            userDetails.addExtendUserMap("outOriginDeptId", (Object)dept.getOutStruId());
            userDetails.addExtendUserMap("outOriginDeptType", (Object)dept.getStruType());
        } else {
            userDetails.addExtendUserMap("outOriginDeptId", (Object)"");
            userDetails.addExtendUserMap("outOriginDeptType", (Object)"");
        }
        Optional.ofNullable(this.userPostMainService.getUserPostMain(sysUsers.getEmployeeId())).ifPresent(up -> {
            SysPost syspost = (SysPost)this.sysPostService.getById((Serializable)up.getUpPostId());
            if (null != syspost) {
                userDetails.addExtendUserMap("outOriginPostId", (Object)syspost.getOutPostId());
            }
        });
        if (HussarUtils.isNotEmpty((Object)ssoToken)) {
            userDetails.addExtendUserMap("ssoToken", (Object)ssoToken);
        }
        return userDetails;
    }

    private List<Long> getRolesBySecurityUser(SysUsers securityUser, UserDetails userDetails) {
        List<Object> roleIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)securityUser)) {
            SysUserPostMainVo postMain = this.userPostMainService.getUserPostMain(securityUser.getEmployeeId());
            roleIdList = this.getRolesIdByUserId(securityUser.getId());
            if (HussarUtils.isNotEmpty((Object)postMain)) {
                userDetails.addExtendUserMap("postMain", (Object)postMain.getUpPostId());
                userDetails.addExtendUserMap("postCurrent", (Object)postMain.getUpPostId());
                userDetails.addExtendUserMap("postMainId", (Object)postMain.getUpId());
                userDetails.addExtendUserMap("postCurrentId", (Object)postMain.getUpId());
                List roleIdPostList = this.sysPostService.getRoleIdByUserId(securityUser.getId());
                roleIdList.addAll(roleIdPostList);
            }
        }
        LinkedHashSet hashSet = new LinkedHashSet(roleIdList);
        return new ArrayList<Long>(hashSet);
    }

    private boolean showTenantInfo(SysUsers sysUsers) {
        boolean flag = false;
        if (ToolUtil.isNotEmpty((Object)sysUsers)) {
            String account = sysUsers.getUserAccount();
            if (this.hussarBaseProperties.isTenantOpen() && "2".equals(this.hussarBaseProperties.getTenantUserModel()) && Arrays.asList(MANAGE_USER).contains(account)) {
                flag = true;
            }
        }
        return flag;
    }

    private String getDeptName(Long deptId) {
        SysOrganVo dept = this.iSysStruService.getOrgInfoByOrgId(deptId);
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    private List<Long> getRolesIdByUserId(Long userId) {
        return this.iSysUserRoleService.getRolesByUserId(userId);
    }

    private List<Long> getRolesIdByStruId(Long struId) {
        return this.iSysStruRoleService.getRolesByStruId(struId);
    }

    private ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList, Long userId) {
        ArrayList<String> resourcePermissions;
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        if (roleList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            List resourcesList = this.sysResourcesService.list();
            resourcePermissions = new ArrayList<String>();
            for (SysResources resources : resourcesList) {
                resourcePermissions.add(resources.getPermissions());
            }
        } else {
            resourcePermissions = this.sysResourcesService.queryPermissionsByRoleIds(roleList);
        }
        if (HussarUtils.isNotEmpty((Object)resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList(resourcePermissions);
        }
        return resourceGrantedAuthority;
    }

    private RoleGrantedAuthority getRolePermissions(List<Long> roleList, Long userId) {
        RoleGrantedAuthority roleGrantedAuthority = new RoleGrantedAuthority();
        List roles = new ArrayList();
        if (ToolUtil.isNotEmpty(roleList)) {
            roles = this.sysRolesService.listByIds(roleList);
        }
        ArrayList rolePermissions = new ArrayList();
        roles.forEach(sysRole -> {
            if (HussarUtils.isNotEmpty((Object)sysRole.getRolePermission())) {
                rolePermissions.add(sysRole.getRolePermission());
            }
        });
        if (HussarUtils.isNotEmpty(rolePermissions)) {
            roleGrantedAuthority.setGrantAuthorityList(rolePermissions);
        }
        return roleGrantedAuthority;
    }
}

