/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.SsoLoginValidateService;
import com.jxdinfo.hussar.authentication.util.HttpClientUtil;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SsoLoginValidateServiceImpl
implements SsoLoginValidateService {
    private static Logger log = LogManager.getLogger(SsoLoginValidateServiceImpl.class);
    @Value(value="${sso-login.clientId}")
    String clientId;
    @Value(value="${sso-login.clientSecret}")
    String clientSecret;
    @Value(value="${sso-login.grantType}")
    String grantType;
    @Value(value="${sso-login.redirectUri}")
    String redirectUri;
    @Value(value="${sso-login.ssoUrl}")
    String ssoUrl;
    @Value(value="${pm.grantType}")
    String pmGrantType;
    @Value(value="${pm.system}")
    String system;
    @Value(value="${pm.userType}")
    String userType;
    @Value(value="${pm.clientType}")
    String clientType;
    @Value(value="${pm.authorization}")
    String authorization;
    @Value(value="${pm.pmUrl}")
    String pmUrl;
    @Value(value="${pm.pmCountTestUrl}")
    String pmCountTestUrl;

    public String getLoginType() {
        return "81portal";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        if (HussarUtils.isEmpty((Object)loginCode)) {
            throw new ExtendLoginException("\u6388\u6743code\u4e3a\u7a7a");
        }
        return this.getUserInfo(loginCode);
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    public Map<String, String> getPmInfo(String pmToken) {
        HashMap<String, String> pmMap = new HashMap<String, String>();
        if (HussarUtils.isEmpty((Object)pmToken) || "undefined".equals(pmToken)) {
            return pmMap;
        }
        try {
            String workPlanCount = HttpClientUtil.sendGet(this.pmCountTestUrl + "pm/workflowcount", pmToken);
            JSONObject workPlanCountObject = (JSONObject)JSONArray.parse((String)workPlanCount);
            pmMap.put("xs", StringUtils.substringBefore((String)workPlanCountObject.getString("xs"), (String)"."));
            String numberCount = HttpClientUtil.sendGet(this.pmCountTestUrl + "task/approval/count", pmToken);
            JSONObject numberCountObject = (JSONObject)JSONArray.parse((String)numberCount);
            pmMap.put("numberCount", numberCountObject.getString("count"));
            String teamWorkCount = HttpClientUtil.sendGet(this.pmCountTestUrl + "pm/teamworkcount", pmToken);
            pmMap.put("teamWorkCount", teamWorkCount.trim());
        }
        catch (Exception e) {
            throw new ExtendLoginException("\u8bf7\u6c42\u83b7\u53d6PM\u7cfb\u7edf\u6570\u636e\u63a5\u53e3\u5931\u8d25");
        }
        return pmMap;
    }

    private String getUserInfo(String loginCode) {
        String userAccount;
        HashMap<String, String> ssoMap = new HashMap<String, String>();
        try {
            String tokenInfo = HttpClientUtil.sendGet(this.ssoUrl + "accessToken?client_id=" + this.clientId + "&client_secret=" + this.clientSecret + "&code=" + loginCode + "&grant_type=" + this.grantType + "&redirect_uri=" + this.redirectUri, "");
            JSONObject tokenObject = (JSONObject)JSONArray.parse((String)tokenInfo);
            String ssoToken = tokenObject.getString("access_token");
            ssoMap.put("ssoToken", ssoToken);
            String userInfo = HttpClientUtil.sendGet(this.ssoUrl + "profile?access_token=" + ssoToken, "");
            JSONObject userObject = (JSONObject)JSONArray.parse((String)userInfo);
            userAccount = userObject.getString("id");
            ssoMap.put("userAccount", userAccount);
        }
        catch (Exception e) {
            throw new ExtendLoginException("\u8bf7\u6c42\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u5931\u8d25");
        }
        return userAccount;
    }

    private String getPmToken(String ssoToken, String userAccount) {
        String pmToken;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auth_center_token", ssoToken);
        map.put("grant_type", this.pmGrantType);
        map.put("system", this.system);
        map.put("user_code", userAccount);
        map.put("user_type", this.userType);
        map.put("client_type", this.clientType);
        try {
            String pmInfo = HttpClientUtil.sendPost(this.pmUrl, map, this.authorization);
            JSONObject resultArray = (JSONObject)JSONArray.parse((String)pmInfo);
            pmToken = resultArray.getString("access_token");
        }
        catch (Exception e) {
            throw new ExtendLoginException("\u83b7\u53d6PM\u7cfb\u7edftoken\u5931\u8d25");
        }
        return pmToken;
    }
}

