/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.service.AuthcService;
import com.jxdinfo.hussar.authentication.vo.LoginInfoVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.IPageViewConfigService;
import com.jxdinfo.hussar.common.annotion.NoRepeatMethod;
import com.jxdinfo.hussar.common.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.IResultCode;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.stp.SecurityTokenInfo;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/frontLogin"})
@Api(tags={"\u767b\u5f55\u7ba1\u7406"})
public class FrontLoginController {
    private static Logger logger = LoggerFactory.getLogger(FrontLoginController.class);
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private IPageViewConfigService pageViewConfigService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private AuthcService authcService;
    @Resource
    private DruidProperties druidProperties;

    @PostMapping(value={"/login"})
    @NoRepeatMethod(timeout=500L)
    @ApiOperation(value="\u767b\u5f55", notes="\u767b\u5f55")
    @AuditLog(moduleName="\u767b\u5f55\u7ba1\u7406", eventDesc="\u767b\u5f55", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.LOGIN)
    public ApiResponse<LoginInfoVo> loginVali(@ApiParam(value="\u767b\u5f55\u8ba4\u8bc1\u76f8\u5173\u6570\u636e\u4f20\u8f93\u5bf9\u8c61") @RequestBody AuthcDto authcDto) {
        if (this.hussarBaseProperties.isTenantOpen()) {
            if ("1".equals(this.hussarBaseProperties.getTenantUserModel())) {
                return this.authcService.tenantLoginWithCode(authcDto);
            }
            return this.authcService.tenantLoginByAccount(authcDto);
        }
        return ApiResponse.success((Object)new LoginInfoVo());
    }

    @PostMapping(value={"/logout"})
    @ApiOperation(value="\u9000\u51fa\u767b\u5f55", notes="\u9000\u51fa\u767b\u5f55")
    @AuditLog(moduleName="\u767b\u5f55\u7ba1\u7406", eventDesc="\u9000\u51fa\u767b\u5f55", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.LOGOUT)
    public ApiResponse<String> logOut() {
        this.authcService.logout();
        return ApiResponse.success((IResultCode)ResultCode.SUCCESS, (String)ResultCode.SUCCESS.getMessage());
    }

    @GetMapping(value={"/check"})
    @ApiOperation(value="\u662f\u5426\u9700\u8981\u5f3a\u5236\u4fee\u6539\u5bc6\u7801", notes="\u662f\u5426\u9700\u8981\u5f3a\u5236\u4fee\u6539\u5bc6\u7801")
    public ApiResponse<Map<String, String>> check() {
        return this.authcService.check();
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @AuditLog(moduleName="\u767b\u5f55\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @GetMapping(value={"/getUserInfo"})
    public ApiResponse<SecurityTokenInfo> getUserInfo() {
        logger.info("\u5f53\u524d\u4f1a\u8bdd\u662f\u5426\u767b\u5f55\uff1a{}", (Object)SecurityUtil.isLogin());
        logger.info("\u83b7\u53d6\u5f53\u524d\u4f1a\u8bdd\u8d26\u53f7id:{}", SecurityUtil.getLoginId());
        logger.info("\u83b7\u53d6\u5f53\u524d`StpLogic`\u7684token\u540d\u79f0:{}", (Object)SecurityUtil.getTokenName());
        logger.info("\u83b7\u53d6\u5f53\u524d\u4f1a\u8bdd\u7684token\u503c:{}", (Object)SecurityUtil.getTokenValue());
        logger.info("\u83b7\u53d6\u5f53\u524d\u4f1a\u8bdd\u7684token\u4fe1\u606f\u53c2\u6570:{}", (Object)SecurityUtil.getTokenInfo());
        return ApiResponse.success((Object)SecurityUtil.getTokenInfo());
    }

    @PostMapping(value={"/getTotpKapcha"})
    @ApiOperation(value="\u662f\u5426\u5f00\u542ftotp,kaptcha", notes="\u662f\u5426\u5f00\u542ftotp,kaptcha")
    @Inner
    public ApiResponse<Map<String, Object>> getShow() {
        return this.authcService.getShow();
    }

    @PostMapping(value={"/validateLogin"})
    @Inner
    @ApiOperation(value="\u9a8c\u8bc1\u767b\u5f55\u72b6\u6001", notes="\u672a\u767b\u5f55\u65f6\u88ab\u62e6\u622a\u5668\u62e6\u622a\uff0c\u8fd4\u56de\u767b\u5f55\u53c2\u6570")
    public Map<String, Object> validateLogin() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", "success");
        return map;
    }

    @PostMapping(value={"/validateLogout"})
    @ApiOperation(value="\u767b\u51fa\u65f6\u9996\u5148\u8c03\u7528\u6b64\u63a5\u53e3", notes="cas\u6a21\u5f0f\u4e0b\u83b7\u53d6\u767b\u51faurl")
    @Inner
    public Map<String, Object> validateLogout() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        return map;
    }

    @GetMapping(value={"/isCasActive"})
    @ApiOperation(value="\u83b7\u53d6cas\u6a21\u5f0f\u4f7f\u7528\u72b6\u6001", notes="\u83b7\u53d6cas\u6a21\u5f0f\u4f7f\u7528\u72b6\u6001")
    @Inner
    public Map<String, Object> isCasActive() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("showLoginPage", this.hussarBaseProperties.isShowLoginPage());
        return map;
    }

    @GetMapping(value={"/getLoginViewInfo"})
    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u9875\u52a8\u6001\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f", notes="\u83b7\u53d6\u767b\u5f55\u9875\u52a8\u6001\u53ef\u89c6\u5316\u914d\u7f6e\u4fe1\u606f")
    @Inner
    public ApiResponse<Map<String, Object>> loginViewInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", this.pageViewConfigService.getLoginViewType());
        map.put("sysname", this.pageViewConfigService.getLoginViewSysname());
        map.put("copyright", this.pageViewConfigService.getLoginViewCopyright());
        map.put("logo", this.pageViewConfigService.getLoginViewLogo());
        map.put("kaptcha", this.pageViewConfigService.isLoginViewKaptcha());
        map.put("rememberpwd", this.pageViewConfigService.isLoginRememberpwd());
        map.put("background", this.pageViewConfigService.getLoginViewBackground());
        map.put("innerBackground", this.pageViewConfigService.getLoginViewInnerBackground());
        return ApiResponse.success(map);
    }

    @GetMapping(value={"/getTenantCodeByDomain"})
    @ApiOperation(value="\u901a\u8fc7\u57df\u540d\u83b7\u53d6\u79df\u6237\u7f16\u53f7", notes="\u901a\u8fc7\u57df\u540d\u83b7\u53d6\u79df\u6237\u7f16\u53f7")
    @Inner
    public ApiResponse<String> getTenantCodeByDomain(@ApiParam(value="\u57df\u540d") @RequestParam(value="domain") String domain) {
        String tenantCode = "";
        String masterDomain = this.druidProperties.getDomain();
        if (ToolUtil.isNotEmpty((Object)masterDomain) && masterDomain.equals(domain)) {
            return ApiResponse.success((String)"000000");
        }
        List list = this.sysTenantService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"tenant_domain", (Object)domain)).eq((Object)"is_deleted", (Object)"0"));
        if (list.size() > 0) {
            tenantCode = ((SysTenant)list.get(0)).getTenantCode();
        }
        return ApiResponse.success((String)tenantCode);
    }

    @PostMapping(value={"/changeTenant"})
    @NoRepeatMethod(timeout=500L)
    @ApiOperation(value="\u5207\u6362\u79df\u6237", notes="\u5207\u6362\u79df\u6237")
    public ApiResponse<LoginInfoVo> changeTenant(@ApiParam(value="\u767b\u5f55\u8ba4\u8bc1\u76f8\u5173\u6570\u636e\u4f20\u8f93\u5bf9\u8c61") @RequestBody AuthcDto authcDto) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        AuthcDto authBody = new AuthcDto();
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            authBody.setUsername(shiroUser.getAccount());
        } else {
            authBody.setUsername(authcDto.getUsername());
        }
        authBody.setCipher(authcDto.getCipher());
        authBody.setEncrypted(authcDto.getEncrypted());
        if (this.hussarBaseProperties.isTenantChangeInputPwd()) {
            authBody.setNoPwd(false);
        } else {
            authBody.setNoPwd(true);
        }
        return this.authcService.tenantLoginWithCode(authBody);
    }

    @GetMapping(value={"/changeTenantNeedPwd"})
    @ApiOperation(value="\u5207\u6362\u79df\u6237\u662f\u5426\u9700\u8981\u5bc6\u7801", notes="\u5207\u6362\u79df\u6237\u662f\u5426\u9700\u8981\u5bc6\u7801")
    @AuditLog(moduleName="\u767b\u5f55\u7ba1\u7406", eventDesc="\u5207\u6362\u79df\u6237\u662f\u5426\u9700\u8981\u5bc6\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.CONFIG)
    public ApiResponse<Map<String, Object>> changeTenantNeedPwd() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("showPwd", this.hussarBaseProperties.isTenantChangeInputPwd());
        return ApiResponse.success(map);
    }

    @GetMapping(value={"/getLoginUserInfo"})
    @ApiOperation(value="\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f", notes="\u83b7\u53d6\u767b\u5f55\u7528\u6237\u4fe1\u606f")
    public ApiResponse<SecurityUser> getLoginUserInfo(@ApiParam(value="\u767b\u5f55\u8ba4\u8bc1\u76f8\u5173\u6570\u636e\u4f20\u8f93\u5bf9\u8c61") AuthcDto authcDto) {
        return this.authcService.queryLoginUserInfo(authcDto);
    }
}

