/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authentication.util.LoginExceptionMailUtil;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IPageViewConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseDisabledAccountException;
import com.jxdinfo.hussar.common.exception.BaseDormancyException;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.exception.BaseLoginTimeRefuseException;
import com.jxdinfo.hussar.common.exception.BaseTemporaryAccountInvalidException;
import com.jxdinfo.hussar.common.exception.BaseUsernameOrPasswordErrorException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.properties.HussarSecurityProperties;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.IpUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Service;

@Configuration
@ConditionalOnProperty(prefix="ADLogin.security", name={"useAD"}, havingValue="false")
@Service
public class HussarDefaultLoginValidateServiceImpl
implements HussarLoginValidateService {
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private IPageViewConfigService pageViewConfigService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Autowired
    private HussarSecurityProperties securityProperties;
    private static final Long[] ADMINS = new Long[]{1450756958461300737L, 1450757481235202050L, 1450757527330615298L, 1450757604556025858L, 1450757642371981314L};
    @Value(value="${SystemSession.limit}")
    private int sessionLimit;

    public String getLoginType() {
        return "default";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        this.verifyCode(authcDto);
        return null;
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
        String cacheName = this.securityProperties.getTokenName();
        String key = cacheName + ":oauth2:access-token:";
        List tokens = HussarCacheUtil.getKeysRightLike((String)cacheName, (String)key);
        List filters = tokens.stream().map(item -> item.replace(key, "")).collect(Collectors.toList());
        if ((filters = filters.stream().map(item -> item.replace(cacheName + "::", "")).collect(Collectors.toList())).size() >= this.sessionLimit) {
            throw new BaseException("\u8d85\u51fa\u7cfb\u7edf\u4f1a\u8bdd\u4e0a\u9650\uff0c\u65e0\u6cd5\u767b\u5f55");
        }
        SysUsers sysUsers = new SysUsers();
        CopyPropertieUtils.copyProperties((Object)sysUsers, (Object)sysUsersDto);
        if (this.hussarLoginConfigService.getTotpOpen().booleanValue()) {
            this.checkedTotp(authcDto, sysUsers);
        }
        this.defaultValidateUser(authcDto, sysUsers);
    }

    private void verifyCode(AuthcDto authcDto) {
        Boolean isKaptcha = "index".equals(authcDto.getIsIndex()) ? this.pageViewConfigService.isLoginViewKaptcha() : this.hussarLoginConfigService.getKaptchaOpen().booleanValue();
        if (isKaptcha.booleanValue()) {
            String kaptcha = authcDto.getKaptcha();
            String kaptchasuffix = authcDto.getKaptchasuffix();
            String code = (String)HussarCacheUtil.get((String)"KAPTCHA_CODE", (Object)kaptchasuffix, String.class);
            if (StringUtils.isBlank((CharSequence)code)) {
                throw new BaseException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
            }
            HussarCacheUtil.evict((String)"KAPTCHA_CODE", (Object)kaptchasuffix);
            if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
                BaseException e = new BaseException("\u9a8c\u8bc1\u7801\u9519\u8bef");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u9a8c\u8bc1\u7801\u9519\u8bef");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserName(authcDto.getUsername());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
    }

    private void checkedTotp(AuthcDto authcDto, SysUsers sysUsers) {
        if (!this.abstractOTPCredentialsMatcher.verify(sysUsers.getTotpKey(), authcDto.getTotp(), this.hussarLoginConfigService.getTotpOffsetMin())) {
            BaseException e = new BaseException("\u52a8\u6001\u7801\u9519\u8bef");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u52a8\u6001\u7801\u9519\u8bef");
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }

    private void defaultValidateUser(AuthcDto authcDto, SysUsers sysUsers) {
        SysBaseConfig sysBaseConfig;
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failNumberConfig = iSysBaseConfigService.getSysBaseConfig("fail_number");
        String tryLoginTime = failNumberConfig.getConfigValue();
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = this.dynamicDataSourceService.currentDsName();
        String userName = sysUsers.getUserName();
        String userId = String.valueOf(sysUsers.getId());
        String password = authcDto.getCipher();
        String encPwd = this.credentialsMatcher.passwordEncode(password.getBytes());
        if (sysUsers.getAccountStatus().equals(UserStatus.LOCKED.getCode())) {
            BaseException e = new BaseException("\u8d26\u6237\u5df2\u51bb\u7ed3\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u8d26\u6237\u5df2\u51bb\u7ed3\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (!"1".equals(sysUsers.getIsDisable())) {
            BaseDisabledAccountException e = new BaseDisabledAccountException("\u5f53\u524d\u7528\u6237\u5df2\u88ab\u7981\u7528");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u8d26\u6237\u5df2\u88ab\u7981\u7528\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (this.hussarBaseProperties.isTenantOpen()) {
            if (loginLock.userIsLock(userId, connName)) {
                BaseDisabledAccountException e = new BaseDisabledAccountException("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        } else if (loginLock.userIsLock(userId)) {
            BaseDisabledAccountException e = new BaseDisabledAccountException("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (ToolUtil.isEmpty((Object)encPwd) || !encPwd.equalsIgnoreCase(sysUsers.getPassword())) {
            int loginChanceTime;
            int loginChance;
            if (this.hussarBaseProperties.isTenantOpen()) {
                loginLock.addUserCache(userId, sysUsers.getUserName(), connName, Integer.parseInt(tryLoginTime));
                loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userId, connName);
            } else {
                loginLock.addUserCache(userId, sysUsers.getUserName(), Integer.parseInt(tryLoginTime));
                loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userId);
            }
            int n = loginChanceTime = loginChance < 0 ? 0 : loginChance;
            if (loginChanceTime == 0) {
                new Thread(() -> LoginExceptionMailUtil.sendLockMail((String)userName)).start();
                BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException("\u5f53\u524d\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u5f53\u524d\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
            BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (this.hussarBaseProperties.isTenantOpen()) {
            loginLock.removeUserCache(userId, connName);
        } else {
            loginLock.removeUserCache(userId);
        }
        Date begin = null;
        Date end = null;
        Date now = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
        if (UserStatus.TEMPORARY.getCode().equals(sysUsers.getTypeProperty())) {
            String beginTime = sysUsers.getStartTime();
            String endTime = sysUsers.getExpiredTime();
            try {
                begin = sdf.parse(beginTime);
                end = sdf.parse(endTime);
                now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
            }
            catch (ParseException e) {
                BaseException exception = new BaseException("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw exception;
            }
            if (begin.getTime() > now.getTime()) {
                BaseTemporaryAccountInvalidException e = new BaseTemporaryAccountInvalidException(sysUsers.getUserName() + BaseExceptionEnum.TEMPORARYACCOUNT_INVALID.getMessage());
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u4e34\u65f6\u8d26\u6237\u672a\u5728\u6709\u6548\u671f\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
        if (!Arrays.asList(ADMINS).contains(sysUsers.getId())) {
            if (UserStatus.DORMANCY.getCode().equals(sysUsers.getAccountStatus())) {
                BaseDormancyException e = new BaseDormancyException(sysUsers.getUserName() + BaseExceptionEnum.ACCOUNT_DORMANCY.getMessage());
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u8d26\u6237\u5df2\u4f11\u7720\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
            if ("1".equals(sysUsers.getLoginTimeLimit())) {
                boolean flag = false;
                Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                String startTime = sysUsers.getAccessLoginStartTime();
                String endTime = sysUsers.getAccessLoginEndTime();
                Date dt1 = null;
                Date dt2 = null;
                try {
                    dt1 = time.parse(startTime);
                    dt2 = time.parse(endTime);
                    now = time.parse(time.format(date));
                }
                catch (Exception e) {
                    BaseException exception = new BaseException("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw exception;
                }
                if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
                    flag = true;
                }
                if (!flag) {
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
            String loginTimeLimt = iSysBaseConfigService.getSysBaseConfig("login_time_limit").getConfigValue();
            if ("0".equals(sysUsers.getLoginTimeLimit()) && "0".equals(loginTimeLimt)) {
                boolean flag = false;
                Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                String startTime = iSysBaseConfigService.getSysBaseConfig("login_start_time").getConfigValue();
                String endTime = iSysBaseConfigService.getSysBaseConfig("login_end_time").getConfigValue();
                Date dt1 = null;
                Date dt2 = null;
                try {
                    dt1 = time.parse(startTime);
                    dt2 = time.parse(endTime);
                    now = time.parse(time.format(date));
                }
                catch (ParseException e) {
                    BaseException exception = new BaseException("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw exception;
                }
                if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
                    flag = true;
                }
                if (!flag) {
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
        }
        if ("1".equals(sysUsers.getLoginIpLimit())) {
            boolean canLogin = false;
            String loginIp = IpUtils.getIp();
            List list = this.iSysUserIpService.selectUserIp(sysUsers.getId());
            for (String ip : list) {
                if (!StringUtils.equals((CharSequence)loginIp, (CharSequence)ip)) continue;
                canLogin = true;
                break;
            }
            if (!canLogin) {
                LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
        if (ToolUtil.isNotEmpty((Object)(sysBaseConfig = iSysBaseConfigService.getSysBaseConfig("login_ip_limit")))) {
            String loginIpLimit = sysBaseConfig.getConfigValue();
            if ("0".equals(sysUsers.getLoginIpLimit()) && "0".equals(loginIpLimit)) {
                List<String> forbidIpList;
                List<String> allowIpList;
                boolean flag = false;
                String loginIp = IpUtils.getIp();
                String allowIp = iSysBaseConfigService.getSysBaseConfig("allow_login_ip").getConfigValue();
                String forbidIp = iSysBaseConfigService.getSysBaseConfig("forbid_login_ip").getConfigValue();
                if (ToolUtil.isEmpty((Object)allowIp) && ToolUtil.isEmpty((Object)forbidIp)) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)allowIp) && ((allowIpList = Arrays.asList(allowIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)forbidIp) && !flag && (!(forbidIpList = Arrays.asList(forbidIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (!flag) {
                    LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                    LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
        }
    }
}

