/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.dto.GetBackPasswordDto;
import com.jxdinfo.hussar.authentication.service.GetBackPasswordService;
import com.jxdinfo.hussar.authorization.permit.model.SysGetBackPassword;
import com.jxdinfo.hussar.authorization.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysGetBackPasswordService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.stereotype.Service;

@Service
public class GetBackPasswordServiceImpl
implements GetBackPasswordService {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysGetBackPasswordService iSysGetBackPasswordService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;

    public ApiResponse<GetBackPasswordDto> queryUserQues(String userAccount) {
        if (ToolUtil.isEmpty((Object)userAccount)) {
            throw new BaseException("\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!this.iSysUsersService.isExistAccount(userAccount)) {
            throw new BaseException("\u7528\u6237\u4fe1\u606f\u9a8c\u8bc1\u9519\u8bef\uff01");
        }
        SysUsers user = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).ne(SysUsers::getAccountStatus, (Object)"2"), false);
        SysGetBackPassword sysGetBackPassword = (SysGetBackPassword)this.iSysGetBackPasswordService.getById((Serializable)user.getId());
        if (ToolUtil.isEmpty((Object)sysGetBackPassword)) {
            throw new BaseException("\u7528\u6237\u4fe1\u606f\u9a8c\u8bc1\u9519\u8bef\uff01");
        }
        GetBackPasswordDto getBackPasswordVo = new GetBackPasswordDto();
        getBackPasswordVo.setQuestion(sysGetBackPassword.getpQues());
        getBackPasswordVo.setUserAccount(userAccount);
        return ApiResponse.success((Object)getBackPasswordVo);
    }

    public ApiResponse queryValidateKey(GetBackPasswordDto getBackPasswordDto) {
        String pKey;
        String pQues;
        String userAccount = getBackPasswordDto.getUserAccount();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userAccount, pQues = getBackPasswordDto.getQuestion(), pKey = getBackPasswordDto.getAnswer()})) {
            throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysUsers user = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).ne(SysUsers::getAccountStatus, (Object)"2"), false);
        SysGetBackPassword sysGetBackPassword = (SysGetBackPassword)this.iSysGetBackPasswordService.getById((Serializable)user.getId());
        if (ToolUtil.isNotEmpty((Object)sysGetBackPassword)) {
            if (pQues.equals(sysGetBackPassword.getpQues()) && pKey.equals(sysGetBackPassword.getpKey())) {
                return ApiResponse.success((String)"\u9a8c\u8bc1\u901a\u8fc7\uff0c\u8bf7\u8bbe\u7f6e\u60a8\u7684\u65b0\u5bc6\u7801\uff01");
            }
            throw new BaseException("\u60a8\u8f93\u5165\u7684\u7b54\u6848\u4e0d\u6b63\u786e\uff01");
        }
        throw new BaseException("\u60a8\u6ca1\u6709\u8bbe\u7f6e\u5bc6\u4fdd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u627e\u56de\u60a8\u7684\u5bc6\u7801\uff01");
    }

    public ApiResponse saveNewPwd(GetBackPasswordDto getBackPasswordDto) {
        String cPwd;
        String newPwd;
        String userAccount = getBackPasswordDto.getUserAccount();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userAccount, newPwd = getBackPasswordDto.getNewPwd(), cPwd = getBackPasswordDto.getCheckPwd()})) {
            throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        userAccount = CryptoUtil.decode((String)userAccount);
        newPwd = CryptoUtil.decode((String)newPwd);
        cPwd = CryptoUtil.decode((String)cPwd);
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !ArrayUtils.contains((Object[])Constants.EXCLUDE_USER, (Object)userAccount)) {
            userAccount = userAccount.toUpperCase();
        }
        SysUsers user = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).ne(SysUsers::getAccountStatus, (Object)"2"), false);
        Long userId = user.getId();
        String regular = this.hussarPwdConfigService.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.hussarPwdConfigService.getUnmatchedHintMark();
        String pwdRule = this.hussarPwdConfigService.getPwdRule();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!newPwd.matches(regular)) {
            result.put("success", false);
            result.put("error", "unmatchedHintMark");
            result.put("pwdRule", pwdRule);
            result.put("hintMark", hint);
            return ApiResponse.success(result);
        }
        if (newPwd.toLowerCase().contains(userAccount.toLowerCase())) {
            result.put("success", false);
            result.put("error", "updateFailPwdNotUser");
            return ApiResponse.success(result);
        }
        if (!newPwd.equals(cPwd)) {
            result.put("success", false);
            result.put("error", "pwdNotSame");
            return ApiResponse.success(result);
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        List list = this.iSysUsersService.getPwdHist(userId);
        for (SysPasswordHist sysPasswordHist : list) {
            if (!nPwd.equals(sysPasswordHist.getPassword())) continue;
            result.put("success", false);
            result.put("error", "resetFail");
            result.put("repeatTime", this.hussarPwdConfigService.getPwdRepeatTime());
            return ApiResponse.success(result);
        }
        user.setPassword(nPwd);
        this.iSysUsersService.updatePwd(user);
        result.put("success", true);
        return ApiResponse.success(result);
    }
}

