/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.code.kaptcha.Producer;
import com.jxdinfo.hussar.authc.dto.AuthcDto;
import com.jxdinfo.hussar.authc.util.LoginExceptionMailUtil;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.base.cloud.api.dto.ResourceGrantedAuthority;
import com.jxdinfo.hussar.base.cloud.api.dto.RoleGrantedAuthority;
import com.jxdinfo.hussar.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseDisabledAccountException;
import com.jxdinfo.hussar.common.exception.BaseDormancyException;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.exception.BaseLoginTimeRefuseException;
import com.jxdinfo.hussar.common.exception.BaseTemporaryAccountInvalidException;
import com.jxdinfo.hussar.common.exception.BaseUsernameOrPasswordErrorException;
import com.jxdinfo.hussar.common.properties.GlobalProperties;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.properties.HussarProperties;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.enums.UserStatus;
import com.jxdinfo.hussar.organ.service.ISysStruService;
import com.jxdinfo.hussar.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.permit.model.SysUsers;
import com.jxdinfo.hussar.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.permit.service.ISysRolesService;
import com.jxdinfo.hussar.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.permit.service.ISysUsersService;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import com.jxdinfo.hussar.theme.service.IThemeService;
import com.jxdinfo.hussar.welcome.service.ISysWelcomeService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HussarLoginBaseServiceImpl
implements HussarLoginService {
    private static Logger logger = LoggerFactory.getLogger(HussarLoginBaseServiceImpl.class);
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysBaseConfigService iSysBaseConfigService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    HussarProperties hussarProperties;
    @Resource
    private Producer producer;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysWelcomeService sysWelcomeService;

    public UserDetails login(AuthcDto authcDto) {
        SysUsers sysUsers;
        this.verifyCode(authcDto);
        String account = authcDto.getUsername();
        if (!this.hussarProperties.getLoginUpperOpen().booleanValue() && !ArrayUtils.contains((Object[])Constants.EXCLUDE_USER, (Object)authcDto.getUsername())) {
            account = authcDto.getUsername().toUpperCase();
        }
        if (ToolUtil.isEmpty((Object)(sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false)))) {
            BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException(BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserName(authcDto.getUsername());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (this.hussarProperties.getLoginUpperOpen().booleanValue() && !authcDto.getUsername().equals(sysUsers.getUserAccount())) {
            BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException(BaseExceptionEnum.USERNAME_OR_PASSWORD_ERROR.getMessage());
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u67e5\u8be2\u7528\u6237\u540d\u548c\u5bc6\u7801");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (this.hussarProperties.getTotpOpen().booleanValue()) {
            this.checkedTotp(authcDto, sysUsers);
        }
        this.validateUser(authcDto, sysUsers);
        UserDetails userDetails = this.getLoginSecurityUser(sysUsers);
        if (userDetails != null) {
            sysUsers.setLastLoginTime(new Date());
            sysUsers.setLastEditor(userDetails.getUserId());
            sysUsers.setLastTime(LocalDateTime.now());
            this.iSysUsersService.updateById((Object)sysUsers);
        }
        return userDetails;
    }

    private void validateUser(AuthcDto authcDto, SysUsers sysUsers) {
        SysBaseConfig sysBaseConfig;
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failNumberConfig = iSysBaseConfigService.getSysBaseConfig("fail_number");
        String tryLoginTime = failNumberConfig.getConfigValue();
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = this.dynamicDataSourceService.currentDsName();
        String userName = sysUsers.getUserName();
        String userId = String.valueOf(sysUsers.getId());
        String password = authcDto.getCipher();
        String encPwd = this.credentialsMatcher.passwordEncode(password.getBytes());
        if (sysUsers.getAccountStatus().equals(UserStatus.LOCKED.getCode())) {
            BaseException e = new BaseException("\u8d26\u6237\u5df2\u51bb\u7ed3\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u8d26\u6237\u5df2\u51bb\u7ed3\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (this.hussarBaseProperties.isTenantOpen()) {
            if (loginLock.userIsLock(userId, connName)) {
                BaseDisabledAccountException e = new BaseDisabledAccountException("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        } else if (loginLock.userIsLock(userId)) {
            BaseDisabledAccountException e = new BaseDisabledAccountException("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (ToolUtil.isEmpty((Object)encPwd) || !encPwd.equalsIgnoreCase(sysUsers.getPassword())) {
            int loginChanceTime;
            int loginChance;
            if (this.hussarBaseProperties.isTenantOpen()) {
                loginLock.addUserCache(userId, sysUsers.getUserName(), connName, Integer.parseInt(tryLoginTime));
                loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userId, connName);
            } else {
                loginLock.addUserCache(userId, sysUsers.getUserName(), Integer.parseInt(tryLoginTime));
                loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userId);
            }
            int n = loginChanceTime = loginChance < 0 ? 0 : loginChance;
            if (loginChanceTime == 0) {
                new Thread(() -> LoginExceptionMailUtil.sendLockMail((String)userName)).start();
                BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException("\u5f53\u524d\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u5f53\u524d\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
            BaseUsernameOrPasswordErrorException e = new BaseUsernameOrPasswordErrorException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a\uff01");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a\uff01");
            UserDetails userDetails = new UserDetails();
            userDetails.setUserId(sysUsers.getId());
            userDetails.setUserName(sysUsers.getUserName());
            auditLogModel.setUserDetails(userDetails);
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
        if (this.hussarBaseProperties.isTenantOpen()) {
            loginLock.removeUserCache(userId, connName);
        } else {
            loginLock.removeUserCache(userId);
        }
        Date begin = null;
        Date end = null;
        Date now = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
        if (UserStatus.TEMPORARY.getCode().equals(sysUsers.getTypeProperty())) {
            String beginTime = sysUsers.getStartTime();
            String endTime = sysUsers.getExpiredTime();
            try {
                begin = sdf.parse(beginTime);
                end = sdf.parse(endTime);
                now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
            }
            catch (ParseException e) {
                BaseException exception = new BaseException("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw exception;
            }
            if (begin.getTime() > now.getTime()) {
                BaseTemporaryAccountInvalidException e = new BaseTemporaryAccountInvalidException(sysUsers.getUserName() + BaseExceptionEnum.TEMPORARYACCOUNT_INVALID.getMessage());
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u4e34\u65f6\u8d26\u6237\u672a\u5728\u6709\u6548\u671f\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
        if (!Arrays.asList(Constants.ADMINS).contains(sysUsers.getId())) {
            if (UserStatus.DORMANCY.getCode().equals(sysUsers.getAccountStatus())) {
                BaseDormancyException e = new BaseDormancyException(sysUsers.getUserName() + BaseExceptionEnum.ACCOUNT_DORMANCY.getMessage());
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u8d26\u6237\u5df2\u4f11\u7720\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
            if ("1".equals(sysUsers.getLoginTimeLimit())) {
                boolean flag = false;
                Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                String startTime = sysUsers.getAccessLoginStartTime();
                String endTime = sysUsers.getAccessLoginEndTime();
                Date dt1 = null;
                Date dt2 = null;
                try {
                    dt1 = time.parse(startTime);
                    dt2 = time.parse(endTime);
                    now = time.parse(time.format(date));
                }
                catch (Exception e) {
                    BaseException exception = new BaseException("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw exception;
                }
                if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
                    flag = true;
                }
                if (!flag) {
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
            String loginTimeLimt = iSysBaseConfigService.getSysBaseConfig("login_time_limit").getConfigValue();
            if ("0".equals(sysUsers.getLoginTimeLimit()) && "0".equals(loginTimeLimt)) {
                boolean flag = false;
                Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                String startTime = iSysBaseConfigService.getSysBaseConfig("login_start_time").getConfigValue();
                String endTime = iSysBaseConfigService.getSysBaseConfig("login_end_time").getConfigValue();
                Date dt1 = null;
                Date dt2 = null;
                try {
                    dt1 = time.parse(startTime);
                    dt2 = time.parse(endTime);
                    now = time.parse(time.format(date));
                }
                catch (ParseException e) {
                    BaseException exception = new BaseException("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc("\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw exception;
                }
                if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
                    flag = true;
                }
                if (!flag) {
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
        }
        if ("1".equals(sysUsers.getLoginIpLimit())) {
            boolean canLogin = false;
            String loginIp = HttpKit.getIp();
            List list = this.iSysUserIpService.selectUserIp(sysUsers.getId());
            for (String ip : list) {
                if (!StringUtils.equals((CharSequence)loginIp, (CharSequence)ip)) continue;
                canLogin = true;
                break;
            }
            if (!canLogin) {
                LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserId(sysUsers.getId());
                userDetails.setUserName(sysUsers.getUserName());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
        if (ToolUtil.isNotEmpty((Object)(sysBaseConfig = iSysBaseConfigService.getSysBaseConfig("login_ip_limit")))) {
            String loginIpLimit = sysBaseConfig.getConfigValue();
            if ("0".equals(sysUsers.getLoginIpLimit()) && "0".equals(loginIpLimit)) {
                List<String> forbidIpList;
                List<String> allowIpList;
                boolean flag = false;
                String loginIp = HttpKit.getIp();
                String allowIp = iSysBaseConfigService.getSysBaseConfig("allow_login_ip").getConfigValue();
                String forbidIp = iSysBaseConfigService.getSysBaseConfig("forbid_login_ip").getConfigValue();
                if (ToolUtil.isEmpty((Object)allowIp) && ToolUtil.isEmpty((Object)forbidIp)) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)allowIp) && ((allowIpList = Arrays.asList(allowIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)forbidIp) && !flag && (!(forbidIpList = Arrays.asList(forbidIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (!flag) {
                    LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                    LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                    BaseLoginTimeRefuseException e = new BaseLoginTimeRefuseException(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                    AuditLogModel auditLogModel = new AuditLogModel();
                    auditLogModel.setModuleName("\u767b\u5f55");
                    auditLogModel.setExceptionInfo((Throwable)e);
                    auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                    auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                    auditLogModel.setEventDesc(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55\uff01");
                    UserDetails userDetails = new UserDetails();
                    userDetails.setUserId(sysUsers.getId());
                    userDetails.setUserName(sysUsers.getUserName());
                    auditLogModel.setUserDetails(userDetails);
                    AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                    throw e;
                }
            }
        }
    }

    private UserDetails getLoginSecurityUser(SysUsers sysUsers) {
        String connName;
        UserDetails userDetails = new UserDetails();
        if (this.hussarBaseProperties.isTenantOpen() && ToolUtil.isNotEmpty((Object)(connName = this.dynamicDataSourceService.currentDsName()))) {
            SysTenant tenant;
            userDetails.addExtendUserMap("connName", (Object)connName);
            if ("master".equals(connName)) {
                userDetails.addExtendUserMap("tenantCode", (Object)"000000");
                tenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new QueryWrapper().eq((Object)"TENANT_CODE", (Object)"000000"));
                if (ToolUtil.isNotEmpty((Object)tenant)) {
                    userDetails.addExtendUserMap("tenantId", (Object)String.valueOf(tenant.getId()));
                    userDetails.addExtendUserMap("tenantName", (Object)tenant.getTenantName());
                    userDetails.addExtendUserMap("tenantCipher", (Object)String.valueOf(tenant.getBpmTenantCipher()));
                    userDetails.addExtendUserMap("bpmTenantId", (Object)String.valueOf(tenant.getId()));
                    userDetails.addExtendUserMap("bpmTenantCipher", (Object)String.valueOf(tenant.getBpmTenantCipher()));
                }
            } else {
                tenant = this.sysTenantService.queryTenantByConnName(connName);
                if (ToolUtil.isNotEmpty((Object)tenant)) {
                    userDetails.addExtendUserMap("tenantCode", (Object)tenant.getTenantCode());
                    userDetails.addExtendUserMap("tenantId", (Object)String.valueOf(tenant.getId()));
                    userDetails.addExtendUserMap("tenantCipher", (Object)String.valueOf(tenant.getBpmTenantCipher()));
                    userDetails.addExtendUserMap("bpmTenantId", (Object)String.valueOf(tenant.getId()));
                    userDetails.addExtendUserMap("bpmTenantCipher", (Object)String.valueOf(tenant.getBpmTenantCipher()));
                }
            }
        }
        userDetails.setUserId(sysUsers.getId());
        userDetails.addExtendUserMap("account", (Object)sysUsers.getUserAccount());
        userDetails.setUserName(sysUsers.getUserName());
        userDetails.addExtendUserMap("deptId", (Object)sysUsers.getDepartmentId());
        userDetails.addExtendUserMap("employeeId", (Object)sysUsers.getEmployeeId());
        userDetails.addExtendUserMap("deptName", (Object)this.getDeptName(sysUsers.getDepartmentId()));
        userDetails.addExtendUserMap("securityLevel", (Object)sysUsers.getSecurityLevel());
        userDetails.addExtendUserMap("accountStatus", (Object)sysUsers.getAccountStatus());
        userDetails.addExtendUserMap("showTenant", (Object)this.showTenantInfo(sysUsers));
        userDetails.setMaxSameCount(Integer.valueOf(sysUsers.getMaxSessions().intValue()));
        List<Long> rolesList = this.getRolesIdByUserId(sysUsers.getId());
        userDetails.addExtendUserMap("gradeAdmin", (Object)(rolesList != null && rolesList.contains(SysUserAndRole.GRADEADMIN_ROLE.getValue()) ? 1 : 0));
        Long employeeId = sysUsers.getEmployeeId();
        Long departmentId = sysUsers.getDepartmentId();
        if (ToolUtil.isNotEmpty((Object)employeeId) && ToolUtil.isNotEmpty((Object)departmentId)) {
            List<Long> roleList = this.getRolesIdByStruId(sysUsers.getDepartmentId());
            rolesList.addAll(roleList);
        }
        userDetails.addExtendUserMap("rolesList", rolesList);
        ArrayList<Object> grantedAuthorities = new ArrayList<Object>();
        grantedAuthorities.add(0, this.getRolePermissions(rolesList, sysUsers.getId()));
        ResourceGrantedAuthority resourceGrantedAuthority = this.getPermissionByRoleIds(rolesList, sysUsers.getId());
        grantedAuthorities.add(1, resourceGrantedAuthority);
        userDetails.setGrantedAuthoritys(grantedAuthorities);
        userDetails.addExtendUserMap("theme", (Object)this.themeService.queryUserThemeWithUserId(sysUsers.getId()));
        ArrayList<Long> roleList = new ArrayList<Long>(rolesList);
        roleList.add(userDetails.getUserId());
        userDetails.addExtendUserMap("welcomeUrl", (Object)this.sysWelcomeService.getUserIndex(roleList));
        userDetails.addExtendUserMap("permissions", (Object)resourceGrantedAuthority.getGrantAuthorityList());
        return userDetails;
    }

    private String getDeptName(Long deptId) {
        SysOrganVo dept = this.iSysStruService.getOrgInfoByOrgId(deptId);
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    private List<Long> getRolesIdByUserId(Long userId) {
        return this.iSysUserRoleService.getRolesByUserId(userId);
    }

    private List<Long> getRolesIdByStruId(Long struId) {
        return this.iSysStruRoleService.getRolesByStruId(struId);
    }

    private ResourceGrantedAuthority getPermissionByRoleIds(List<Long> roleList, Long userId) {
        ResourceGrantedAuthority resourceGrantedAuthority = new ResourceGrantedAuthority();
        List resourcePermissions = this.sysResourcesService.queryPermissionsByRoleIds(roleList);
        if (HussarUtils.isNotEmpty((Object)resourcePermissions)) {
            resourceGrantedAuthority.setGrantAuthorityList(resourcePermissions);
        }
        return resourceGrantedAuthority;
    }

    private RoleGrantedAuthority getRolePermissions(List<Long> roleList, Long userId) {
        RoleGrantedAuthority roleGrantedAuthority = new RoleGrantedAuthority();
        List roles = this.sysRolesService.listByIds(roleList);
        ArrayList rolePermissions = new ArrayList();
        roles.forEach(sysRole -> {
            if (HussarUtils.isNotEmpty((Object)sysRole.getRolePermission())) {
                rolePermissions.add(sysRole.getRolePermission());
            }
        });
        if (HussarUtils.isNotEmpty(rolePermissions)) {
            roleGrantedAuthority.setGrantAuthorityList(rolePermissions);
        }
        return roleGrantedAuthority;
    }

    private boolean showTenantInfo(SysUsers sysUsers) {
        boolean flag = false;
        if (ToolUtil.isNotEmpty((Object)sysUsers)) {
            String account = sysUsers.getUserAccount();
            if (this.hussarBaseProperties.isTenantOpen() && "2".equals(this.hussarBaseProperties.getTenantUserModel()) && Arrays.asList(Constants.MANAGE_USER).contains(account)) {
                flag = true;
            }
        }
        return flag;
    }

    private void verifyCode(AuthcDto authcDto) {
        Boolean isKaptcha = "index".equals(authcDto.getIsIndex()) ? this.globalProperties.isLoginViewKaptcha() : this.hussarProperties.getKaptchaOpen().booleanValue();
        if (isKaptcha.booleanValue()) {
            String kaptcha = authcDto.getKaptcha();
            String code = (String)HttpKit.getRequest().getSession().getAttribute("KAPTCHA_SESSION_KEY");
            if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
                HttpKit.getRequest().getSession().setAttribute("KAPTCHA_SESSION_KEY", (Object)this.producer.createText());
                BaseException e = new BaseException("\u9a8c\u8bc1\u7801\u9519\u8bef");
                AuditLogModel auditLogModel = new AuditLogModel();
                auditLogModel.setModuleName("\u767b\u5f55");
                auditLogModel.setExceptionInfo((Throwable)e);
                auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
                auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
                auditLogModel.setEventDesc("\u9a8c\u8bc1\u7801\u9519\u8bef");
                UserDetails userDetails = new UserDetails();
                userDetails.setUserName(authcDto.getUsername());
                auditLogModel.setUserDetails(userDetails);
                AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
                throw e;
            }
        }
    }

    private void checkedTotp(AuthcDto authcDto, SysUsers sysUsers) {
        if (!this.abstractOTPCredentialsMatcher.verify(sysUsers.getTotpKey(), authcDto.getTotp(), this.hussarProperties.getTotpOffsetMin())) {
            BaseException e = new BaseException("\u52a8\u6001\u7801\u9519\u8bef");
            AuditLogModel auditLogModel = new AuditLogModel();
            auditLogModel.setModuleName("\u767b\u5f55");
            auditLogModel.setExceptionInfo((Throwable)e);
            auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
            auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
            auditLogModel.setEventDesc("\u52a8\u6001\u7801\u9519\u8bef");
            AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
            throw e;
        }
    }
}

