/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authc.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authc.dao.SysAuthClientModelMapper;
import com.jxdinfo.hussar.authc.service.SysAuthClientModelService;
import com.jxdinfo.hussar.base.cloud.api.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.core.secure.SecuritySecureUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SysAuthClientModelServiceImpl
extends HussarServiceImpl<SysAuthClientModelMapper, SysAuthClientModel>
implements SysAuthClientModelService {
    @Resource
    private SysAuthClientModelMapper sysAuthClientModelMapper;
    private static final String PRIVATE_KEY = "private";
    private static final String PUBLIC_KEY = "public";

    public IPage<SysAuthClientModel> getClientModelList(Page<SysAuthClientModel> page, SysAuthClientModel authClientModel) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(HussarDelflagEntity::getDelFlag, (Object)"0")).orderByDesc(HussarBaseEntity::getCreateTime);
        return this.sysAuthClientModelMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
    }

    public ApiResponse<SysAuthClientModel> saveAuthClientModel(SysAuthClientModel authClientModel) throws Exception {
        this.checkSaveOrUpdate(authClientModel);
        HashMap keyMap = SecuritySecureUtil.rsaGenerateKeyPair();
        authClientModel.setPrivateKey((String)keyMap.get(PRIVATE_KEY));
        authClientModel.setPublicKey((String)keyMap.get(PUBLIC_KEY));
        if (this.save(authClientModel)) {
            return ApiResponse.success((Object)authClientModel);
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    public ApiResponse<SysAuthClientModel> updateAuthClientModel(SysAuthClientModel authClientModel) {
        this.checkSaveOrUpdate(authClientModel);
        if (this.updateById(authClientModel)) {
            return ApiResponse.success((Object)authClientModel);
        }
        throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
    }

    public ApiResponse<SysAuthClientModel> deleteAuthClientModel(Long id) {
        if (this.removeById(id)) {
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
    }

    public ApiResponse<SysAuthClientModel> queryAuthClientModelDetail(Long id) {
        return ApiResponse.success((Object)this.getById(id));
    }

    public ApiResponse<String> getPublicKey(String clientId) {
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysAuthClientModel::getClientId, (Object)clientId);
            List list = this.sysAuthClientModelMapper.selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                return ApiResponse.success((String)((SysAuthClientModel)list.get(0)).getPublicKey());
            }
        }
        return ApiResponse.fail((String)"\u53c2\u6570clientId\u4e3a\u7a7a");
    }

    private void checkSaveOrUpdate(SysAuthClientModel authClientModel) {
        if (StringUtils.isNotBlank((CharSequence)authClientModel.getClientId())) {
            List ifRepeat;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysAuthClientModel::getClientId, (Object)authClientModel.getClientId());
            if (authClientModel.getId() != null) {
                queryWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.ne(SysAuthClientModel::getId, (Object)authClientModel.getId());
                });
            }
            if ((ifRepeat = this.list((Wrapper)queryWrapper)).size() > 0) {
                throw new BaseException("\u5ba2\u6237\u7aefID\u5df2\u7ecf\u5b58\u5728");
            }
        } else {
            throw new BaseException("\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

