/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.permit.model.SysRoles;
import com.jxdinfo.hussar.permit.model.SysUserRole;
import com.jxdinfo.hussar.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.permit.service.ISysRolesService;
import com.jxdinfo.hussar.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.support.security.core.stp.SecurityInterface;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="hussar", name={"login-method"}, havingValue="default", matchIfMissing=false)
public class SecurityInterfaceBaseImpl
implements SecurityInterface {
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysRolesService sysRolesService;

    public List<String> getPermissionList(Object loginId, String loginType) {
        List<Long> roleIdList = this.getRoleIdList(Long.valueOf(String.valueOf(loginId)));
        if (ToolUtil.isNotEmpty(roleIdList)) {
            return this.sysResourcesService.queryPermissionsByRoleIds(roleIdList);
        }
        return new ArrayList<String>();
    }

    public List<String> getRoleList(Object loginId, String loginType) {
        List<Long> roleIdList = this.getRoleIdList(Long.valueOf(String.valueOf(loginId)));
        ArrayList<String> rolePermissionList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(roleIdList)) {
            List rolesList = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIdList));
            rolesList.forEach(role -> rolePermissionList.add(role.getRolePermission()));
        }
        return rolePermissionList;
    }

    private List<Long> getRoleIdList(Long userId) {
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        List userRoleList = this.sysUserRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId));
        userRoleList.forEach(userRole -> roleIdList.add(userRole.getGrantedRole()));
        return roleIdList;
    }
}

