/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authc.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.common.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.properties.GlobalProperties;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.enums.UserStatus;
import com.jxdinfo.hussar.organ.service.ISysStruService;
import com.jxdinfo.hussar.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.permit.model.SysUsers;
import com.jxdinfo.hussar.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.permit.service.ISysUsersService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="hussar", name={"login-method"}, havingValue="default", matchIfMissing=false)
public class HussarLoginBaseServiceImpl
implements HussarLoginService {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;

    public Object login(AuthcDto authcDto) {
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)authcDto.getUsername())).eq(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode()), false);
        this.validateUser(authcDto, sysUsers);
        return this.getLoginSecurityUser(sysUsers);
    }

    private void validateUser(AuthcDto authcDto, SysUsers sysUsers) {
        if (ToolUtil.isEmpty((Object)sysUsers)) {
            throw new HussarException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        String password = authcDto.getCipher();
        String encPwd = this.credentialsMatcher.passwordEncode(password.getBytes());
        if (ToolUtil.isEmpty((Object)encPwd) || !encPwd.equalsIgnoreCase(sysUsers.getPassword())) {
            throw new HussarException("\u5bc6\u7801\u8f93\u5165\u9519\u8bef\uff01");
        }
    }

    private SecurityUser getLoginSecurityUser(SysUsers sysUsers) {
        String connName;
        SecurityUser securityUser = new SecurityUser();
        if (this.globalProperties.isTenantOpen() && ToolUtil.isNotEmpty((Object)(connName = this.dynamicDataSourceService.currentDsName()))) {
            SysTenant tenant;
            securityUser.setConnName(connName);
            if ("master".equals(connName)) {
                securityUser.setTenantCode("000000");
                tenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new QueryWrapper().eq((Object)"TENANT_CODE", (Object)"000000"));
                if (ToolUtil.isNotEmpty((Object)tenant)) {
                    securityUser.setTenantId(String.valueOf(tenant.getId()));
                    securityUser.setTenantName(tenant.getTenantName());
                    securityUser.setTenantCipher(String.valueOf(tenant.getBpmTenantCipher()));
                }
            } else {
                tenant = this.sysTenantService.queryTenantByConnName(connName);
                if (ToolUtil.isNotEmpty((Object)tenant)) {
                    securityUser.setTenantCode(tenant.getTenantCode());
                    securityUser.setTenantId(String.valueOf(tenant.getId()));
                    securityUser.setTenantCipher(String.valueOf(tenant.getBpmTenantCipher()));
                }
            }
        }
        securityUser.setId(sysUsers.getId());
        securityUser.setAccount(sysUsers.getUserAccount());
        securityUser.setDeptId(sysUsers.getDepartmentId());
        securityUser.setEmployeeId(sysUsers.getEmployeeId());
        securityUser.setDeptName(this.getDeptName(sysUsers.getDepartmentId()));
        securityUser.setName(sysUsers.getUserName());
        securityUser.setSecurityLevel(sysUsers.getSecurityLevel());
        securityUser.setAccountStatus(sysUsers.getAccountStatus());
        List<Long> rolesList = this.getRolesIdByUserId(sysUsers.getId());
        Long employeeId = sysUsers.getEmployeeId();
        Long departmentId = sysUsers.getDepartmentId();
        if (ToolUtil.isNotEmpty((Object)employeeId) && ToolUtil.isNotEmpty((Object)departmentId)) {
            List<Long> roleList = this.getRolesIdByStruId(sysUsers.getDepartmentId());
            rolesList.addAll(roleList);
        }
        securityUser.setRolesList(rolesList);
        return securityUser;
    }

    private String getDeptName(Long deptId) {
        SysOrganVo dept = this.iSysStruService.getOrgInfoByOrgId(deptId);
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    private List<Long> getRolesIdByUserId(Long userId) {
        return this.iSysUserRoleService.getRolesByUserId(userId);
    }

    private List<Long> getRolesIdByStruId(Long struId) {
        return this.iSysStruRoleService.getRolesByStruId(struId);
    }
}

