/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.google.code.kaptcha.Producer;
import com.jxdinfo.hussar.authc.dto.AuthcDto;
import com.jxdinfo.hussar.authc.util.LoginExceptionMailUtil;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.DormancyException;
import com.jxdinfo.hussar.common.exception.HussarCredentialsException;
import com.jxdinfo.hussar.common.exception.HussarDisabledAccountException;
import com.jxdinfo.hussar.common.exception.HussarLockedAccountException;
import com.jxdinfo.hussar.common.exception.LoginIpRefuseException;
import com.jxdinfo.hussar.common.exception.LoginTimeRefuseException;
import com.jxdinfo.hussar.common.properties.GlobalProperties;
import com.jxdinfo.hussar.common.properties.HussarProperties;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.organ.service.ISysStruService;
import com.jxdinfo.hussar.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.permit.model.SysUsers;
import com.jxdinfo.hussar.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.permit.service.ISysUsersService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.tenant.model.SysTenant;
import com.jxdinfo.hussar.tenant.service.SysTenantService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="hussar", name={"login-method"}, havingValue="default", matchIfMissing=false)
public class HussarLoginBaseServiceImpl
implements HussarLoginService {
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private SysTenantService sysTenantService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysBaseConfigService iSysBaseConfigService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    HussarProperties hussarProperties;
    @Resource
    private Producer producer;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;

    public Object login(AuthcDto authcDto) {
        this.verifyCode(authcDto);
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)authcDto.getUsername())).ne(SysUsers::getAccountStatus, (Object)com.jxdinfo.hussar.enums.UserStatus.DELETE.getCode()), false);
        if (ToolUtil.isEmpty((Object)sysUsers)) {
            throw new HussarException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        this.validateUser(authcDto, sysUsers);
        return this.getLoginSecurityUser(sysUsers);
    }

    private void validateUser(AuthcDto authcDto, SysUsers sysUsers) {
        SysBaseConfig sysBaseConfig;
        if (this.hussarProperties.getLoginUpperOpen().booleanValue() && !authcDto.getUsername().equals(sysUsers.getUserAccount())) {
            throw new HussarException("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        if (com.jxdinfo.hussar.enums.UserStatus.LOCKED.getCode().equals(sysUsers.getAccountStatus())) {
            throw new HussarException(sysUsers.getUserName() + "\u8d26\u53f7\u88ab\u9501\u5b9a");
        }
        if (com.jxdinfo.hussar.enums.UserStatus.CANCEL.getCode().equals(sysUsers.getAccountStatus())) {
            throw new HussarException(sysUsers.getUserName() + "\u8d26\u53f7\u88ab\u6ce8\u9500");
        }
        if (com.jxdinfo.hussar.enums.UserStatus.DORMANCY.getCode().equals(sysUsers.getAccountStatus())) {
            throw new HussarException(sysUsers.getUserName() + "\u8d26\u53f7\u5df2\u4f11\u7720");
        }
        if (Arrays.asList(Constants.MANAGE_USER).contains(sysUsers.getUserAccount())) {
            return;
        }
        if (ToolUtil.isNotEmpty((Object)sysUsers.getLastLoginTime())) {
            Date lastLoginDate = sysUsers.getLastLoginTime();
            SysBaseConfig noLogin = this.iSysBaseConfigService.getSysBaseConfig("nologin_day");
            SysBaseConfig userAccountStatus = this.iSysBaseConfigService.getSysBaseConfig("user_account_status");
            String days = noLogin.getConfigValue();
            String status = userAccountStatus.getConfigValue();
            Date date = DateUtil.addDay((Date)lastLoginDate, (int)Integer.parseInt(days));
            if (date.getTime() < System.currentTimeMillis()) {
                SysUsers sysUser = new SysUsers();
                sysUser.setId(sysUsers.getId());
                sysUser.setAccountStatus(com.jxdinfo.hussar.enums.UserStatus.LOCKED.getCode());
                this.iSysUsersService.updateById((Object)sysUser);
                if (com.jxdinfo.hussar.enums.UserStatus.DORMANCY.getCode().equals(status)) {
                    throw new DormancyException(sysUsers.getUserName(), "\u8d26\u53f7\u5df2\u4f11\u7720", "dormancy");
                }
                throw new HussarLockedAccountException(sysUsers.getUserName(), "\u8d85\u8fc7" + days + "\u5929\u672a\u767b\u5f55\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a", "notLoggedLocked", days);
            }
        }
        if (com.jxdinfo.hussar.enums.UserStatus.TEMPORARY.getCode().equals(sysUsers.getTypeProperty())) {
            String beginTime = sysUsers.getStartTime();
            String endTime = sysUsers.getExpiredTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(beginTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    throw new HussarException(sysUsers.getUserName() + "\u4e34\u65f6\u8d26\u53f7\u672a\u5728\u6709\u6548\u671f");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (ToolUtil.isNotEmpty((Object)(sysBaseConfig = this.iSysBaseConfigService.getSysBaseConfig("login_ip_limit")))) {
            String loginTimeLimt;
            String loginIpLimit = sysBaseConfig.getConfigValue();
            if ("0".equals(loginIpLimit)) {
                List<String> forbidIpList;
                List<String> allowIpList;
                boolean flag = false;
                String loginIp = HttpKit.getIp();
                String allowIp = this.iSysBaseConfigService.getSysBaseConfig("allow_login_ip").getConfigValue();
                String forbidIp = this.iSysBaseConfigService.getSysBaseConfig("forbid_login_ip").getConfigValue();
                if (ToolUtil.isEmpty((Object)allowIp) && ToolUtil.isEmpty((Object)forbidIp)) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)allowIp) && ((allowIpList = Arrays.asList(allowIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (ToolUtil.isNotEmpty((Object)forbidIp) && !flag && (!(forbidIpList = Arrays.asList(forbidIp.split(","))).contains(loginIp) || "127.0.0.1".equals(loginIp))) {
                    flag = true;
                }
                if (!flag) {
                    LoginExceptionMailUtil.sendIPLimitMail((String)sysUsers.getUserName(), (String)sysUsers.getUserAccount(), (String)loginIp);
                    throw new HussarException(sysUsers.getUserName() + "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55");
                }
            }
            if ("0".equals(loginTimeLimt = this.iSysBaseConfigService.getSysBaseConfig("login_time_limit").getConfigValue())) {
                boolean flag = false;
                Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
                String startTime = this.iSysBaseConfigService.getSysBaseConfig("login_start_time").getConfigValue();
                String endTime = this.iSysBaseConfigService.getSysBaseConfig("login_end_time").getConfigValue();
                try {
                    Date dt1 = df.parse(startTime);
                    Date dt2 = df.parse(endTime);
                    Date now = df.parse(df.format(date));
                    if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
                        flag = true;
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (!flag) {
                    throw new LoginTimeRefuseException(sysUsers.getUserName(), "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55", "timeForbiddenLogin");
                }
            }
        }
        if (this.globalProperties.getLoginTimeLimit().booleanValue() && "1".equals(sysUsers.getLoginTimeLimit())) {
            boolean flag = false;
            Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            String startTime = sysUsers.getAccessLoginStartTime();
            String endTime = sysUsers.getAccessLoginEndTime();
            try {
                Date dt1 = df.parse(startTime);
                Date dt2 = df.parse(endTime);
                Date now = df.parse(df.format(date));
                if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
                    flag = true;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (!flag) {
                throw new LoginTimeRefuseException(sysUsers.getUserName(), "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55", "timeForbiddenLogin");
            }
        }
        if (this.globalProperties.getLoginIpLimit().booleanValue() && "1".equals(sysUsers.getLoginIpLimit())) {
            boolean canLogin = false;
            String loginIp = HttpKit.getIp();
            List list = this.iSysUserIpService.selectUserIp(sysUsers.getId());
            for (String ip : list) {
                if (!StringUtils.equals((CharSequence)loginIp, (CharSequence)ip)) continue;
                canLogin = true;
                break;
            }
            if (!canLogin) {
                throw new LoginIpRefuseException(sysUsers.getUserName(), "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55", "ipForbiddenLogin");
            }
        }
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        sysBaseConfig = iSysBaseConfigService.getSysBaseConfig("fail_number");
        String tryLoginTime = sysBaseConfig.getConfigValue();
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = this.dynamicDataSourceService.currentDsName();
        String password = authcDto.getCipher();
        String encPwd = this.credentialsMatcher.passwordEncode(password.getBytes());
        String userName = authcDto.getUsername();
        if (this.globalProperties.isTenantOpen() ? loginLock.userIsLock(userName, connName) : loginLock.userIsLock(userName)) {
            throw new HussarDisabledAccountException(userName, "\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
        }
        if (ToolUtil.isEmpty((Object)encPwd) || !encPwd.equalsIgnoreCase(sysUsers.getPassword())) {
            int loginChanceTime;
            int loginChance;
            if (this.globalProperties.isTenantOpen()) {
                loginLock.addUserCache(userName, connName, Integer.parseInt(tryLoginTime));
                loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userName, connName);
            } else {
                loginLock.addUserCache(userName, Integer.parseInt(tryLoginTime));
                loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userName);
            }
            int n = loginChanceTime = loginChance < 0 ? 0 : loginChance;
            if (loginChanceTime == 0) {
                this.iSysUsersService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"account_status", (Object)UserStatus.PWD_LOCK.getCode())).eq((Object)"user_account", (Object)userName));
                LoginExceptionMailUtil.sendLockMail((String)userName);
                throw new HussarCredentialsException(userName, "\u5f53\u524d\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff01");
            }
            throw new HussarCredentialsException(userName, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a", "nameOrPWDError", Integer.valueOf(loginChanceTime));
        }
    }

    private SecurityUser getLoginSecurityUser(SysUsers sysUsers) {
        String connName;
        SecurityUser securityUser = new SecurityUser();
        if (this.globalProperties.isTenantOpen() && ToolUtil.isNotEmpty((Object)(connName = this.dynamicDataSourceService.currentDsName()))) {
            SysTenant tenant;
            securityUser.setConnName(connName);
            if ("master".equals(connName)) {
                securityUser.setTenantCode("000000");
                tenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new QueryWrapper().eq((Object)"TENANT_CODE", (Object)"000000"));
                if (ToolUtil.isNotEmpty((Object)tenant)) {
                    securityUser.setTenantId(String.valueOf(tenant.getId()));
                    securityUser.setTenantName(tenant.getTenantName());
                    securityUser.setTenantCipher(String.valueOf(tenant.getBpmTenantCipher()));
                }
            } else {
                tenant = this.sysTenantService.queryTenantByConnName(connName);
                if (ToolUtil.isNotEmpty((Object)tenant)) {
                    securityUser.setTenantCode(tenant.getTenantCode());
                    securityUser.setTenantId(String.valueOf(tenant.getId()));
                    securityUser.setTenantCipher(String.valueOf(tenant.getBpmTenantCipher()));
                }
            }
        }
        securityUser.setId(sysUsers.getId());
        securityUser.setAccount(sysUsers.getUserAccount());
        securityUser.setDeptId(sysUsers.getDepartmentId());
        securityUser.setEmployeeId(sysUsers.getEmployeeId());
        securityUser.setDeptName(this.getDeptName(sysUsers.getDepartmentId()));
        securityUser.setName(sysUsers.getUserName());
        securityUser.setSecurityLevel(sysUsers.getSecurityLevel());
        securityUser.setAccountStatus(sysUsers.getAccountStatus());
        List<Long> rolesList = this.getRolesIdByUserId(sysUsers.getId());
        Long employeeId = sysUsers.getEmployeeId();
        Long departmentId = sysUsers.getDepartmentId();
        if (ToolUtil.isNotEmpty((Object)employeeId) && ToolUtil.isNotEmpty((Object)departmentId)) {
            List<Long> roleList = this.getRolesIdByStruId(sysUsers.getDepartmentId());
            rolesList.addAll(roleList);
        }
        securityUser.setRolesList(rolesList);
        return securityUser;
    }

    private String getDeptName(Long deptId) {
        SysOrganVo dept = this.iSysStruService.getOrgInfoByOrgId(deptId);
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    private List<Long> getRolesIdByUserId(Long userId) {
        return this.iSysUserRoleService.getRolesByUserId(userId);
    }

    private List<Long> getRolesIdByStruId(Long struId) {
        return this.iSysStruRoleService.getRolesByStruId(struId);
    }

    private void verifyCode(AuthcDto authcDto) {
        Boolean isKaptcha = "index".equals(authcDto.getIsIndex()) ? this.globalProperties.isLoginViewKaptcha() : this.hussarProperties.getKaptchaOpen().booleanValue();
        if (isKaptcha.booleanValue()) {
            String kaptcha = authcDto.getKaptcha();
            String code = (String)HttpKit.getRequest().getSession().getAttribute("KAPTCHA_SESSION_KEY");
            if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
                HttpKit.getRequest().getSession().setAttribute("KAPTCHA_SESSION_KEY", (Object)this.producer.createText());
                throw new HussarException("\u9a8c\u8bc1\u7801\u9519\u8bef");
            }
        }
    }
}

