/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.config;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.security.core.exception.NotLoginException;
import com.jxdinfo.hussar.support.security.core.router.SecurityRouter;
import com.jxdinfo.hussar.support.security.core.stp.SecurityUtil;
import com.jxdinfo.hussar.support.security.interceptor.SecurityAnnotationInterceptor;
import com.jxdinfo.hussar.support.security.interceptor.SecurityRouteInterceptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnProperty(prefix="hussar", name={"login-method"}, havingValue="default", matchIfMissing=false)
public class SecurityTokenConfigure
implements WebMvcConfigurer {
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    private static final Logger logger = LoggerFactory.getLogger(SecurityTokenConfigure.class);

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new SecurityAnnotationInterceptor()).addPathPatterns(new String[]{"/**"});
        ArrayList whiteList = new ArrayList();
        whiteList.addAll(this.hussarBaseProperties.getDefaultSecurityWhitelist());
        whiteList.addAll(this.hussarBaseProperties.getSecurityWhitelist());
        String[] whiteListArr = new String[whiteList.size()];
        whiteList.toArray(whiteListArr);
        registry.addInterceptor((HandlerInterceptor)new SecurityRouteInterceptor((req, res, handler) -> SecurityRouter.match((String[])new String[]{"/**"}).notMatch(whiteListArr).check(() -> {
            try {
                SecurityUtil.checkLogin();
            }
            catch (NotLoginException e) {
                logger.error("\u767b\u5f55\u68c0\u67e5\u5f02\u5e38:{} ", (Object)e.getMessage());
                HttpServletResponse response = HttpKit.getResponse();
                response.setCharacterEncoding("UTF-8");
                try {
                    PrintWriter out = response.getWriter();
                    out.println(JSON.toJSONString((Object)ApiResponse.fail((int)BaseExceptionEnum.LOGIN_INVALID.getCode(), (String)e.getMessage())));
                    out.flush();
                    out.close();
                }
                catch (IOException ioe) {
                    logger.error("\u7528\u6237\u767b\u5f55\u5931\u6548\u65f6\u8fd4\u56de\u6307\u5b9a\u72b6\u6001\u7801\u5f02\u5e38:{}", (Object)ioe.getMessage(), (Object)ioe);
                }
                throw e;
            }
        }))).addPathPatterns(new String[]{"/**"});
    }
}

